/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.IOException;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.spelt.QuerySpeller;
import org.apache.lucene.spelt.SpellReadWriteTest;

public class QuerySpellerTest
extends SpellReadWriteTest {
    private QuerySpeller speller;

    protected void setUp() throws Exception {
        super.setUp();
        this.speller = new QuerySpeller(this.reader);
    }

    public void testSingleWords() throws IOException {
        this.checkSuggestion("London", null);
        this.checkSuggestion("newspapers", null);
        this.checkSuggestion("asdfkjlh", null);
        this.checkSuggestion("the", null);
        this.checkSuggestion("and", null);
        this.checkSuggestion("newpapers", "newspapers");
        this.checkSuggestion("newspaper", "newspapers");
        this.checkSuggestion("bck", "buck");
        this.checkSuggestion("bcuk", "buck");
        this.checkSuggestion("Newpapers", "Newspapers");
        this.checkSuggestion("NEWPAPERS", "NEWSPAPERS");
        this.checkSuggestion("Bck", "Buck");
    }

    public void testMultiWords() throws IOException {
        this.checkSuggestion("news papers", "newspapers");
        this.checkSuggestion("\"news papers\"", "newspapers");
        this.checkSuggestion("readnewspapers", "\"read newspapers\"");
        this.checkSuggestion("readn ewspapers", "read newspapers");
        this.checkSuggestion("\"readn ewspapers\"", "\"read newspapers\"");
        this.checkSuggestion("orchards and bery patches", "orchards and berry patches");
    }

    private void checkSuggestion(String inQuery, String outQuery) throws IOException {
        try {
            String suggestion = this.speller.suggest(inQuery);
            QuerySpellerTest.assertEquals((String)outQuery, (String)suggestion);
        }
        catch (ParseException e) {
            throw new IOException(e.toString());
        }
    }
}

