/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.IOException;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.lazyTree.AttributeImpl;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.ParentNodeImpl;
import org.cdlib.xtf.util.PackedByteBuf;

public class ElementImpl
extends ParentNodeImpl {
    int nameSpace;
    int[] attrNames;
    String[] attrValues;

    public void init(int attrOffset, int nameSpace) throws IOException {
        this.nameSpace = nameSpace;
        if (attrOffset >= 0) {
            this.document.attrFile.seek(attrOffset);
            this.document.attrFile.read(this.document.attrBytes);
            PackedByteBuf buf = this.document.attrBuf;
            buf.setBytes(this.document.attrBytes);
            int nAttrs = buf.readInt();
            this.attrNames = new int[nAttrs];
            this.attrValues = new String[nAttrs];
            int i = 0;
            while (i < nAttrs) {
                int nameNum = buf.readInt();
                this.attrNames[i] = this.document.nameNumToCode[nameNum];
                this.attrValues[i] = buf.readString();
                ++i;
            }
        }
    }

    public final int getNodeKind() {
        return 1;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getTypeAnnotation() {
        return this.document.getTypeAnnotation(this.nodeNum);
    }

    public void sendNamespaceDeclarations(Receiver out, boolean includeAncestors) throws XPathException {
        NodeInfo parent;
        if (!this.document.usesNamespaces) {
            return;
        }
        int ns = this.nameSpace;
        if (ns > 0) {
            while (ns < this.document.numberOfNamespaces && this.document.namespaceParent[ns] == this.nodeNum) {
                int nscode = this.document.namespaceCode[ns];
                out.namespace(nscode, 0);
                ++ns;
            }
        }
        if (includeAncestors && this.document.isUsingNamespaces() && (parent = this.getParent()) != null) {
            parent.sendNamespaceDeclarations(out, true);
        }
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return ElementImpl.getDeclaredNamespaces(this.document, this.nodeNum, this.nameSpace, buffer);
    }

    static int[] getDeclaredNamespaces(LazyDocument doc, int nodeNr, int nameSpace, int[] buffer) {
        int ns = nameSpace;
        if (ns > 0) {
            int count = 0;
            while (ns < doc.numberOfNamespaces && doc.namespaceParent[ns] == nodeNr) {
                ++count;
                ++ns;
            }
            if (count == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            if (count <= buffer.length) {
                System.arraycopy(doc.namespaceCode, nameSpace, buffer, 0, count);
                if (count < buffer.length) {
                    buffer[count] = -1;
                }
                return buffer;
            }
            int[] array = new int[count];
            System.arraycopy(doc.namespaceCode, nameSpace, array, 0, count);
            return array;
        }
        return NodeInfo.EMPTY_NAMESPACE_LIST;
    }

    public String getAttributeValue(int fingerprint) {
        if (this.attrNames == null) {
            return null;
        }
        int i = 0;
        while (i < this.attrNames.length) {
            if ((this.attrNames[i] & 0xFFFFF) == fingerprint) {
                return this.attrValues[i];
            }
            ++i;
        }
        return null;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        NodeInfo next;
        int childNamespaces;
        int typeCode;
        int n = typeCode = copyAnnotations ? this.getTypeAnnotation() : 630;
        if (locationId == 0 && out instanceof LocationCopier) {
            out.setSystemId(this.getSystemId());
            ((LocationCopier)out).setLineNumber(this.getLineNumber());
        }
        out.startElement(this.nameCode, typeCode, locationId, 0);
        if (whichNamespaces != 0) {
            this.sendNamespaceDeclarations(out, whichNamespaces == 2);
        }
        if (this.attrNames != null) {
            int i = 0;
            while (i < this.attrNames.length) {
                new AttributeImpl(this, i).copy(out, 0, copyAnnotations, locationId);
                ++i;
            }
        }
        out.startContent();
        AxisIterator children = this.iterateAxis((byte)3);
        int n2 = childNamespaces = whichNamespaces == 0 ? 0 : 1;
        while ((next = (NodeInfo)children.next()) != null) {
            next.copy(out, childNamespaces, copyAnnotations, locationId);
        }
        out.endElement();
    }
}

