/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.exec;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.saxonExt.exec.RunInstruction;
import org.cdlib.xtf.servletBase.TextServlet;

public class PipeImageInstruction
extends RunInstruction {
    public PipeImageInstruction(Expression command, int timeout, List args) {
        super(command, timeout, args);
    }

    public String getExpressionType() {
        return "exec:pipeImage";
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String[] argArray = this.gatherArgs(context);
        byte[] outBytes = this.runAndGrab(context, argArray);
        int[] pngHeader = new int[]{137, 80, 78, 71};
        int[] jpegHeader = new int[]{255, 216, 255, 224};
        boolean isPNG = true;
        boolean isJPEG = true;
        int i = 0;
        while (i < 4) {
            if (i >= outBytes.length || outBytes[i] != (byte)pngHeader[i]) {
                isPNG = false;
            }
            if (i >= outBytes.length || outBytes[i] != (byte)jpegHeader[i]) {
                isJPEG = false;
            }
            ++i;
        }
        if (!isPNG && !isJPEG) {
            this.dynamicError("Error: no PNG or JPEG returned by external command '" + this.command, "IMPI0001", context);
        }
        HttpServletResponse res = TextServlet.getCurResponse();
        if (isPNG) {
            res.setContentType("image/png");
        } else {
            res.setContentType("image/jpeg");
        }
        try {
            ServletOutputStream out = res.getOutputStream();
            out.write(outBytes);
        }
        catch (IOException e) {
            this.dynamicError("Exception while writing output stream", "IMPI0002", context);
        }
        return null;
    }
}

