/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.redirect;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.servletBase.TextServlet;

public class HttpErrorElement
extends ExtensionInstruction {
    Expression codeExp;
    Expression messageExp;

    public void prepareAttributes() throws XPathException {
        String codeAtt = this.getAttributeList().getValue("", "code");
        if (codeAtt == null) {
            this.reportAbsence("code");
            return;
        }
        this.codeExp = this.makeAttributeValueTemplate(codeAtt);
        String messageAtt = this.getAttributeList().getValue("", "message");
        if (messageAtt != null) {
            this.messageExp = this.makeAttributeValueTemplate(messageAtt);
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return new HttpErrorInstruction(this.codeExp, this.messageExp);
    }

    private class HttpErrorInstruction
    extends SimpleExpression {
        Expression codeExp;
        Expression messageExp;

        public HttpErrorInstruction(Expression codeExp, Expression messageExp) {
            this.codeExp = codeExp;
            this.messageExp = messageExp;
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "redirect:sendHttpError";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            HttpServletResponse res = TextServlet.getCurResponse();
            try {
                String codeStr = this.codeExp.evaluateAsString(context);
                int code = Integer.parseInt(codeStr);
                if (this.messageExp == null) {
                    res.sendError(code);
                } else {
                    res.sendError(code, this.messageExp.evaluateAsString(context));
                }
            }
            catch (IOException e) {
                throw new DynamicError(e);
            }
            catch (NumberFormatException e) {
                throw new DynamicError(e);
            }
            return null;
        }
    }
}

