/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import org.cdlib.xtf.saxonExt.sql.SQLConnect;

public class SQLProperty
extends XSLGeneralVariable {
    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        this.getVariableFingerprint();
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String nameAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            String localName = atts.getLocalName(a);
            if (localName.equals("name")) {
                nameAtt = atts.getValue(a).trim();
            } else if (localName.equals("select")) {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(atts.getNameCode(a));
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else if (!this.getConfiguration().getNameChecker().isQName(nameAtt)) {
            this.compileError("Property name must be a valid QName");
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof SQLConnect)) {
            this.compileError("parent node must be sql:connect");
        }
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, "sql:property/select", 0, null);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_ATOMIC, false, role, this.getStaticContext());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public String getPropertyName() {
        return Navigator.getAttributeValue(this, "", "name");
    }

    public Expression compile(Executable exec) throws XPathException {
        PropertyInstruction inst = new PropertyInstruction(this.getPropertyName());
        this.initializeInstruction(exec, inst);
        return inst;
    }

    protected static class PropertyInstruction
    extends GeneralVariable {
        private String name;

        public PropertyInstruction(String name) {
            this.name = name;
        }

        public String getPropertyName() {
            return this.name;
        }

        public InstructionInfo getInstructionInfo() {
            InstructionDetails details = (InstructionDetails)super.getInstructionInfo();
            details.setConstructType(2005);
            return details;
        }

        public TailCall processLeavingTail(XPathContext context) {
            return null;
        }

        public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
            throw new UnsupportedOperationException();
        }
    }
}

