/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.cdlib.xtf.textEngine.NumericFieldData;

public class NumericRangeQuery
extends Query {
    private final String fieldName;
    private final boolean includeLower;
    private final String lowerVal;
    private final boolean includeUpper;
    private final String upperVal;

    public NumericRangeQuery(String fieldName, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        if ("".equals(lowerVal)) {
            lowerVal = null;
        }
        if ("".equals(upperVal)) {
            upperVal = null;
        }
        this.fieldName = fieldName.intern();
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public String getField() {
        return this.fieldName;
    }

    public String getLowerVal() {
        return this.lowerVal;
    }

    public String getUpperVal() {
        return this.upperVal;
    }

    public boolean includesLower() {
        return this.includeLower;
    }

    public boolean includesUpper() {
        return this.includeUpper;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    protected Weight createWeight(Searcher searcher) {
        return new NumericRangeWeight(this, searcher);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.includeLower ? (char)'[' : '{');
        buffer.append(this.lowerVal != null ? this.lowerVal : "*");
        buffer.append(" TO ");
        buffer.append(this.upperVal != null ? this.upperVal : "*");
        buffer.append(this.includeUpper ? (char)']' : '}');
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericRangeQuery)) {
            return false;
        }
        NumericRangeQuery other = (NumericRangeQuery)o;
        if (this.fieldName != other.fieldName || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        if (this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null) {
            return false;
        }
        return this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.getBoost()) ^ this.fieldName.hashCode();
        h ^= this.lowerVal != null ? this.lowerVal.hashCode() : -1772448166;
        h ^= h << 17 | h >>> 16;
        h ^= this.upperVal != null ? this.upperVal.hashCode() : 1516853865;
        return h ^= (this.includeLower ? 1716885930 : 0) ^ (this.includeUpper ? -1716890266 : 0);
    }

    private class NumericRangeScorer
    extends Scorer {
        final NumericFieldData data;
        final float theScore;
        final int dataSize;
        final boolean checkLower;
        final long lowerNum;
        final boolean checkUpper;
        final long upperNum;
        int dataPos;

        public NumericRangeScorer(Similarity similarity, IndexReader reader, Weight w) throws IOException {
            super(similarity);
            this.dataPos = -1;
            this.theScore = w.getValue();
            this.data = NumericFieldData.getCachedData(reader, NumericRangeQuery.this.fieldName);
            this.dataSize = this.data.size();
            this.checkLower = NumericRangeQuery.this.lowerVal != null;
            this.lowerNum = this.checkLower ? NumericFieldData.parseVal(NumericRangeQuery.this.lowerVal) : -1L;
            this.checkUpper = NumericRangeQuery.this.upperVal != null;
            this.upperNum = this.checkUpper ? NumericFieldData.parseVal(NumericRangeQuery.this.upperVal) : -1L;
        }

        public boolean next() throws IOException {
            do {
                ++this.dataPos;
            } while (this.dataPos < this.dataSize && !this.inRange(this.dataPos));
            return this.dataPos < this.dataSize;
        }

        public final boolean inRange(int dataPos) {
            long value = this.data.value(dataPos);
            if (this.checkLower) {
                if (value < this.lowerNum) {
                    return false;
                }
                if (value == this.lowerNum && !NumericRangeQuery.this.includeLower) {
                    return false;
                }
            }
            if (this.checkUpper) {
                if (value > this.upperNum) {
                    return false;
                }
                if (value == this.upperNum && !NumericRangeQuery.this.includeUpper) {
                    return false;
                }
            }
            return true;
        }

        public int docPos(int doc) {
            return this.data.docPos(doc);
        }

        public int doc() {
            return this.data.doc(this.dataPos);
        }

        public float score() throws IOException {
            return this.theScore;
        }

        public boolean skipTo(int target) throws IOException {
            this.dataPos = Math.max(this.dataPos, this.data.findDocIndex(target) - 1);
            return this.next();
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class NumericRangeWeight
    implements Weight {
        private NumericRangeQuery query;
        private Similarity similarity;
        private float queryNorm;
        private float queryWeight;

        public NumericRangeWeight(NumericRangeQuery query, Searcher searcher) {
            this.similarity = NumericRangeQuery.this.getSimilarity(searcher);
        }

        public Query getQuery() {
            return NumericRangeQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = NumericRangeQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new NumericRangeScorer(this.similarity, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            NumericRangeScorer cs = (NumericRangeScorer)this.scorer(reader);
            int docPos = cs.docPos(doc);
            boolean inRange = docPos >= 0 ? cs.inRange(docPos) : false;
            Explanation result = new Explanation();
            if (inRange) {
                result.setDescription("NumericRangeQuery(" + this.query.toString() + "), product of:");
                result.setValue(this.queryWeight);
                result.addDetail(new Explanation(NumericRangeQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription("NumericRangeQuery(" + this.query.toString() + ") doesn't match id " + doc);
                result.setValue(0.0f);
            }
            return result;
        }
    }
}

