/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.FSDirectory;
import org.cdlib.xtf.textEngine.NativeFSDirectory;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IdxTreeOptimizer {
    public void processDir(File dir) throws Exception {
        if (dir.getAbsoluteFile().isDirectory()) {
            if (IndexReader.indexExists(dir.getAbsoluteFile())) {
                this.optimizeIndex(dir);
            } else {
                String[] files = dir.getAbsoluteFile().list();
                int i = 0;
                while (i < files.length) {
                    this.processDir(new File(dir, files[i]));
                    ++i;
                }
            }
            return;
        }
    }

    public void optimizeIndex(File idxDirToOptimize) throws Exception {
        String path = Path.normalizePath(idxDirToOptimize.toString());
        Trace.info("Index: [" + path + "] ... ");
        Trace.tab();
        try {
            FSDirectory dir = NativeFSDirectory.getDirectory(idxDirToOptimize);
            IndexWriter indexWriter = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(), false);
            indexWriter.optimize();
            indexWriter.close();
            Trace.more(4, "Done.");
        }
        catch (Exception e) {
            Trace.error("*** Optimization Halted Due to Error:" + e);
            throw e;
        }
        Trace.untab();
    }
}

