/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.lucene.util.CountedInputStream;
import org.cdlib.xtf.textIndexer.IndexRecord;
import org.cdlib.xtf.textIndexer.IndexSource;
import org.cdlib.xtf.util.Normalizer;
import org.cdlib.xtf.util.StructuredStore;
import org.marc4j.marcxml.Converter;
import org.marc4j.marcxml.DoctypeDecl;
import org.marc4j.marcxml.MarcXmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MARCIndexSource
extends IndexSource {
    private File path;
    private String key;
    private Templates[] preFilters;
    private Templates displayStyle;
    private long fileSize = -1L;
    private CountedInputStream rawStream = null;
    private RecordHandler recordHandler;
    private boolean isDone = false;
    private int recordNum = 0;

    public MARCIndexSource(File path, String key, Templates[] preFilters, Templates displayStyle) {
        this.path = path;
        this.key = key;
        this.preFilters = preFilters;
        this.displayStyle = displayStyle;
        this.fileSize = path.length();
    }

    public File path() {
        return this.path;
    }

    public String key() {
        return this.key;
    }

    public Templates[] preFilters() {
        return this.preFilters;
    }

    public Templates displayStyle() {
        return this.displayStyle;
    }

    public long totalSize() {
        return this.fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexRecord nextRecord() throws SAXException, IOException {
        if (this.isDone) {
            return null;
        }
        this.openFile();
        String parsedMarcXML = null;
        RecordHandler recordHandler = this.recordHandler;
        synchronized (recordHandler) {
            while (true) {
                if (this.recordHandler.isDone) {
                    this.isDone = true;
                    break;
                }
                if (this.recordHandler.parsedMarcXML != null) {
                    parsedMarcXML = this.recordHandler.parsedMarcXML;
                    ++this.recordNum;
                    this.recordHandler.parsedMarcXML = null;
                    this.recordHandler.notifyAll();
                    break;
                }
                try {
                    this.recordHandler.wait();
                }
                catch (InterruptedException e) {
                    assert (false) : "how could this thread be interrupted??";
                    this.isDone = true;
                    break;
                }
            }
        }
        if (this.isDone) {
            return null;
        }
        final StringReader reader = new StringReader(parsedMarcXML);
        return new IndexRecord(){

            public InputSource xmlSource() throws IOException {
                return new InputSource(reader);
            }

            public int recordNum() {
                return MARCIndexSource.this.recordNum;
            }

            public int percentDone() {
                return (int)((MARCIndexSource.this.rawStream.nRead() + 1L) * 100L / MARCIndexSource.this.fileSize);
            }

            public StructuredStore lazyStore() {
                return null;
            }
        };
    }

    private void openFile() throws IOException {
        if (this.rawStream != null) {
            return;
        }
        this.rawStream = new CountedInputStream(new BufferedInputStream(new FileInputStream(this.path)));
        this.recordHandler = new RecordHandler();
        this.recordHandler.start();
    }

    private class RecordHandler
    extends Thread
    implements ContentHandler {
        public String parsedMarcXML = null;
        public boolean isDone = false;
        public Throwable error = null;
        private Vector prefixNames = new Vector();
        private Vector prefixUris = new Vector();
        private HashMap prefixUriToName = new HashMap();
        private StringBuffer buffer = new StringBuffer();
        private int recordNum = 0;

        private RecordHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block21: {
                try {
                    try {
                        while (true) {
                            long startPos = MARCIndexSource.this.rawStream.nRead();
                            try {
                                this.convertRecords();
                                long endPos = MARCIndexSource.this.rawStream.nRead();
                                if (endPos != startPos && this.skipBadRecord()) {
                                }
                                break;
                            }
                            catch (Throwable t) {
                                long endPos = MARCIndexSource.this.rawStream.nRead();
                                if (endPos == startPos) {
                                    throw t;
                                }
                                if (!this.skipBadRecord()) break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.error = t;
                        this.isDone = true;
                        RecordHandler recordHandler = this;
                        synchronized (recordHandler) {
                            this.notifyAll();
                            break block21;
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.isDone = true;
                    RecordHandler recordHandler = this;
                    synchronized (recordHandler) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
                this.isDone = true;
                RecordHandler recordHandler = this;
                synchronized (recordHandler) {
                    this.notifyAll();
                }
            }
        }

        private void convertRecords() throws Exception {
            InputStreamReader reader = new InputStreamReader((InputStream)MARCIndexSource.this.rawStream, "ISO8859_1");
            MarcXmlReader producer = new MarcXmlReader();
            try {
                producer.setProperty("http://marc4j.org/properties/document-type-declaration", (Object)new DoctypeDecl());
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            InputSource in = new InputSource(reader);
            SAXSource source = new SAXSource((XMLReader)producer, in);
            SAXResult marcXmlResult = new SAXResult(this);
            Converter converter = new Converter();
            converter.convert((Source)source, (Result)marcXmlResult);
        }

        private boolean skipBadRecord() throws IOException {
            int nSkipped = 0;
            while (true) {
                int ch;
                if ((ch = MARCIndexSource.this.rawStream.read()) < 0) {
                    System.err.flush();
                    System.out.println("Bad MARC data near end of file. Skipping.");
                    return false;
                }
                if (ch == 29) break;
                ++nSkipped;
            }
            if (nSkipped > 0) {
                System.err.flush();
                System.out.println("Bad MARC data near record " + this.recordNum + ". Attempting to resume.");
            }
            return true;
        }

        private void beginChunk() throws SAXException {
            this.buffer.setLength(0);
            this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            this.buffer.append("<record");
            int i = 0;
            while (i < this.prefixNames.size()) {
                String prefixName = (String)this.prefixNames.get(i);
                String prefixUri = (String)this.prefixUris.get(i);
                this.buffer.append(" xmlns");
                if (prefixName != null && prefixName.length() > 0) {
                    this.buffer.append(':');
                    this.buffer.append(prefixName);
                }
                this.buffer.append("=\"");
                this.buffer.append(prefixUri);
                this.buffer.append('\"');
                ++i;
            }
            this.buffer.append(">\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endChunk() throws SAXException {
            this.buffer.append("</record>\n");
            RecordHandler recordHandler = this;
            synchronized (recordHandler) {
                while (this.parsedMarcXML != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.parsedMarcXML = this.buffer.toString();
                ++this.recordNum;
                this.notifyAll();
            }
        }

        public void startDocument() throws SAXException {
            this.prefixNames.clear();
            this.prefixUris.clear();
            this.prefixUriToName.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("record")) {
                this.beginChunk();
                return;
            }
            this.buffer.append("<");
            if (qName != null) {
                this.buffer.append(qName);
            } else if (uri != null) {
                String prefix = (String)this.prefixUriToName.get(uri);
                assert (prefix != null) : "invalid URI??";
                this.buffer.append(prefix);
                this.buffer.append(':');
                this.buffer.append(localName);
            } else {
                this.buffer.append(localName);
            }
            int i = 0;
            while (i < atts.getLength()) {
                this.buffer.append(' ');
                if (atts.getQName(i) != null) {
                    this.buffer.append(atts.getQName(i));
                } else if (atts.getURI(i) != null) {
                    String prefix = (String)this.prefixUriToName.get(atts.getURI(i));
                    assert (prefix != null) : "invalid URI??";
                    this.buffer.append(prefix);
                    this.buffer.append(':');
                    this.buffer.append(atts.getLocalName(i));
                } else {
                    this.buffer.append(atts.getLocalName(i));
                }
                this.buffer.append("=\"");
                this.buffer.append(atts.getValue(i));
                this.buffer.append("\"");
                ++i;
            }
            this.buffer.append(">");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("record")) {
                this.endChunk();
                return;
            }
            this.buffer.append("</");
            if (qName != null) {
                this.buffer.append(qName);
            } else if (uri != null) {
                String prefix = (String)this.prefixUriToName.get(uri);
                assert (prefix != null) : "invalid URI??";
                this.buffer.append(prefix);
                this.buffer.append(':');
                this.buffer.append(localName);
            } else {
                this.buffer.append(localName);
            }
            this.buffer.append(">");
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String s2;
            String s = this.convertFromUTF8(ch, start, length);
            if (s != null) {
                ch = s.toCharArray();
                start = 0;
                length = ch.length;
            }
            boolean needNormalize = false;
            int needEscape = 0;
            int i = start;
            while (i < start + length) {
                if ((ch[i] & 0xFFFFFF80) != 0) {
                    needNormalize = true;
                }
                if (ch[i] == '&' || ch[i] == '<') {
                    ++needEscape;
                } else if (ch[i] < ' ' && ch[i] != '\t' && ch[i] != '\n' && ch[i] != '\r') {
                    ++needEscape;
                } else if (ch[i] >= '\ud800' && ch[i] <= '\udfff') {
                    ++needEscape;
                } else if (ch[i] >= '\ufffe' && ch[i] <= '\uffff') {
                    ++needEscape;
                }
                ++i;
            }
            if (needNormalize && !(s = new String(ch, start, length)).equals(s2 = Normalizer.normalize(s))) {
                ch = s2.toCharArray();
                start = 0;
                length = ch.length;
            }
            if (needEscape > 0) {
                int maxSpace = length + needEscape * 5;
                char[] newCh = new char[maxSpace];
                int dp = 0;
                int sp = start;
                while (sp < start + length) {
                    if (ch[sp] == '&') {
                        newCh[dp++] = 38;
                        newCh[dp++] = 97;
                        newCh[dp++] = 109;
                        newCh[dp++] = 112;
                        newCh[dp++] = 59;
                    } else if (ch[sp] == '<') {
                        newCh[dp++] = 38;
                        newCh[dp++] = 108;
                        newCh[dp++] = 116;
                        newCh[dp++] = 59;
                    } else if (!(ch[sp] < ' ' && ch[sp] != '\t' && ch[sp] != '\n' && ch[sp] != '\r' || ch[sp] >= '\ud800' && ch[sp] <= '\udfff' || ch[sp] >= '\ufffe' && ch[sp] <= '\uffff')) {
                        newCh[dp++] = ch[sp];
                    }
                    ++sp;
                }
                ch = newCh;
                start = 0;
                length = dp;
            }
            this.buffer.append(ch, start, length);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.prefixNames.add(prefix);
            this.prefixUris.add(uri);
            this.prefixUriToName.put(uri, prefix);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public String convertFromUTF8(char[] chars, int start, int length) {
            boolean foundUTF = false;
            int i = start;
            while (i < start + length) {
                char c = chars[i];
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                if (c > '\u007f') {
                    if (c >= '\u00c0' && c <= '\u00df' && i + 1 < chars.length && chars[i + 1] >= '\u0080' && chars[i + 1] <= '\u00bf') {
                        foundUTF = true;
                        ++i;
                    } else if (c >= '\u00e0' && c <= '\u00ef' && i + 2 < chars.length && chars[i + 1] >= '\u0080' && chars[i + 1] <= '\u00bf' && chars[i + 2] >= '\u0080' && chars[i + 2] <= '\u00bf') {
                        foundUTF = true;
                        i += 2;
                    } else if (c >= '\u00f0' && c <= '\u00f7' && i + 3 < chars.length && chars[i + 1] >= '\u0080' && chars[i + 1] <= '\u00bf' && chars[i + 2] >= '\u0080' && chars[i + 2] <= '\u00bf' && chars[i + 3] >= '\u0080' && chars[i + 3] <= '\u00bf') {
                        foundUTF = true;
                        i += 3;
                    } else {
                        if (c >= '\u0080' && c <= '\u00bf') {
                            return null;
                        }
                        if (c >= '\u00f8' && c <= '\u00ff') {
                            return null;
                        }
                    }
                }
                ++i;
            }
            if (!foundUTF) {
                return null;
            }
            try {
                String value = new String(chars, start, length);
                byte[] bytes = value.getBytes("ISO-8859-1");
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }
}

