/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.SubStoreWriter;

class SubFileWriter
extends SubStoreWriter {
    private RandomAccessFile file;
    private StructuredFile parent;
    private long segOffset;
    private long writtenPos = 0L;
    private static final int BUF_SIZE = 32768;
    private byte[] buf = new byte[32768];
    private int bufTop = 0;

    SubFileWriter(RandomAccessFile file, StructuredFile parent, long segOffset) throws IOException {
        this.file = file;
        this.parent = parent;
        this.segOffset = segOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(32768);
            this.parent.closeWriter(this);
            this.file = null;
        }
    }

    public long length() throws IOException {
        return this.writtenPos + (long)this.bufTop;
    }

    private void checkLength(int nBytes) throws IOException {
        if (this.parent.curSubFile != this) {
            this.file.seek(this.writtenPos + this.segOffset);
            this.parent.curSubFile = this;
        }
        if (this.bufTop + nBytes > 32768) {
            this.file.write(this.buf, 0, this.bufTop);
            this.writtenPos += (long)this.bufTop;
            this.bufTop = 0;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(len);
            if (len > 32768) {
                this.file.write(b, off, len);
                this.writtenPos += (long)len;
            } else {
                System.arraycopy(b, off, this.buf, this.bufTop, len);
                this.bufTop += len;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(int v) throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(1);
            this.buf[this.bufTop++] = (byte)(v & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(int v) throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(4);
            this.buf[this.bufTop++] = (byte)(v >>> 24 & 0xFF);
            this.buf[this.bufTop++] = (byte)(v >>> 16 & 0xFF);
            this.buf[this.bufTop++] = (byte)(v >>> 8 & 0xFF);
            this.buf[this.bufTop++] = (byte)(v >>> 0 & 0xFF);
        }
    }
}

