/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.util.Hashtable;
import org.cdlib.xtf.util.TagChars;
import org.cdlib.xtf.util.Tester;

public class TagArray {
    private int BLOCK_SIZE = 1048544;
    private byte[][] blocks = new byte[][]{new byte[this.BLOCK_SIZE]};
    private short nBlocks = 1;
    private byte[] curBlock = this.blocks[0];
    private int curBlockUsed = 0;
    private byte[] tagType = new byte[1];
    private short[] tagSubType = new short[1];
    private short[] tagBlock = new short[1];
    private int[] tagOffset = new int[1];
    private short[] tagLength = new short[1];
    private int nTags = 1;
    private Hashtable typeTable = new Hashtable();
    private int nTypes = 1;
    public static final Tester tester = new Tester("TagArray"){

        protected void testImpl() {
            TagArray array = new TagArray();
            int type1 = array.findType("type 1");
            int tag1 = array.add("hello", type1);
            int type1b = array.findType("type 1");
            int tag2 = array.add("foobar", type1b);
            int type2 = array.findType("type 2");
            int tag3 = array.add("bramble", type2);
            if (!$assertionsDisabled && type1b != type1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && type2 == type1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !array.getString(tag1).equals("hello")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.getType(tag1) != type1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !array.getString(tag2).equals("foobar")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.getType(tag2) != type1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !array.getString(tag3).equals("bramble")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.getType(tag3) != type2) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.prev(tag1) >= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.next(tag1) != tag2) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.prev(tag2) != tag1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.next(tag2) >= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.prev(tag3) >= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && array.next(tag3) >= 0) {
                throw new AssertionError();
            }
        }
    };

    public int findType(String t) {
        Integer lookup = (Integer)this.typeTable.get(t);
        if (lookup == null) {
            assert (this.nTypes < 127) : "Too many types allocated - change tagType from byte to short";
            lookup = new Integer(this.nTypes);
            this.typeTable.put(t, lookup);
            ++this.nTypes;
        }
        return lookup;
    }

    public final int add(String str, int type) {
        return this.add(str, type, 0);
    }

    public int add(String str, int type, int subType) {
        if (str.length() == 0) {
            return 0;
        }
        char[] srcChars = str.toCharArray();
        int length = srcChars.length;
        assert ((length & Short.MAX_VALUE) == length) : "String too long";
        assert (length <= this.BLOCK_SIZE) : "String too long";
        this.ensureCapacity(length);
        int tagId = this.allocateID();
        assert (type >= 0 && type < this.nTypes) : "Invalid tag type";
        this.tagType[tagId] = (byte)type;
        if (subType != 0) {
            if (this.tagSubType.length <= tagId) {
                short[] newSubType = new short[this.tagType.length];
                System.arraycopy(this.tagSubType, 0, newSubType, 0, this.tagSubType.length);
                this.tagSubType = newSubType;
            }
            assert ((subType & 0xFFFF) == subType) : "change subType array from short to int";
            this.tagSubType[tagId] = (short)subType;
        }
        this.tagBlock[tagId] = (short)(this.nBlocks - 1);
        this.tagLength[tagId] = (short)length;
        this.tagOffset[tagId] = this.curBlockUsed;
        int destPos = this.curBlockUsed;
        int i = 0;
        while (i < length) {
            char c = srcChars[i];
            this.curBlock[destPos++] = c < '\u0080' ? (byte)c : (byte)(c | 0x80);
            ++i;
        }
        this.curBlockUsed += length;
        return tagId;
    }

    public int size() {
        return this.nTags;
    }

    public String getString(int tag) {
        return this.getChars(tag).toString();
    }

    public final TagChars getChars(int tag) {
        return this.getChars(tag, new TagChars());
    }

    public TagChars getChars(int tag, TagChars chars) {
        assert (tag >= 0 && tag < this.nTags) : "Tag ID out of range";
        chars.length = this.tagLength[tag];
        chars.block = this.blocks[this.tagBlock[tag]];
        chars.offset = this.tagOffset[tag];
        return chars;
    }

    public int getType(int tag) {
        assert (tag >= 0 && tag < this.nTags) : "Tag ID out of range";
        return this.tagType[tag];
    }

    public short getSubType(int tag) {
        assert (tag >= 0 && tag < this.nTags) : "Tag ID out of range";
        if (tag >= this.tagSubType.length) {
            return 0;
        }
        return this.tagSubType[tag];
    }

    public int next(int tag) {
        assert (tag >= 0 && tag < this.nTags) : "Tag ID out of range";
        if (tag + 1 >= this.nTags) {
            return -1;
        }
        if (this.tagType[tag + 1] != this.tagType[tag]) {
            return -1;
        }
        return tag + 1;
    }

    public int prev(int tag) {
        assert (tag >= 0 && tag < this.nTags) : "Tag ID out of range";
        if (tag - 1 < 0) {
            return -1;
        }
        if (this.tagType[tag - 1] != this.tagType[tag]) {
            return -1;
        }
        return tag - 1;
    }

    public long byteSize() {
        return (long)(this.blocks.length * 8) + (long)this.nBlocks * (long)this.BLOCK_SIZE + (long)(this.tagType.length * 1) + (long)(this.tagBlock.length * 2) + (long)(this.tagOffset.length * 4) + (long)(this.tagLength.length * 2);
    }

    private int allocateID() {
        if (this.nTags == this.tagBlock.length) {
            int newSize = this.nTags * 2;
            byte[] newTagType = new byte[newSize];
            System.arraycopy(this.tagType, 0, newTagType, 0, this.nTags);
            this.tagType = newTagType;
            short[] newTagBlock = new short[newSize];
            System.arraycopy(this.tagBlock, 0, newTagBlock, 0, this.nTags);
            this.tagBlock = newTagBlock;
            int[] newTagOffset = new int[newSize];
            System.arraycopy(this.tagOffset, 0, newTagOffset, 0, this.nTags);
            this.tagOffset = newTagOffset;
            short[] newTagLength = new short[newSize];
            System.arraycopy(this.tagLength, 0, newTagLength, 0, this.nTags);
            this.tagLength = newTagLength;
        }
        return this.nTags++;
    }

    private void ensureCapacity(int nBytes) {
        if (this.curBlockUsed + nBytes > this.BLOCK_SIZE) {
            this.newBlock();
        }
    }

    private void newBlock() {
        if (this.nBlocks == this.blocks.length) {
            byte[][] newBlocks = new byte[this.blocks.length * 2][];
            System.arraycopy(this.blocks, 0, newBlocks, 0, this.nBlocks);
            this.blocks = newBlocks;
        }
        assert (this.nBlocks < Short.MAX_VALUE) : "Too many blocks - expand BLOCK_SIZE in code";
        this.blocks[this.nBlocks] = new byte[this.BLOCK_SIZE];
        this.curBlock = this.blocks[this.nBlocks];
        this.nBlocks = (short)(this.nBlocks + 1);
        this.curBlockUsed = 0;
    }
}

