/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.xslt;

import java.io.IOException;
import java.util.Stack;
import org.cdlib.xtf.servletBase.DTDSuppressingXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

class XMLStubReader
extends DTDSuppressingXMLReader {
    XMLStubReader() {
    }

    public void setContentHandler(ContentHandler handler) {
        StubContentHandler stubHandler = new StubContentHandler(handler);
        super.setContentHandler(stubHandler);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            StubLexicalHandler stubHandler = new StubLexicalHandler((LexicalHandler)value);
            super.setProperty(name, stubHandler);
        } else {
            super.setProperty(name, value);
        }
    }

    public void parse(InputSource input) throws IOException, SAXException {
        try {
            super.parse(input);
        }
        catch (GetOut getOut) {
            // empty catch block
        }
    }

    private class GetOut
    extends RuntimeException {
        private GetOut() {
        }
    }

    private class StubContentHandler
    implements ContentHandler {
        private ContentHandler out;
        private Stack<String[]> eventStack = new Stack();

        public StubContentHandler(ContentHandler out) {
            this.out = out;
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.eventStack.push(new String[]{"element", uri, localName, name});
            this.out.startElement(uri, localName, name, atts);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            while (!this.eventStack.isEmpty()) {
                String[] event = this.eventStack.pop();
                if (event[0].equals("element")) {
                    this.out.endElement(event[1], event[2], event[3]);
                    continue;
                }
                if (event[0].equals("prefix")) {
                    this.out.endPrefixMapping(event[1]);
                    continue;
                }
                assert (false);
            }
            this.out.endDocument();
            throw new GetOut();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.eventStack.push(new String[]{"prefix", prefix});
            this.out.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.out.endPrefixMapping(prefix);
            String[] event = this.eventStack.pop();
            assert (event[0].equals("prefix"));
            assert (event[1].equals(prefix));
        }

        public void startDocument() throws SAXException {
            this.out.startDocument();
        }

        public void endDocument() throws SAXException {
            this.out.endDocument();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.out.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.out.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.out.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.out.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.out.skippedEntity(name);
        }
    }

    private class StubLexicalHandler
    implements LexicalHandler {
        private LexicalHandler out;

        public StubLexicalHandler(LexicalHandler out) {
            this.out = out;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.out.startDTD(name, publicId, systemId);
            if (this.out instanceof DTDHandler && systemId != null) {
                try {
                    ((DTDHandler)((Object)this.out)).unparsedEntityDecl(name, publicId, systemId, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void endDTD() throws SAXException {
            this.out.endDTD();
        }

        public void startEntity(String name) throws SAXException {
            this.out.startEntity(name);
        }

        public void endEntity(String name) throws SAXException {
            this.out.endEntity(name);
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.out.comment(ch, start, length);
        }

        public void startCDATA() throws SAXException {
            this.out.startCDATA();
        }

        public void endCDATA() throws SAXException {
            this.out.endCDATA();
        }
    }
}

