/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.exist.client.CollectionXConf;
import org.exist.client.InteractiveClient;
import org.exist.client.PrettyXmldbURI;
import org.exist.client.ResourceDescriptor;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

class IndexDialog
extends JFrame {
    private static final String[] FULLTEXT_INDEX_ACTIONS = new String[]{"include", "exclude"};
    private static final String[] INDEX_TYPES = new String[]{"xs:boolean", "xs:integer", "xs:dateTime", "xs:string"};
    private CollectionXConf cx = null;
    private JComboBox cmbCollections;
    private JCheckBox chkDefaultAll;
    private JCheckBox chkAlphanum;
    private JCheckBox chkAttributes;
    private JTextField txtXPath;
    private JComboBox cmbxsType;
    private JTable tblFullTextIndexes;
    private FullTextIndexTableModel fulltextIndexModel;
    private JTable tblRangeIndexes;
    private RangeIndexTableModel rangeIndexModel;
    private JTable tblQNameIndexes;
    private QNameIndexTableModel qnameIndexModel;
    private InteractiveClient client;

    public IndexDialog(String title, InteractiveClient client) {
        super(title);
        this.client = client;
        WindowAdapter windowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                IndexDialog.this.saveChanges();
                IndexDialog.this.setVisible(false);
                IndexDialog.this.dispose();
            }
        };
        this.addWindowListener(windowListener);
        this.setupComponents();
        this.actionGetIndexes("/db");
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel label = new JLabel("Collection");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        ArrayList alCollections = new ArrayList();
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList alAllCollections = this.getCollections(root, new ArrayList());
            for (int i = 0; i < alAllCollections.size(); ++i) {
                if (alAllCollections.get(i).toString().indexOf("/db/system/config") != -1) continue;
                alCollections.add(alAllCollections.get(i));
            }
        }
        catch (XMLDBException e) {
            return;
        }
        this.cmbCollections = new JComboBox<Object>(alCollections.toArray());
        this.cmbCollections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.saveChanges();
                JComboBox cb = (JComboBox)e.getSource();
                IndexDialog.this.actionGetIndexes(cb.getSelectedItem().toString());
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(this.cmbCollections, c);
        this.getContentPane().add(this.cmbCollections);
        JPanel panelFullTextIndex = new JPanel();
        panelFullTextIndex.setBorder(new TitledBorder("Full Text Index"));
        GridBagLayout panelFullTextIndexGrid = new GridBagLayout();
        panelFullTextIndex.setLayout(panelFullTextIndexGrid);
        this.chkDefaultAll = new JCheckBox("Default All");
        this.chkDefaultAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.cx.setFullTextIndexDefaultAll(IndexDialog.this.chkDefaultAll.isSelected());
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelFullTextIndexGrid.setConstraints(this.chkDefaultAll, c);
        panelFullTextIndex.add(this.chkDefaultAll);
        this.chkAlphanum = new JCheckBox("Alphanumeric");
        this.chkAlphanum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.cx.setFullTextIndexAlphanum(IndexDialog.this.chkAlphanum.isSelected());
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelFullTextIndexGrid.setConstraints(this.chkAlphanum, c);
        panelFullTextIndex.add(this.chkAlphanum);
        this.chkAttributes = new JCheckBox("Attributes");
        this.chkAttributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.cx.setFullTextIndexAttributes(IndexDialog.this.chkAttributes.isSelected());
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelFullTextIndexGrid.setConstraints(this.chkAttributes, c);
        panelFullTextIndex.add(this.chkAttributes);
        this.fulltextIndexModel = new FullTextIndexTableModel();
        this.tblFullTextIndexes = new JTable(this.fulltextIndexModel);
        this.tblFullTextIndexes.setAutoResizeMode(1);
        this.tblFullTextIndexes.setSelectionMode(0);
        TableColumn colAction = this.tblFullTextIndexes.getColumnModel().getColumn(1);
        colAction.setCellEditor(new ComboBoxCellEditor(FULLTEXT_INDEX_ACTIONS));
        colAction.setCellRenderer(new ComboBoxCellRenderer(FULLTEXT_INDEX_ACTIONS));
        JScrollPane scrollFullTextIndexes = new JScrollPane(this.tblFullTextIndexes);
        scrollFullTextIndexes.setPreferredSize(new Dimension(250, 150));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelFullTextIndexGrid.setConstraints(scrollFullTextIndexes, c);
        panelFullTextIndex.add(scrollFullTextIndexes);
        Box fulltextIndexToolbarBox = Box.createHorizontalBox();
        JButton btnAddFullTextIndex = new JButton("Add");
        btnAddFullTextIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.actionAddFullTextIndex();
            }
        });
        fulltextIndexToolbarBox.add(btnAddFullTextIndex);
        JButton btnDeleteFullTextIndex = new JButton("Delete");
        btnDeleteFullTextIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.actionDeleteFullTextIndex();
            }
        });
        fulltextIndexToolbarBox.add(btnDeleteFullTextIndex);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        panelFullTextIndexGrid.setConstraints(fulltextIndexToolbarBox, c);
        panelFullTextIndex.add(fulltextIndexToolbarBox);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.3333333432674408;
        grid.setConstraints(panelFullTextIndex, c);
        this.getContentPane().add(panelFullTextIndex);
        JPanel panelRangeIndexes = new JPanel();
        panelRangeIndexes.setBorder(new TitledBorder("Range Indexes"));
        GridBagLayout panelRangeIndexesGrid = new GridBagLayout();
        panelRangeIndexes.setLayout(panelRangeIndexesGrid);
        this.rangeIndexModel = new RangeIndexTableModel();
        this.tblRangeIndexes = new JTable(this.rangeIndexModel);
        this.tblRangeIndexes.setAutoResizeMode(1);
        this.tblRangeIndexes.setSelectionMode(0);
        TableColumn colxsType = this.tblRangeIndexes.getColumnModel().getColumn(1);
        colxsType.setCellEditor(new ComboBoxCellEditor(INDEX_TYPES));
        colxsType.setCellRenderer(new ComboBoxCellRenderer(INDEX_TYPES));
        JScrollPane scrollRangeIndexes = new JScrollPane(this.tblRangeIndexes);
        scrollRangeIndexes.setPreferredSize(new Dimension(350, 150));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelRangeIndexesGrid.setConstraints(scrollRangeIndexes, c);
        panelRangeIndexes.add(scrollRangeIndexes);
        Box rangeIndexToolbarBox = Box.createHorizontalBox();
        JButton btnAddRangeIndex = new JButton("Add");
        btnAddRangeIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.actionAddRangeIndex();
            }
        });
        rangeIndexToolbarBox.add(btnAddRangeIndex);
        JButton btnDeleteRangeIndex = new JButton("Delete");
        btnDeleteRangeIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.actionDeleteRangeIndex();
            }
        });
        rangeIndexToolbarBox.add(btnDeleteRangeIndex);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelRangeIndexesGrid.setConstraints(rangeIndexToolbarBox, c);
        panelRangeIndexes.add(rangeIndexToolbarBox);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.3333333432674408;
        grid.setConstraints(panelRangeIndexes, c);
        this.getContentPane().add(panelRangeIndexes);
        JPanel panelQNameIndexes = new JPanel();
        panelQNameIndexes.setBorder(new TitledBorder("QName Indexes"));
        GridBagLayout panelQNameIndexesGrid = new GridBagLayout();
        panelQNameIndexes.setLayout(panelQNameIndexesGrid);
        this.qnameIndexModel = new QNameIndexTableModel();
        this.tblQNameIndexes = new JTable(this.qnameIndexModel);
        this.tblQNameIndexes.setAutoResizeMode(1);
        this.tblQNameIndexes.setSelectionMode(0);
        JScrollPane scrollQNameIndexes = new JScrollPane(this.tblQNameIndexes);
        scrollQNameIndexes.setPreferredSize(new Dimension(350, 150));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelQNameIndexesGrid.setConstraints(scrollQNameIndexes, c);
        panelQNameIndexes.add(scrollQNameIndexes);
        Box qnameIndexToolbarBox = Box.createHorizontalBox();
        JButton btnAddQNameIndex = new JButton("Add");
        btnAddQNameIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.actionAddQNameIndex();
            }
        });
        qnameIndexToolbarBox.add(btnAddQNameIndex);
        JButton btnDeleteQNameIndex = new JButton("Delete");
        btnDeleteQNameIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndexDialog.this.actionDeleteQNameIndex();
            }
        });
        qnameIndexToolbarBox.add(btnDeleteQNameIndex);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelQNameIndexesGrid.setConstraints(qnameIndexToolbarBox, c);
        panelQNameIndexes.add(qnameIndexToolbarBox);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.3333333432674408;
        grid.setConstraints(panelQNameIndexes, c);
        this.getContentPane().add(panelQNameIndexes);
        this.pack();
    }

    private void saveChanges() {
        int result;
        if (this.cx.hasChanged() && (result = JOptionPane.showConfirmDialog(this.getContentPane(), "The configuration for the collection has changed, would you like to save the changes?", "Save Changes", 0)) == 0) {
            if (this.cx.Save()) {
                result = JOptionPane.showConfirmDialog(this.getContentPane(), "Your changes have been saved, but will not take effect until the collection is reindexed!\n Would you like to reindex " + this.cmbCollections.getSelectedItem() + " and sub-collections now?", "Reindex", 0);
                if (result == 0) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                IndexQueryService service = (IndexQueryService)((IndexDialog)IndexDialog.this).client.current.getService("IndexQueryService", "1.0");
                                ArrayList subCollections = IndexDialog.this.getCollections(IndexDialog.this.client.getCollection((String)IndexDialog.this.cmbCollections.getSelectedItem()), new ArrayList());
                                for (int i = 0; i < subCollections.size(); ++i) {
                                    service.reindexCollection(((ResourceDescriptor)subCollections.get(i)).getName());
                                }
                                JOptionPane.showMessageDialog(IndexDialog.this.getContentPane(), "Reindex Complete");
                            }
                            catch (XMLDBException e) {
                                JOptionPane.showMessageDialog(IndexDialog.this.getContentPane(), "Reindex failed!");
                            }
                        }
                    };
                }
            } else {
                JOptionPane.showMessageDialog(this.getContentPane(), "Unable to save changes!");
            }
        }
    }

    private ArrayList getCollections(Collection root, ArrayList collectionsList) throws XMLDBException {
        collectionsList.add(new PrettyXmldbURI(XmldbURI.create(root.getName())));
        String[] childCollections = root.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child = root.getChildCollection(childCollections[i]);
            this.getCollections(child, collectionsList);
        }
        return collectionsList;
    }

    private void actionAddFullTextIndex() {
        this.fulltextIndexModel.addRow();
    }

    private void actionDeleteFullTextIndex() {
        int iSelectedRow = this.tblFullTextIndexes.getSelectedRow();
        if (iSelectedRow > -1) {
            this.fulltextIndexModel.removeRow(iSelectedRow);
        }
    }

    private void actionAddRangeIndex() {
        this.rangeIndexModel.addRow();
    }

    private void actionDeleteRangeIndex() {
        int iSelectedRow = this.tblRangeIndexes.getSelectedRow();
        if (iSelectedRow > -1) {
            this.rangeIndexModel.removeRow(iSelectedRow);
        }
    }

    private void actionAddQNameIndex() {
        this.qnameIndexModel.addRow();
    }

    private void actionDeleteQNameIndex() {
        int iSelectedRow = this.tblQNameIndexes.getSelectedRow();
        if (iSelectedRow > -1) {
            this.qnameIndexModel.removeRow(iSelectedRow);
        }
    }

    private void actionGetIndexes(String collectionName) {
        try {
            this.cx = new CollectionXConf(collectionName, this.client);
            this.chkDefaultAll.setSelected(this.cx.getFullTextIndexDefaultAll());
            this.chkAlphanum.setSelected(this.cx.getFullTextIndexAlphanum());
            this.chkAttributes.setSelected(this.cx.getFullTextIndexAttributes());
            this.fulltextIndexModel.fireTableDataChanged();
            this.rangeIndexModel.fireTableDataChanged();
            this.qnameIndexModel.fireTableDataChanged();
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
    }

    class QNameIndexTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"QName", "xsType"};

        public QNameIndexTableModel() {
            this.fireTableDataChanged();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    IndexDialog.this.cx.updateQNameIndex(rowIndex, aValue.toString(), null);
                    break;
                }
                case 1: {
                    IndexDialog.this.cx.updateQNameIndex(rowIndex, null, aValue.toString());
                    break;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void removeRow(int rowIndex) {
            IndexDialog.this.cx.deleteQNameIndex(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void addRow() {
            IndexDialog.this.cx.addQNameIndex("", "include");
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount() + 1);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return IndexDialog.this.cx != null ? IndexDialog.this.cx.getQNameIndexCount() : 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return IndexDialog.this.cx.getQNameIndex(rowIndex).getQName();
                }
                case 1: {
                    return IndexDialog.this.cx.getQNameIndex(rowIndex).getxsType();
                }
            }
            return null;
        }
    }

    class RangeIndexTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"XPath", "xsType"};

        public RangeIndexTableModel() {
            this.fireTableDataChanged();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    IndexDialog.this.cx.updateRangeIndex(rowIndex, aValue.toString(), null);
                    break;
                }
                case 1: {
                    IndexDialog.this.cx.updateRangeIndex(rowIndex, null, aValue.toString());
                    break;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void removeRow(int rowIndex) {
            IndexDialog.this.cx.deleteRangeIndex(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void addRow() {
            IndexDialog.this.cx.addRangeIndex("", "xs:string");
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount() + 1);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return IndexDialog.this.cx != null ? IndexDialog.this.cx.getRangeIndexCount() : 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return IndexDialog.this.cx.getRangeIndex(rowIndex).getXPath();
                }
                case 1: {
                    return IndexDialog.this.cx.getRangeIndex(rowIndex).getxsType();
                }
            }
            return null;
        }
    }

    class FullTextIndexTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"XPath", "action"};

        public FullTextIndexTableModel() {
            this.fireTableDataChanged();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    IndexDialog.this.cx.updateFullTextIndex(rowIndex, aValue.toString(), null);
                    break;
                }
                case 1: {
                    IndexDialog.this.cx.updateFullTextIndex(rowIndex, null, aValue.toString());
                    break;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void removeRow(int rowIndex) {
            IndexDialog.this.cx.deleteFullTextIndex(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void addRow() {
            IndexDialog.this.cx.addFullTextIndex("", "xs:string");
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount() + 1);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return IndexDialog.this.cx != null ? IndexDialog.this.cx.getFullTextPathCount() : 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return IndexDialog.this.cx.getFullTextIndexPath(rowIndex);
                }
                case 1: {
                    return IndexDialog.this.cx.getFullTextIndexPathAction(rowIndex);
                }
            }
            return null;
        }
    }

    public class ComboBoxCellEditor
    extends DefaultCellEditor {
        public ComboBoxCellEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public class ComboBoxCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ComboBoxCellRenderer(String[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

