/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.combine.CombiningAlgorithm;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyElementContainer;
import org.exist.client.xacml.PolicyElementNode;

public abstract class AbstractPolicyNode
extends PolicyElementNode
implements PolicyElementContainer {
    private String documentName;
    private CombiningAlgorithm originalAlgorithm;
    private CombiningAlgorithm algorithm;

    public AbstractPolicyNode(NodeContainer parent, AbstractPolicy policy) {
        this(parent, null, policy);
    }

    public AbstractPolicyNode(NodeContainer parent, String documentName, AbstractPolicy policy) {
        super(parent, (PolicyTreeElement)policy);
        this.documentName = documentName;
        this.originalAlgorithm = this.algorithm = policy.getCombiningAlg();
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public CombiningAlgorithm getCombiningAlgorithm() {
        return this.algorithm;
    }

    public void setCombiningAlgorithm(CombiningAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("Combining algorithm cannot be null");
        }
        this.algorithm = algorithm;
        this.fireChanged();
    }

    public boolean isModified(boolean deep) {
        return super.isModified(deep) || this.isAlgorithmModified();
    }

    public boolean isAlgorithmModified() {
        return !this.algorithm.getIdentifier().equals(this.originalAlgorithm.getIdentifier());
    }

    public void commit(boolean deep) {
        this.originalAlgorithm = this.algorithm;
        super.commit(deep);
    }

    public void revert(boolean deep) {
        this.algorithm = this.originalAlgorithm;
        super.revert(deep);
    }

    public void setDocumentName(String documentName) {
        if (this.documentName != null) {
            throw new IllegalStateException("Document name has already been set");
        }
        this.documentName = documentName;
    }
}

