/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.exist.client.xacml.NodeTransferable;
import org.exist.client.xacml.XACMLTreeNode;

public class NodeCopyAction
extends AbstractAction
implements ClipboardOwner {
    private JTree tree;
    private XACMLTreeNode contextNode;

    private NodeCopyAction() {
    }

    public NodeCopyAction(JTree tree) {
        super("Copy as XML");
        if (tree == null) {
            throw new NullPointerException("Tree cannot be null");
        }
        this.putValue("MnemonicKey", new Integer(67));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl C"));
        this.tree = tree;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public KeyStroke getTrigger() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public void actionPerformed(ActionEvent event) {
        XACMLTreeNode node;
        Object source = event.getSource();
        if (source == this.tree) {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            node = (XACMLTreeNode)path.getLastPathComponent();
        } else {
            node = this.contextNode;
        }
        if (node == null) {
            return;
        }
        NodeTransferable data = new NodeTransferable(node);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        clipboard.setContents(data, this);
        this.contextNode = null;
    }

    public void setContextNode(XACMLTreeNode contextNode) {
        this.contextNode = contextNode;
    }

    public void lostOwnership(Clipboard clipboard, Transferable data) {
    }
}

