/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.realm;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.exist.EXistException;
import org.exist.security.User;
import org.exist.security.XmldbPrincipal;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class XmldbRealm
extends RealmBase {
    private String basedir = ".";
    private String configuration = "conf.xml";
    private String uri = "xmldb:exist:///db";
    private String driver = "org.exist.xmldb.DatabaseImpl";
    private UserManagementService service = null;
    private User defaultUser = null;
    protected final String info = "XMLDBRealm/1.0";
    protected static final String name = "XMLDBRealm";

    public String getInfo() {
        return "XMLDBRealm/1.0";
    }

    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = (GenericPrincipal)this.getPrincipal(username);
        boolean validated = false;
        if (principal != null) {
            validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(principal.getPassword()) : this.digest(credentials).equals(principal.getPassword());
        }
        if (validated) {
            if (this.debug >= 2) {
                this.log(sm.getString("userDatabaseRealm.authenticateSuccess", (Object)username));
            }
            return principal;
        }
        if (this.debug >= 2) {
            this.log(sm.getString("userDatabaseRealm.authenticateFailure", (Object)username));
        }
        return null;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        GenericPrincipal principal = (GenericPrincipal)this.getPrincipal(username);
        if (principal != null) {
            return principal.getPassword();
        }
        return null;
    }

    protected Principal getPrincipal(String username) {
        User user = null;
        try {
            user = this.service.getUser(username);
        }
        catch (XMLDBException e) {
            // empty catch block
        }
        if (user == null) {
            user = this.defaultUser;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] groups = user.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            list.add(groups[i]);
        }
        return new DefaultXmldbPrinciple((Realm)this, username, user.getPassword(), list);
    }

    public synchronized void start() throws LifecycleException {
        try {
            User adminUser;
            URI existURI = new URI(this.uri);
            if ("".equals(existURI.getHost()) || existURI.getHost() == null) {
                this.startExistDb();
            }
            String driver = "org.exist.xmldb.DatabaseImpl";
            Class<?> cl = Class.forName(driver);
            DatabaseManager.registerDatabase((Database)((Database)cl.newInstance()));
            Collection collection = DatabaseManager.getCollection((String)this.uri);
            if (collection == null) {
                throw new LifecycleException("unable to resolve");
            }
            this.service = (UserManagementService)collection.getService("UserManagementService", "1.0");
            this.defaultUser = this.service.getUser("guest");
            boolean admin = true;
            if (admin && (adminUser = this.service.getUser("admin")).getPassword() == null) {
                adminUser.setPassword("admin");
                this.log("Update Admin User on inital start");
            }
        }
        catch (ClassNotFoundException e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        catch (XMLDBException e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        BrokerPool.stopAll(false);
    }

    public synchronized void startExistDb() throws LifecycleException {
        try {
            if (!BrokerPool.isConfigured()) {
                this.log("Starting Database");
                this.log("exist.home=" + this.basedir);
                File f = new File(this.basedir + File.separator + this.configuration);
                this.log("reading configuration from " + f.getAbsolutePath());
                if (!f.canRead()) {
                    throw new LifecycleException("configuration file " + this.configuration + " not found or not readable");
                }
                Configuration conf = new Configuration(this.configuration, this.basedir);
                BrokerPool.configure(1, 5, conf);
            }
        }
        catch (EXistException e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseConfigurationException e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected class DefaultXmldbPrinciple
    extends GenericPrincipal
    implements XmldbPrincipal {
        public DefaultXmldbPrinciple(Realm arg0, String arg1, String arg2, List arg3) {
            super(arg0, arg1, arg2, arg3);
        }
    }
}

