/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.LockToken;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.StringValue;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Put
extends AbstractWebDAVMethod {
    public Put(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        LOG.debug((Object)"PUT start");
        File tempFile = this.saveRequestContent(request);
        String url = tempFile.toURI().toASCIIString();
        String contentType = request.getContentType();
        DBBroker broker = null;
        Collection collection = null;
        boolean collectionLocked = true;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            Object is;
            MimeType mime;
            broker = this.pool.get(user);
            XmldbURI pathUri = path.lastSegment();
            XmldbURI collUri = path.removeLastSegment();
            LOG.debug((Object)("collUri='" + collUri + "';  path=" + pathUri + "';"));
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                transact.abort(txn);
                response.sendError(409, "Parent collection " + collUri + " not found");
                return;
            }
            if (collection.hasChildCollection(pathUri)) {
                transact.abort(txn);
                response.sendError(409, "Cannot overwrite an existing collection with a resource");
                return;
            }
            if (contentType == null) {
                mime = MimeTable.getInstance().getContentTypeFor(pathUri);
                if (mime != null) {
                    contentType = mime.getName();
                }
            } else {
                int p = contentType.indexOf(59);
                if (p > -1) {
                    contentType = StringValue.trimWhitespace(contentType.substring(0, p));
                }
                mime = MimeTable.getInstance().getContentType(contentType);
            }
            if (mime == null) {
                mime = MimeType.BINARY_TYPE;
            }
            LOG.debug((Object)("Storing document " + pathUri + "; content-type='" + contentType + "'"));
            DocumentImpl doc = null;
            if (mime.isXMLType()) {
                LOG.debug((Object)"Storing XML resource");
                if (tempFile.length() == 0L) {
                    LOG.debug((Object)"Create '0 byte' place for XML resource");
                    String txt = "<!-- place holder for null byte sized XML document --><null/>";
                    InputSource is2 = new InputSource(url);
                    IndexInfo info = collection.validateXMLResource(txn, broker, pathUri, txt);
                    doc = info.getDocument();
                    doc.getMetadata().setMimeType(contentType);
                    collection.store(txn, broker, info, txt, false);
                } else {
                    is = new InputSource(url);
                    IndexInfo info = collection.validateXMLResource(txn, broker, pathUri, (InputSource)is);
                    doc = info.getDocument();
                    doc.getMetadata().setMimeType(contentType);
                    collection.store(txn, broker, info, (InputSource)is, false);
                }
                LOG.debug((Object)"done");
            } else {
                LOG.debug((Object)"Storing binary resource");
                is = new FileInputStream(tempFile);
                doc = collection.addBinaryResource(txn, broker, pathUri, (InputStream)is, contentType, (int)tempFile.length());
                ((FileInputStream)is).close();
                LOG.debug((Object)"done");
            }
            LockToken token = doc.getMetadata().getLockToken();
            if (token != null) {
                token.setResourceType((byte)0);
            } else {
                LOG.debug((Object)"token==null");
            }
            transact.commit(txn);
            LOG.debug((Object)"PUT ready");
        }
        catch (EXistException e) {
            transact.abort(txn);
            LOG.error((Object)e);
            response.sendError(500, e.getMessage());
            return;
        }
        catch (PermissionDeniedException e) {
            transact.abort(txn);
            LOG.debug((Object)e);
            response.sendError(403, e.getMessage());
            return;
        }
        catch (TriggerException e) {
            transact.abort(txn);
            LOG.debug((Object)e);
            response.sendError(403, e.getMessage());
            return;
        }
        catch (SAXException e) {
            transact.abort(txn);
            LOG.debug((Object)e);
            response.sendError(400, e.getMessage());
            return;
        }
        catch (LockException e) {
            transact.abort(txn);
            LOG.debug((Object)e);
            response.sendError(409, e.getMessage());
            return;
        }
        finally {
            if (collectionLocked && collection != null) {
                collection.release(0);
            }
            this.pool.release(broker);
            tempFile.delete();
        }
        response.setStatus(201);
    }

    private File saveRequestContent(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        int len = request.getContentLength();
        File tempFile = File.createTempFile("existSRC", ".tmp");
        FileOutputStream fos = new FileOutputStream(tempFile);
        BufferedOutputStream os = new BufferedOutputStream(fos);
        if (len != 0) {
            int count;
            byte[] buffer = new byte[4096];
            int l = 0;
            do {
                if ((count = is.read(buffer)) <= 0) continue;
                os.write(buffer, 0, count);
            } while ((l += count) < len);
            os.close();
            is.close();
        }
        return tempFile;
    }
}

