/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import java.util.ArrayList;
import java.util.Arrays;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.memtree.AttributeImpl;
import org.exist.memtree.CDATASectionImpl;
import org.exist.memtree.CommentImpl;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.ElementImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NamespaceNode;
import org.exist.memtree.NodeImpl;
import org.exist.memtree.ProcessingInstructionImpl;
import org.exist.memtree.ReferenceNode;
import org.exist.memtree.TextImpl;
import org.exist.storage.serializers.Serializer;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.util.hashtable.NamePool;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DocumentImpl
extends NodeImpl
implements Document {
    protected XQueryContext context;
    protected NamePool namePool = new NamePool();
    protected short[] nodeKind = null;
    protected short[] treeLevel;
    protected int[] next;
    protected int[] nodeName;
    protected int[] alpha;
    protected int[] alphaLen;
    protected char[] characters;
    protected int nextChar = 0;
    protected int[] attrName;
    protected int[] attrParent;
    protected String[] attrValue;
    protected int nextAttr = 0;
    protected int[] namespaceParent;
    protected int[] namespaceCode;
    protected int nextNamespace = 0;
    protected int size = 1;
    protected int documentRootNode = -1;
    protected String documentURI = null;
    protected NodeProxy[] references;
    protected int nextRef = 0;
    private static final int NODE_SIZE = 128;
    private static final int ATTR_SIZE = 64;
    private static final int CHAR_BUF_SIZE = 1024;
    private static final int REF_SIZE = 128;
    private Int2ObjectHashMap storedNodes = null;

    public DocumentImpl(XQueryContext context) {
        super(null, 0);
        this.context = context;
    }

    private void init() {
        this.nodeKind = new short[128];
        this.treeLevel = new short[128];
        this.next = new int[128];
        Arrays.fill(this.next, -1);
        this.nodeName = new int[128];
        this.alpha = new int[128];
        this.alphaLen = new int[128];
        Arrays.fill(this.alphaLen, -1);
        this.characters = new char[1024];
        this.attrName = new int[64];
        this.attrParent = new int[64];
        this.attrValue = new String[64];
        this.namespaceCode = new int[5];
        this.namespaceParent = new int[5];
        this.references = new NodeProxy[128];
        this.treeLevel[0] = 0;
        this.nodeKind[0] = 9;
        this.document = this;
    }

    public void reset() {
        this.size = 0;
        this.nextChar = 0;
        this.nextAttr = 0;
        this.nextRef = 0;
    }

    public int getSize() {
        return this.size;
    }

    public int addNode(short kind, short level, QName qname) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.size == this.nodeKind.length) {
            this.grow();
        }
        this.nodeKind[this.size] = kind;
        this.treeLevel[this.size] = level;
        this.nodeName[this.size] = qname != null ? this.namePool.add(qname) : -1;
        this.alpha[this.size] = -1;
        this.next[this.size] = -1;
        return this.size++;
    }

    public void addChars(int nodeNr, char[] ch, int start, int len) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alpha[nodeNr] = this.nextChar;
        this.alphaLen[nodeNr] = len;
        System.arraycopy(ch, start, this.characters, this.nextChar, len);
        this.nextChar += len;
    }

    public void addChars(int nodeNr, CharSequence s) {
        int len;
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextChar + (len = s.length()) >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alpha[nodeNr] = this.nextChar;
        this.alphaLen[nodeNr] = len;
        for (int i = 0; i < len; ++i) {
            this.characters[this.nextChar++] = s.charAt(i);
        }
    }

    public void appendChars(int nodeNr, char[] ch, int start, int len) {
        if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alphaLen[nodeNr] = this.alphaLen[nodeNr] + len;
        System.arraycopy(ch, start, this.characters, this.nextChar, len);
        this.nextChar += len;
    }

    public void appendChars(int nodeNr, CharSequence s) {
        int len = s.length();
        if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alphaLen[nodeNr] = this.alphaLen[nodeNr] + len;
        for (int i = 0; i < len; ++i) {
            this.characters[this.nextChar++] = s.charAt(i);
        }
    }

    public void addReferenceNode(int nodeNr, NodeProxy proxy) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextRef == this.references.length) {
            this.growReferences();
        }
        this.references[this.nextRef] = proxy;
        ++this.nextRef;
    }

    public void replaceReferenceNode(int nodeNr, CharSequence ch) {
        this.nodeKind[nodeNr] = 3;
        this.references[this.alpha[nodeNr]] = null;
        this.addChars(nodeNr, ch);
    }

    public int addAttribute(int nodeNr, QName qname, String value) throws DOMException {
        if (this.nodeKind == null) {
            this.init();
        }
        int prevAttr = this.nextAttr - 1;
        while (nodeNr > 0 && prevAttr > -1 && this.attrParent[prevAttr] == nodeNr) {
            QName prevQn;
            if (!(prevQn = (QName)this.namePool.get(this.attrName[prevAttr--])).equalsSimple(qname)) continue;
            throw new DOMException(10, "Error XQDY0025: element has more than one attribute '" + qname + "'");
        }
        if (this.nextAttr == this.attrName.length) {
            this.growAttributes();
        }
        qname.setNameType((byte)1);
        this.attrParent[this.nextAttr] = nodeNr;
        this.attrName[this.nextAttr] = this.namePool.add(qname);
        this.attrValue[this.nextAttr] = value;
        if (this.alpha[nodeNr] < 0) {
            this.alpha[nodeNr] = this.nextAttr;
        }
        return this.nextAttr++;
    }

    public int addNamespace(int nodeNr, QName qname) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextNamespace == this.namespaceCode.length) {
            this.growNamespaces();
        }
        this.namespaceCode[this.nextNamespace] = this.namePool.add(qname);
        this.namespaceParent[this.nextNamespace] = nodeNr;
        if (this.alphaLen[nodeNr] < 0) {
            this.alphaLen[nodeNr] = this.nextNamespace;
        }
        return this.nextNamespace++;
    }

    public short getTreeLevel(int nodeNr) {
        return this.treeLevel[nodeNr];
    }

    public int getLastNode() {
        return this.size - 1;
    }

    public short getNodeType(int nodeNr) {
        if (this.nodeKind == null || nodeNr < 0) {
            return -1;
        }
        return this.nodeKind[nodeNr];
    }

    private void grow() {
        int newSize = this.size * 3 / 2;
        short[] newNodeKind = new short[newSize];
        System.arraycopy(this.nodeKind, 0, newNodeKind, 0, this.size);
        this.nodeKind = newNodeKind;
        short[] newTreeLevel = new short[newSize];
        System.arraycopy(this.treeLevel, 0, newTreeLevel, 0, this.size);
        this.treeLevel = newTreeLevel;
        int[] newNext = new int[newSize];
        Arrays.fill(newNext, -1);
        System.arraycopy(this.next, 0, newNext, 0, this.size);
        this.next = newNext;
        int[] newNodeName = new int[newSize];
        System.arraycopy(this.nodeName, 0, newNodeName, 0, this.size);
        this.nodeName = newNodeName;
        int[] newAlpha = new int[newSize];
        System.arraycopy(this.alpha, 0, newAlpha, 0, this.size);
        this.alpha = newAlpha;
        int[] newAlphaLen = new int[newSize];
        Arrays.fill(newAlphaLen, -1);
        System.arraycopy(this.alphaLen, 0, newAlphaLen, 0, this.size);
        this.alphaLen = newAlphaLen;
    }

    private void growAttributes() {
        int size = this.attrName.length;
        int newSize = size * 3 / 2;
        int[] newAttrName = new int[newSize];
        System.arraycopy(this.attrName, 0, newAttrName, 0, size);
        this.attrName = newAttrName;
        int[] newAttrParent = new int[newSize];
        System.arraycopy(this.attrParent, 0, newAttrParent, 0, size);
        this.attrParent = newAttrParent;
        String[] newAttrValue = new String[newSize];
        System.arraycopy(this.attrValue, 0, newAttrValue, 0, size);
        this.attrValue = newAttrValue;
    }

    private void growReferences() {
        int size = this.references.length;
        int newSize = size * 3 / 2;
        NodeProxy[] newReferences = new NodeProxy[newSize];
        System.arraycopy(this.references, 0, newReferences, 0, size);
        this.references = newReferences;
    }

    private void growNamespaces() {
        int size = this.namespaceCode.length;
        int newSize = size * 3 / 2;
        int[] newCodes = new int[newSize];
        System.arraycopy(this.namespaceCode, 0, newCodes, 0, size);
        this.namespaceCode = newCodes;
        int[] newParents = new int[newSize];
        System.arraycopy(this.namespaceParent, 0, newParents, 0, size);
        this.namespaceParent = newParents;
    }

    public NodeImpl getAttribute(int nodeNr) throws DOMException {
        return new AttributeImpl(this, nodeNr);
    }

    public NodeImpl getNamespaceNode(int nodeNr) throws DOMException {
        return new NamespaceNode(this, nodeNr);
    }

    public NodeImpl getNode(int nodeNr) throws DOMException {
        NodeImpl node;
        if (nodeNr == 0) {
            return this;
        }
        if (nodeNr >= this.size) {
            throw new DOMException(3, "node not found");
        }
        switch (this.nodeKind[nodeNr]) {
            case 1: {
                node = new ElementImpl(this, nodeNr);
                break;
            }
            case 3: {
                node = new TextImpl(this, nodeNr);
                break;
            }
            case 8: {
                node = new CommentImpl(this, nodeNr);
                break;
            }
            case 7: {
                node = new ProcessingInstructionImpl(this, nodeNr);
                break;
            }
            case 4: {
                node = new CDATASectionImpl(this, nodeNr);
                break;
            }
            case 100: {
                node = new ReferenceNode(this, nodeNr);
                break;
            }
            default: {
                throw new DOMException(8, "node not found");
            }
        }
        return node;
    }

    public NodeImpl getLastAttr() {
        if (this.nextAttr == 0) {
            return null;
        }
        return new AttributeImpl(this, this.nextAttr - 1);
    }

    public Node getParentNode() {
        return null;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return null;
    }

    public Element getDocumentElement() {
        if (this.size == 1) {
            return null;
        }
        int nodeNr = 1;
        while (this.nodeKind[nodeNr] != 1) {
            if (this.next[nodeNr] < nodeNr) {
                return null;
            }
            nodeNr = this.next[nodeNr];
        }
        return (Element)((Object)this.getNode(nodeNr));
    }

    public Node getFirstChild() {
        if (this.size > 1) {
            return this.getNode(1);
        }
        return null;
    }

    public int getAttributesCountFor(int nodeNumber) {
        int count = 0;
        int attr = this.alpha[nodeNumber];
        if (-1 < attr) {
            while (attr < this.nextAttr && this.attrParent[attr++] == nodeNumber) {
                ++count;
            }
        }
        return count;
    }

    public int getNamespacesCountFor(int nodeNumber) {
        int count = 0;
        int ns = this.alphaLen[nodeNumber];
        if (-1 < ns) {
            while (ns < this.nextNamespace && this.namespaceParent[ns++] == nodeNumber) {
                ++count;
            }
        }
        return count;
    }

    public int getChildCountFor(int nr) {
        int count = 0;
        int nextNode = this.getFirstChildFor(nr);
        while (nextNode > nr) {
            ++count;
            nextNode = this.next[nextNode];
        }
        return count;
    }

    public int getFirstChildFor(int nodeNumber) {
        short level = this.treeLevel[nodeNumber];
        int nextNode = nodeNumber + 1;
        if (nextNode < this.size && this.treeLevel[nextNode] > level) {
            return nextNode;
        }
        return -1;
    }

    public int getNextSiblingFor(int nodeNumber) {
        int nextNr = this.next[nodeNumber];
        return nextNr < nodeNumber ? -1 : nextNr;
    }

    public int getParentNodeFor(int nodeNumber) {
        int nextNode = this.next[nodeNumber];
        while (nextNode > nodeNumber) {
            nextNode = this.next[nextNode];
        }
        return nextNode;
    }

    public Element createElement(String arg0) throws DOMException {
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String arg0) {
        return null;
    }

    public Comment createComment(String arg0) {
        return null;
    }

    public CDATASection createCDATASection(String arg0) throws DOMException {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String arg0, String arg1) throws DOMException {
        return null;
    }

    public Attr createAttribute(String arg0) throws DOMException {
        return null;
    }

    public EntityReference createEntityReference(String arg0) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        NodeListImpl nl = new NodeListImpl();
        for (int i = 1; i < this.size; ++i) {
            QName qn;
            if (this.nodeKind[i] != 1 || !(qn = (QName)this.namePool.get(this.nodeName[i])).getStringValue().equals(name)) continue;
            nl.add(this.getNode(i));
        }
        return nl;
    }

    public Node importNode(Node arg0, boolean arg1) throws DOMException {
        return null;
    }

    public Element createElementNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    public Attr createAttributeNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return null;
    }

    public Element getElementById(String arg0) {
        return null;
    }

    public Document getOwnerDocument() {
        return this;
    }

    public void copyTo(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        this.copyTo(node, receiver, false);
    }

    protected void copyTo(NodeImpl node, DocumentBuilderReceiver receiver, boolean expandRefs) throws SAXException {
        NodeImpl top = node;
        while (node != null) {
            this.copyStartNode(node, receiver, expandRefs);
            NodeImpl nextNode = node instanceof ReferenceNode ? null : (NodeImpl)node.getFirstChild();
            while (nextNode == null) {
                this.copyEndNode(node, receiver);
                if (top != null && top.nodeNumber == node.nodeNumber) break;
                nextNode = (NodeImpl)node.getNextSibling();
                if (nextNode != null || (node = (NodeImpl)node.getParentNode()) != null && (top == null || top.nodeNumber != node.nodeNumber)) continue;
                this.copyEndNode(node, receiver);
                nextNode = null;
                break;
            }
            node = nextNode;
        }
    }

    private void copyStartNode(NodeImpl node, DocumentBuilderReceiver receiver, boolean expandRefs) throws SAXException {
        int nr = node.nodeNumber;
        switch (node.getNodeType()) {
            case 1: {
                int ns;
                int attr;
                QName nodeName = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                receiver.startElement(nodeName, null);
                if (-1 < attr) {
                    for (attr = this.document.alpha[nr]; attr < this.document.nextAttr && this.document.attrParent[attr] == nr; ++attr) {
                        QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
                        receiver.attribute(attrQName, this.attrValue[attr]);
                    }
                }
                if (-1 >= (ns = this.document.alphaLen[nr])) break;
                XQueryContext context = receiver.getContext();
                while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr) {
                    QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                    receiver.addNamespaceNode(nsQName);
                    if ("xmlns".equals(nsQName.getLocalName())) {
                        context.declareInScopeNamespace("", nsQName.getNamespaceURI());
                    } else {
                        context.declareInScopeNamespace(nsQName.getLocalName(), nsQName.getNamespaceURI());
                    }
                    ++ns;
                }
                break;
            }
            case 3: {
                receiver.characters(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 4: {
                receiver.cdataSection(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 2: {
                QName attrQName = (QName)this.document.namePool.get(this.document.attrName[nr]);
                receiver.attribute(attrQName, this.attrValue[nr]);
                break;
            }
            case 8: {
                receiver.comment(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                String data = new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                receiver.processingInstruction(qn.getLocalName(), data);
                break;
            }
            case 100: {
                if (expandRefs) {
                    Serializer serializer = this.context.getBroker().getSerializer();
                    serializer.reset();
                    serializer.setProperty("sax-document-events", "false");
                    serializer.setReceiver(receiver);
                    serializer.toReceiver(this.document.references[this.document.alpha[nr]], false);
                    break;
                }
                receiver.addReferenceNode(this.document.references[this.document.alpha[nr]]);
            }
        }
    }

    private void copyEndNode(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        if (node.getNodeType() == 1) {
            receiver.endElement(node.getQName());
        }
    }

    public void expand() throws DOMException {
        DocumentImpl newDoc = this.expandRefs(null);
        this.copyDocContents(newDoc);
    }

    public DocumentImpl expandRefs(NodeImpl rootNode) throws DOMException {
        if (this.nextRef == 0) {
            return this;
        }
        MemTreeBuilder builder = new MemTreeBuilder(this.context);
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        try {
            NodeImpl node;
            builder.startDocument();
            NodeImpl nodeImpl = node = rootNode == null ? (NodeImpl)this.getFirstChild() : rootNode;
            while (node != null) {
                this.copyTo(node, receiver, true);
                node = (NodeImpl)node.getNextSibling();
            }
            receiver.endDocument();
        }
        catch (SAXException e) {
            throw new DOMException(11, e.getMessage());
        }
        return builder.getDocument();
    }

    private void copyDocContents(DocumentImpl newDoc) {
        this.namePool = newDoc.namePool;
        this.nodeKind = newDoc.nodeKind;
        this.treeLevel = newDoc.treeLevel;
        this.next = newDoc.next;
        this.nodeName = newDoc.nodeName;
        this.alpha = newDoc.alpha;
        this.alphaLen = newDoc.alphaLen;
        this.characters = newDoc.characters;
        this.nextChar = newDoc.nextChar;
        this.attrName = newDoc.attrName;
        this.attrParent = newDoc.attrParent;
        this.attrValue = newDoc.attrValue;
        this.nextAttr = newDoc.nextAttr;
        this.namespaceParent = newDoc.namespaceParent;
        this.namespaceCode = newDoc.namespaceCode;
        this.nextNamespace = newDoc.nextNamespace;
        this.size = newDoc.size;
        this.documentRootNode = newDoc.documentRootNode;
        this.references = newDoc.references;
        this.nextRef = newDoc.nextRef;
    }

    public void streamTo(Serializer serializer, NodeImpl node, Receiver receiver) throws SAXException {
        NodeImpl top = node;
        while (node != null) {
            this.startNode(serializer, node, receiver);
            NodeImpl nextNode = node instanceof ReferenceNode ? null : (NodeImpl)node.getFirstChild();
            while (nextNode == null) {
                this.endNode(node, receiver);
                if (top != null && top.nodeNumber == node.nodeNumber) break;
                nextNode = (NodeImpl)node.getNextSibling();
                if (nextNode != null || (node = (NodeImpl)node.getParentNode()) != null && (top == null || top.nodeNumber != node.nodeNumber)) continue;
                this.endNode(node, receiver);
                nextNode = null;
                break;
            }
            node = nextNode;
        }
    }

    private void startNode(Serializer serializer, NodeImpl node, Receiver receiver) throws SAXException {
        int nr = node.nodeNumber;
        switch (node.getNodeType()) {
            case 1: {
                int ns;
                QName nodeName = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                if (-1 < ns) {
                    for (ns = this.document.alphaLen[nr]; ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr; ++ns) {
                        QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                        if ("xmlns".equals(nsQName.getLocalName())) {
                            receiver.startPrefixMapping("", nsQName.getNamespaceURI());
                            continue;
                        }
                        receiver.startPrefixMapping(nsQName.getLocalName(), nsQName.getNamespaceURI());
                    }
                }
                AttrList attribs = null;
                int attr = this.document.alpha[nr];
                if (-1 < attr) {
                    attribs = new AttrList();
                    while (attr < this.document.nextAttr && this.document.attrParent[attr] == nr) {
                        QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
                        attribs.addAttribute(attrQName, this.attrValue[attr]);
                        ++attr;
                    }
                }
                receiver.startElement(nodeName, attribs);
                break;
            }
            case 3: {
                receiver.characters(new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]));
                break;
            }
            case 2: {
                QName attrQName = (QName)this.document.namePool.get(this.document.attrName[nr]);
                receiver.attribute(attrQName, this.attrValue[nr]);
                break;
            }
            case 8: {
                receiver.comment(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                String data = new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                receiver.processingInstruction(qn.getLocalName(), data);
                break;
            }
            case 4: {
                receiver.cdataSection(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 100: {
                serializer.toReceiver(this.document.references[this.document.alpha[nr]], true);
            }
        }
    }

    private void endNode(NodeImpl node, Receiver receiver) throws SAXException {
        if (node.getNodeType() == 1) {
            int ns;
            receiver.endElement(node.getQName());
            int nr = node.nodeNumber;
            if (-1 < ns) {
                for (ns = this.document.alphaLen[nr]; ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr; ++ns) {
                    QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                    if ("xmlns".equals(nsQName.getLocalName())) {
                        receiver.endPrefixMapping("");
                        continue;
                    }
                    receiver.endPrefixMapping(nsQName.getLocalName());
                }
            }
        }
    }

    public Int2ObjectHashMap makePersistent() throws XPathException {
        if (this.size <= 1) {
            return null;
        }
        ArrayList<Integer> oldIds = new ArrayList<Integer>(20);
        int top = 1;
        while (top > 0) {
            oldIds.add(new Integer(top));
            top = this.getNextSiblingFor(top);
        }
        DocumentImpl expandedDoc = this.expandRefs(null);
        org.exist.dom.DocumentImpl doc = this.context.storeTemporaryDoc(expandedDoc);
        org.exist.dom.ElementImpl root = (org.exist.dom.ElementImpl)doc.getDocumentElement();
        NodeList cl = root.getChildNodes();
        this.storedNodes = new Int2ObjectHashMap();
        this.storedNodes.put(0, new NodeProxy(doc, root.getNodeId(), root.getNodeType(), root.getInternalAddress()));
        top = 1;
        for (int i = 0; top > 0 && i < cl.getLength(); ++i) {
            StoredNode node = (StoredNode)cl.item(i);
            NodeProxy proxy = new NodeProxy(doc, node.getNodeId(), node.getNodeType(), node.getInternalAddress());
            int old = (Integer)oldIds.get(i);
            this.storedNodes.put(old, proxy);
            top = expandedDoc.getNextSiblingFor(top);
        }
        return this.storedNodes;
    }

    public int getChildCount() {
        int top;
        int count = 0;
        int n = top = this.size > 1 ? 1 : -1;
        while (top > 0) {
            ++count;
            top = this.getNextSiblingFor(top);
        }
        return count;
    }

    public String getLocalName() {
        return "";
    }

    public String getNamespaceURI() {
        return "";
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    public String getXmlVersion() {
        return null;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public void setContext(XQueryContext context) {
        this.context = context;
    }

    public String getBaseURI() {
        if (this.context.isBaseURIDeclared()) {
            try {
                return this.context.getBaseURI() + "";
            }
            catch (Exception e) {
                System.out.println("memtree/DocumentImpl::getBaseURI() exception catched: ");
            }
        }
        return XmldbURI.EMPTY_URI.toString();
    }

    public int getItemType() {
        return 6;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("in-memory#");
        result.append("document {");
        if (this.size != 1) {
            int nodeNr = 1;
            while (true) {
                result.append(this.getNode(nodeNr).toString());
                if (this.next[nodeNr] < nodeNr) break;
                nodeNr = this.next[nodeNr];
            }
        }
        result.append("} ");
        return result.toString();
    }
}

