/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.cluster.ClusterCollection;
import org.exist.cluster.ClusterComunication;
import org.exist.cluster.ClusterException;
import org.exist.collections.Collection;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.NativeBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.xmldb.XmldbURI;

public class NativeClusterBroker
extends NativeBroker {
    private static final Logger LOG = Logger.getLogger((Class)NativeClusterBroker.class);

    public NativeClusterBroker(BrokerPool pool, Configuration config) throws EXistException {
        super(pool, config);
    }

    public Collection openCollection(XmldbURI name, int lockMode) {
        Collection c = super.openCollection(name, lockMode);
        return c == null ? null : new ClusterCollection(c);
    }

    public void saveCollection(Txn transaction, Collection collection) throws PermissionDeniedException, IOException {
        super.saveCollection(transaction, new ClusterCollection(collection));
    }

    public Collection getOrCreateCollection(Txn transaction, XmldbURI uri) throws PermissionDeniedException, IOException {
        Collection c = super.getOrCreateCollection(transaction, uri);
        return c == null ? null : new ClusterCollection(c);
    }

    public void sync(int syncEvent) {
        super.sync(syncEvent);
        try {
            ClusterComunication cm = ClusterComunication.getInstance();
            if (cm != null) {
                cm.synch();
            }
        }
        catch (ClusterException e) {
            LOG.warn((Object)"ERROR IN JOURNAL SYNCHRONIZATION", (Throwable)e);
        }
    }
}

