/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.exist.source.Source;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.hashtable.Object2ObjectHashMap;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XQueryContext;

public class XQueryPool
extends Object2ObjectHashMap {
    public static final int MAX_POOL_SIZE = 128;
    public static final int MAX_STACK_SIZE = 5;
    public static final long TIMEOUT = 120000L;
    public static final long TIMEOUT_CHECK_INTERVAL = 30000L;
    private static final Logger LOG = Logger.getLogger((Class)XQueryPool.class);
    private long lastTimeOutCheck = System.currentTimeMillis();
    private int maxPoolSize;
    private int maxStackSize;
    private long timeout;
    private long timeoutCheckInterval;
    public static final String CONFIGURATION_ELEMENT_NAME = "query-pool";
    public static final String MAX_STACK_SIZE_ATTRIBUTE = "max-stack-size";
    public static final String POOL_SIZE_ATTTRIBUTE = "size";
    public static final String TIMEOUT_ATTRIBUTE = "timeout";
    public static final String TIMEOUT_CHECK_INTERVAL_ATTRIBUTE = "timeout-check-interval";
    public static final String PROPERTY_MAX_STACK_SIZE = "db-connection.query-pool.max-stack-size";
    public static final String PROPERTY_POOL_SIZE = "db-connection.query-pool.size";
    public static final String PROPERTY_TIMEOUT = "db-connection.query-pool.timeout";
    public static final String PROPERTY_TIMEOUT_CHECK_INTERVAL = "db-connection.query-pool.timeout-check-interval";

    public XQueryPool(Configuration conf) {
        super(27);
        Integer maxStSz = (Integer)conf.getProperty(PROPERTY_MAX_STACK_SIZE);
        Integer maxPoolSz = (Integer)conf.getProperty(PROPERTY_POOL_SIZE);
        Long t = (Long)conf.getProperty(PROPERTY_TIMEOUT);
        Long tci = (Long)conf.getProperty(PROPERTY_TIMEOUT_CHECK_INTERVAL);
        NumberFormat nf = NumberFormat.getNumberInstance();
        this.maxPoolSize = maxPoolSz != null ? maxPoolSz : 128;
        this.maxStackSize = maxStSz != null ? maxStSz : 5;
        this.timeout = t != null ? t : 120000L;
        this.timeoutCheckInterval = tci != null ? tci : 30000L;
        LOG.info((Object)("QueryPool: size = " + nf.format(this.maxPoolSize) + "; maxStackSize = " + nf.format(this.maxStackSize) + "; timeout = " + nf.format(this.timeout) + "; timeoutCheckInterval = " + nf.format(this.timeoutCheckInterval)));
    }

    public synchronized void returnCompiledXQuery(Source source, CompiledXQuery xquery) {
        if (this.size() < this.maxPoolSize) {
            Stack<CompiledXQuery> stack = (Stack<CompiledXQuery>)this.get(source);
            if (stack == null) {
                stack = new Stack<CompiledXQuery>();
                source.setCacheTimestamp(System.currentTimeMillis());
                this.put(source, stack);
            }
            if (stack.size() < this.maxStackSize) {
                stack.push(xquery);
            }
        }
        this.timeoutCheck();
    }

    public synchronized CompiledXQuery borrowCompiledXQuery(DBBroker broker, Source source) {
        int idx = this.getIndex(source);
        if (idx < 0) {
            return null;
        }
        Source key = (Source)this.keys[idx];
        int validity = key.isValid(broker);
        if (validity == 0) {
            validity = key.isValid(source);
        }
        if (validity == -1 || validity == 0) {
            this.keys[idx] = REMOVED;
            this.values[idx] = null;
            LOG.debug((Object)(source.getKey() + " is invalid"));
            return null;
        }
        Stack stack = (Stack)this.values[idx];
        if (stack != null && !stack.isEmpty()) {
            CompiledXQuery query = (CompiledXQuery)stack.pop();
            XQueryContext context = query.getContext();
            context.setBroker(broker);
            if (!query.isValid()) {
                this.remove(key);
                return null;
            }
            return query;
        }
        return null;
    }

    private void timeoutCheck() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeOutCheck < this.timeoutCheckInterval) {
            return;
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Source next = (Source)i.next();
            if (currentTime - next.getCacheTimestamp() <= this.timeout) continue;
            this.remove(next);
        }
    }
}

