/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

public class ProgressBar {
    protected String mMessage;
    protected double mMax = 1.0;
    protected int mPosition = 0;

    public ProgressBar(String message) {
        this.mMessage = message;
    }

    public ProgressBar(String message, double max) {
        this.mMessage = message;
        this.mMax = max;
    }

    public void set(double value, double max) {
        this.mMax = max;
        this.set(value);
    }

    public void set(double value) {
        int i;
        int percent = (int)(value / this.mMax * 100.0);
        if (percent % 2 > 0) {
            return;
        }
        int pos = percent / 2;
        if (pos == this.mPosition) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.mMessage);
        buf.append(" [");
        for (i = 0; i < pos; ++i) {
            buf.append("=");
        }
        while (i < 50) {
            buf.append(" ");
            ++i;
        }
        buf.append("] (");
        buf.append(percent);
        buf.append(" %)\r");
        System.out.print(buf.toString());
        this.mPosition = pos;
    }
}

