/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class Object2IntHashMap
extends AbstractHashtable {
    public static final int UNKNOWN_KEY = -1;
    protected Object[] keys;
    protected int[] values;

    public Object2IntHashMap() {
        this.keys = new Object[this.tabSize];
        this.values = new int[this.tabSize];
    }

    public Object2IntHashMap(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
        this.values = new int[this.tabSize];
    }

    public void put(Object key, int value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            Object[] copyKeys = this.keys;
            int[] copyValues = this.values;
            this.tabSize = (int)Object2IntHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.values = new int[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public int get(Object key) {
        int idx = Object2IntHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1;
        }
        if (this.keys[idx].equals(key)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1;
            }
            if (!this.keys[idx].equals(key)) continue;
            return this.values[idx];
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        int idx = Object2IntHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return false;
        }
        if (this.keys[idx].equals(key)) {
            return true;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (!this.keys[idx].equals(key)) continue;
            return true;
        }
        return false;
    }

    public int remove(Object key) {
        int idx = Object2IntHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1;
        }
        if (this.keys[idx].equals(key)) {
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1;
            }
            if (!this.keys[idx].equals(key)) continue;
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        return -1;
    }

    public Iterator iterator() {
        return new Object2LongIterator(0);
    }

    public Iterator valueIterator() {
        return new Object2LongIterator(1);
    }

    public Iterator stableIterator() {
        return new Object2LongStableIterator(0);
    }

    protected void insert(Object key, int value) throws AbstractHashtable.HashtableOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Object2IntHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(Object o) {
        return o.hashCode();
    }

    protected class Object2LongStableIterator
    extends AbstractHashtable.HashtableIterator {
        Object[] mKeys;
        int[] mValues;
        int idx;

        public Object2LongStableIterator(int type) {
            super(type);
            this.mKeys = null;
            this.mValues = null;
            this.idx = 0;
            this.mKeys = new Object[Object2IntHashMap.this.tabSize];
            System.arraycopy(Object2IntHashMap.this.keys, 0, this.mKeys, 0, Object2IntHashMap.this.tabSize);
            this.mValues = new int[Object2IntHashMap.this.tabSize];
            System.arraycopy(Object2IntHashMap.this.values, 0, this.mValues, 0, Object2IntHashMap.this.tabSize);
        }

        public boolean hasNext() {
            if (this.idx == Object2IntHashMap.this.tabSize) {
                return false;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2IntHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Object2IntHashMap.this.tabSize) {
                return null;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2IntHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return new Integer(this.mValues[this.idx++]);
            }
            return this.mKeys[this.idx++];
        }
    }

    protected class Object2LongIterator
    extends AbstractHashtable.HashtableIterator {
        int idx;

        public Object2LongIterator(int type) {
            super(type);
            this.idx = 0;
        }

        public boolean hasNext() {
            if (this.idx == Object2IntHashMap.this.tabSize) {
                return false;
            }
            while (Object2IntHashMap.this.keys[this.idx] == null || Object2IntHashMap.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2IntHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Object2IntHashMap.this.tabSize) {
                return null;
            }
            while (Object2IntHashMap.this.keys[this.idx] == null || Object2IntHashMap.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2IntHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return new Long(Object2IntHashMap.this.values[this.idx++]);
            }
            return Object2IntHashMap.this.keys[this.idx++];
        }
    }
}

