/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.XMLDBException;

public class RemoteResourceIterator
implements ResourceIterator {
    protected XmlRpcClient rpcClient;
    protected RemoteCollection collection;
    protected Vector resources;
    protected int pos = 0;
    protected int indentXML;
    protected String encoding = "UTF-8";

    public RemoteResourceIterator(RemoteCollection col, Vector resources, int indentXML, String encoding) {
        this.resources = resources;
        this.collection = col;
        this.indentXML = indentXML;
        this.encoding = encoding;
    }

    public int getLength() {
        return this.resources.size();
    }

    public boolean hasMoreResources() throws XMLDBException {
        return this.pos < this.resources.size();
    }

    public void setNext(int next) {
        this.pos = next;
    }

    public Resource nextResource() throws XMLDBException {
        if (this.pos >= this.resources.size()) {
            return null;
        }
        if (this.resources.elementAt(this.pos) instanceof Vector) {
            Vector v = (Vector)this.resources.elementAt(this.pos++);
            String doc = (String)v.elementAt(0);
            String s_id = (String)v.elementAt(1);
            Vector<Object> params = new Vector<Object>();
            params.addElement(doc);
            params.addElement(s_id);
            params.addElement(new Integer(this.indentXML));
            params.addElement(this.encoding);
            try {
                byte[] data = (byte[])this.collection.getClient().execute("retrieve", params);
                RemoteXMLResource res = new RemoteXMLResource(this.collection, XmldbURI.xmldbUriFor(doc), doc + "_" + s_id);
                res.setContent(new String(data, this.encoding));
                return res;
            }
            catch (XmlRpcException xre) {
                throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
            }
            catch (IOException ioe) {
                throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
            }
            catch (URISyntaxException e) {
                throw new XMLDBException(5, e.getMessage(), (Throwable)e);
            }
        }
        RemoteXMLResource res = new RemoteXMLResource(this.collection, null, Integer.toString(this.pos));
        res.setContent(this.resources.elementAt(this.pos++));
        return res;
    }
}

