/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.apache.log4j.Logger;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.StoredNode;
import org.exist.dom.VirtualNodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.GroupedValueSequenceTable;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public abstract class BindingExpression
extends AbstractExpression {
    protected static final Logger LOG = Logger.getLogger((Class)BindingExpression.class);
    protected static final SequenceType POSITIONAL_VAR_TYPE = new SequenceType(31, 2);
    protected String varName;
    protected SequenceType sequenceType = null;
    protected Expression inputSequence;
    protected Expression returnExpr;
    protected Expression whereExpr;
    protected OrderSpec[] orderSpecs = null;
    protected int actualReturnType = 11;
    protected GroupSpec[] groupSpecs = null;
    protected Expression groupReturnExpr;
    protected String groupVarName;
    protected String toGroupVarName;
    private ExprUpdateListener listener;

    public BindingExpression(XQueryContext context) {
        super(context);
    }

    public void setVariable(String qname) {
        this.varName = qname;
    }

    public String getVariable() {
        return this.varName;
    }

    public void setSequenceType(SequenceType type) {
        this.sequenceType = type;
    }

    public void setInputSequence(Expression sequence) {
        this.inputSequence = sequence;
    }

    public Expression getInputSequence() {
        return this.inputSequence;
    }

    public void setReturnExpression(Expression expr) {
        this.returnExpr = expr;
    }

    public Expression getReturnExpression() {
        return this.returnExpr;
    }

    public void setWhereExpression(Expression expr) {
        this.whereExpr = expr;
    }

    public Expression getWhereExpression() {
        return this.whereExpr;
    }

    public void setOrderSpecs(OrderSpec[] specs) {
        this.orderSpecs = specs;
    }

    public void setGroupSpecs(GroupSpec[] specs) {
        this.groupSpecs = specs;
    }

    public void setGroupReturnExpr(Expression expr) {
        this.groupReturnExpr = expr;
    }

    public void setGroupVariable(String qname) {
        this.groupVarName = qname;
    }

    public void setToGroupVariable(String qname) {
        this.toGroupVarName = qname;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.analyze(contextInfo, this.orderSpecs, this.groupSpecs);
    }

    public abstract void analyze(AnalyzeContextInfo var1, OrderSpec[] var2, GroupSpec[] var3) throws XPathException;

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        return this.eval(contextSequence, contextItem, null, null);
    }

    public abstract Sequence eval(Sequence var1, Item var2, Sequence var3, GroupedValueSequenceTable var4) throws XPathException;

    protected Sequence applyWhereExpression(Sequence contextSequence) throws XPathException {
        if (contextSequence != null && Type.subTypeOf(contextSequence.getItemType(), -1) && Type.subTypeOf(this.whereExpr.returnsType(), 11)) {
            Sequence seq = this.whereExpr.eval(contextSequence);
            if (Type.subTypeOf(this.whereExpr.returnsType(), -1)) {
                NodeSet nodes = seq.toNodeSet();
                NodeSet contextSet = contextSequence.toNodeSet();
                boolean contextIsVirtual = contextSet instanceof VirtualNodeSet;
                ExtArrayNodeSet result = new ExtArrayNodeSet();
                DocumentImpl lastDoc = null;
                int count = 0;
                NodeSetIterator i = nodes.iterator();
                while (i.hasNext()) {
                    ContextItem context;
                    NodeProxy current = (NodeProxy)i.next();
                    int sizeHint = -1;
                    if (lastDoc == null || current.getDocument() != lastDoc) {
                        lastDoc = current.getDocument();
                        sizeHint = nodes.getSizeHint(lastDoc);
                    }
                    if ((context = current.getContext()) == null) {
                        throw new XPathException("Internal evaluation error: context node is missing for node " + current.getNodeId() + "!");
                    }
                    while (context != null) {
                        if (context.getContextId() == this.whereExpr.getContextId()) {
                            NodeProxy contextNode = context.getNode();
                            if (contextIsVirtual || contextSet.contains(contextNode)) {
                                contextNode.addMatches(current);
                                result.add(contextNode, sizeHint);
                            }
                        }
                        context = context.getNextDirect();
                    }
                    ++count;
                }
                return result;
            }
        }
        if (contextSequence == null) {
            Sequence innerSeq = this.whereExpr.eval(null);
            return innerSeq.effectiveBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        ValueSequence result = new ValueSequence();
        int p = 0;
        SequenceIterator i = contextSequence.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            this.context.setContextPosition(p);
            Sequence innerSeq = this.whereExpr.eval(contextSequence, item);
            if (innerSeq.effectiveBooleanValue()) {
                result.add(item);
            }
            ++p;
        }
        return result;
    }

    protected boolean checkOrderSpecs(Sequence in) {
        if (this.orderSpecs == null) {
            return false;
        }
        if (!Type.subTypeOf(in.getItemType(), -1)) {
            return false;
        }
        for (int i = 0; i < this.orderSpecs.length; ++i) {
            Expression expr = this.orderSpecs[i].getSortExpression();
            if (Type.subTypeOf(expr.returnsType(), -1) && !Dependency.dependsOn(expr, 2)) continue;
            return false;
        }
        return true;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.inputSequence.resetState(postOptimization);
        if (this.whereExpr != null) {
            this.whereExpr.resetState(postOptimization);
        }
        this.returnExpr.resetState(postOptimization);
        if (this.orderSpecs != null) {
            for (int i = 0; i < this.orderSpecs.length; ++i) {
                this.orderSpecs[i].resetState(postOptimization);
            }
        }
    }

    protected static final void setContext(int contextId, Sequence seq) {
        if (seq instanceof VirtualNodeSet) {
            ((VirtualNodeSet)seq).setSelfIsContext();
            ((VirtualNodeSet)seq).setInPredicate(true);
        } else {
            SequenceIterator i = seq.unorderedIterator();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (!(next instanceof NodeProxy)) continue;
                ((NodeProxy)next).addContextNode(contextId, (NodeProxy)next);
            }
        }
    }

    protected static final void clearContext(int contextId, Sequence seq) {
        if (!(seq instanceof VirtualNodeSet)) {
            SequenceIterator i = seq.unorderedIterator();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (!(next instanceof NodeProxy)) continue;
                ((NodeProxy)next).clearContext(contextId);
            }
        }
    }

    protected void registerUpdateListener(Sequence sequence) {
        if (this.listener == null) {
            this.listener = new ExprUpdateListener(sequence);
            this.context.registerUpdateListener(this.listener);
        } else {
            this.listener.setSequence(sequence);
        }
    }

    public int getDependencies() {
        return this.returnExpr.getDependencies();
    }

    private class ExprUpdateListener
    implements UpdateListener {
        private Sequence sequence;

        public ExprUpdateListener(Sequence sequence) {
            this.sequence = sequence;
        }

        public void setSequence(Sequence sequence) {
            this.sequence = sequence;
        }

        public void documentUpdated(DocumentImpl document, int event) {
        }

        public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
            this.sequence.nodeMoved(oldNodeId, newNode);
        }

        public void unsubscribe() {
            BindingExpression.this.listener = null;
        }

        public void debug() {
        }
    }
}

