/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class RootNode
extends Step {
    private NodeSet cached = null;
    private DocumentSet cachedDocs = null;
    private UpdateListener listener = null;

    public RootNode(XQueryContext context) {
        super(context, 12);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        DocumentSet ds;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((ds = this.context.getStaticallyKnownDocuments()) == null || ds.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.cachedDocs != null && this.cachedDocs.equals(ds)) {
            return this.cached;
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(2);
        try {
            if (!this.context.inProtectedMode()) {
                ds.lock(this.context.getBroker(), false, true);
            }
            Iterator i = ds.iterator();
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (this.context.inProtectedMode() && !this.context.getProtectedDocs().containsKey(doc.getDocId()) || doc.getResourceType() != 0) continue;
                result.add(new NodeProxy(doc));
            }
            this.cached = result;
            this.cachedDocs = ds;
        }
        catch (LockException e) {
            throw new XPathException(this.getASTNode(), "Failed to acquire lock on the context document set");
        }
        finally {
            if (!this.context.inProtectedMode()) {
                ds.unlock(false);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        this.registerUpdateListener();
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("[root-node]");
    }

    public String toString() {
        return "[root-node]";
    }

    public int returnsType() {
        return -1;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                public void documentUpdated(DocumentImpl document, int event) {
                    if (document == null || event == 0 || event == 2) {
                        RootNode.this.cachedDocs = null;
                        RootNode.this.cached = null;
                    } else if (RootNode.this.cachedDocs != null && RootNode.this.cachedDocs.contains(document.getDocId())) {
                        RootNode.this.cachedDocs = null;
                        RootNode.this.cached = null;
                    }
                }

                public void unsubscribe() {
                    RootNode.this.listener = null;
                }

                public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
                }

                public void debug() {
                    Step.LOG.debug((Object)("UpdateListener: Line: " + RootNode.this.toString()));
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    public void resetState(boolean postOptimization) {
        this.cached = null;
        this.cachedDocs = null;
    }
}

