/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtCollection
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("collection", "http://www.w3.org/2005/xpath-functions"), "Returns the documents contained in the collections specified in the input sequence. The arguments are either collection pathes like '/db/shakespeare/plays' or XMLDB URIs like 'xmldb:exist://localhost:8081//db/shakespeare/plays'. Documents contained in subcollections are also included.", new SequenceType[]{new SequenceType(22, 7)}, new SequenceType(-1, 7), true);
    private boolean includeSubCollections = false;
    private List cachedArgs = null;
    private Sequence cached = null;
    private DocumentSet cachedDocs = null;
    private UpdateListener listener = null;

    public ExtCollection(XQueryContext context) {
        this(context, signature, true);
    }

    public ExtCollection(XQueryContext context, FunctionSignature signature, boolean inclusive) {
        super(context, signature);
        this.includeSubCollections = inclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        List args = this.getParameterValues(contextSequence, contextItem);
        boolean cacheIsValid = false;
        if (this.cachedArgs != null) {
            cacheIsValid = this.compareArguments(this.cachedArgs, args);
        }
        if (cacheIsValid) {
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().end(this, "fn:collection: loading documents", this.cached);
            }
            return this.cached;
        }
        DocumentSet docs = new DocumentSet(521);
        try {
            if (args.size() == 0) {
                docs = this.context.getStaticallyKnownDocuments();
            } else {
                for (int i = 0; i < args.size(); ++i) {
                    String next = (String)args.get(i);
                    XmldbURI uri = new AnyURIValue(next).toXmldbURI();
                    Collection coll = this.context.getBroker().getCollection(uri);
                    if (coll == null) continue;
                    if (this.context.inProtectedMode()) {
                        this.context.getProtectedDocs().getDocsByCollection(coll, this.includeSubCollections, docs);
                        continue;
                    }
                    coll.allDocs(this.context.getBroker(), docs, this.includeSubCollections, true, this.context.getProtectedDocs());
                }
            }
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw new XPathException("FODC0002: " + e.getMessage(), e);
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getLength(), 1);
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            Lock dlock = doc.getUpdateLock();
            boolean lockAcquired = false;
            try {
                if (!this.context.inProtectedMode() && !dlock.hasLock()) {
                    dlock.acquire(0);
                    doc.setBroker(this.context.getBroker());
                    lockAcquired = true;
                }
                result.add(new NodeProxy(doc));
            }
            catch (LockException e) {
                LOG.info((Object)("Could not acquire lock on document " + doc.getURI()));
            }
            finally {
                if (!lockAcquired) continue;
                dlock.release(0);
            }
        }
        this.cached = result;
        this.cachedArgs = args;
        this.cachedDocs = docs;
        this.registerUpdateListener();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private List getParameterValues(Sequence contextSequence, Item contextItem) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(this.getArgumentCount() + 10);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                Item next = j.nextItem();
                args.add(next.getStringValue());
            }
        }
        return args;
    }

    private boolean compareArguments(List args1, List args2) {
        if (args1.size() != args2.size()) {
            return false;
        }
        for (int i = 0; i < args1.size(); ++i) {
            String arg2;
            String arg1 = (String)args1.get(i);
            if (arg1.equals(arg2 = (String)args2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                public void documentUpdated(DocumentImpl document, int event) {
                    if (document == null || event == 0 || event == 2) {
                        ExtCollection.this.cachedDocs = null;
                        ExtCollection.this.cached = null;
                        ExtCollection.this.cachedArgs = null;
                    } else if (ExtCollection.this.cachedDocs != null && ExtCollection.this.cachedDocs.contains(document.getDocId())) {
                        ExtCollection.this.cachedDocs = null;
                        ExtCollection.this.cached = null;
                        ExtCollection.this.cachedArgs = null;
                    }
                }

                public void unsubscribe() {
                    ExtCollection.this.listener = null;
                }

                public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
                }

                public void debug() {
                    LOG.debug((Object)("UpdateListener: Line: " + ExtCollection.this.getASTNode().getLine() + ": " + ExtCollection.this.toString()));
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    public void resetState(boolean postOptimization) {
        this.cached = null;
        this.cachedDocs = null;
        this.cachedArgs = null;
    }
}

