/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.DocUtils;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunDoc
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("doc", "http://www.w3.org/2005/xpath-functions"), "Returns the documents specified in the input sequence. The arguments are either document paths like '/db/shakespeare/plays/hamlet.xml' or XMLDB URIs like 'xmldb:exist://localhost:8081//db/shakespeare/plays/hamlet.xml' or standard URLs starting with http://, file://, etc.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(-1, 3));
    private Sequence cached = null;
    private String cachedPath = null;
    private UpdateListener listener = null;

    public FunDoc(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence arg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((arg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            String path = arg.itemAt(0).getStringValue();
            if (this.cached != null && path.equals(this.cachedPath)) {
                return this.cached;
            }
            try {
                result = DocUtils.getDocument(this.context, path);
                DocumentSet docs = result.getDocumentSet();
                if (docs != null && DocumentSet.EMPTY_DOCUMENT_SET != docs) {
                    this.cachedPath = path;
                    this.cached = result;
                    this.registerUpdateListener();
                }
            }
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), e.getMessage());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                public void documentUpdated(DocumentImpl document, int event) {
                    if (document == null || event == 0 || event == 2) {
                        FunDoc.this.cachedPath = null;
                        FunDoc.this.cached = null;
                    } else if (FunDoc.this.cachedPath != null && (document == null || FunDoc.this.cachedPath.equals(document.getURI()))) {
                        FunDoc.this.cached = null;
                        FunDoc.this.cachedPath = null;
                    }
                }

                public void unsubscribe() {
                    FunDoc.this.listener = null;
                }

                public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
                }

                public void debug() {
                    LOG.debug((Object)("UpdateListener: Line: " + FunDoc.this.getASTNode().getLine() + ": " + FunDoc.this.toString()));
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
            this.cachedPath = null;
            this.listener = null;
        }
        this.getArgument(0).resetState(postOptimization);
    }
}

