/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.exist.dom.QName;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLDBStore
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("store", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store a new resource into the database. The first argument denotes the collection where the resource should be stored. The collection can be either specified as a simple collection path or an XMLDB URI. The second argument is the name of the new resource. The third argument is either a node, an xs:string, a Java file object or an xs:anyURI. A node will be serialized to SAX. It becomes the root node of the new document. If the argument is of type xs:anyURI, the resource is loaded from that URI. The functions returns the path to the new document as an xs:string or  - if the document could not be stored - the empty sequence.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(11, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("store", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store a new resource into the database. The first argument denotes the collection where the resource should be stored. The collection can be either specified as a simple collection path or an XMLDB URI. The second argument is the name of the new resource. The third argument is either a node, an xs:string, a Java file object or an xs:anyURI. A node will be serialized to SAX. It becomes the root node of the new document. If the argument is of type xs:anyURI, the resource is loaded from that URI. The final argument $d is used to specify a mime-type.  If the mime-type is something other than 'text/xml' or 'application/xml', the resource will be stored as a binary resource. The functions returns the path to the new document as an xs:string or - if the document could not be stored - the empty sequence.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(22, 3))};

    public XMLDBStore(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        Resource resource;
        block28: {
            MimeType mime;
            String docName;
            String string = docName = args[1].isEmpty() ? null : args[1].getStringValue();
            if (docName != null && docName.length() == 0) {
                docName = null;
            } else if (docName != null) {
                docName = new AnyURIValue(docName).toXmldbURI().toString();
            }
            String mimeType = MimeType.XML_TYPE.getName();
            boolean binary = false;
            if (this.getSignature().getArgumentCount() == 4) {
                mimeType = args[3].getStringValue();
                mime = MimeTable.getInstance().getContentType(mimeType);
                if (mime != null) {
                    binary = !mime.isXMLType();
                }
            } else if (docName != null && (mime = MimeTable.getInstance().getContentTypeFor(docName)) != null) {
                mimeType = mime.getName();
                binary = !mime.isXMLType();
            }
            Item item = args[2].itemAt(0);
            try {
                if (Type.subTypeOf(item.getType(), 100)) {
                    Object obj = ((JavaObjectValue)item).getObject();
                    if (!(obj instanceof File)) {
                        throw new XPathException(this.getASTNode(), "Passed java object should be a File");
                    }
                    resource = this.loadFromFile(collection, (File)obj, docName, binary, mimeType);
                    break block28;
                }
                if (Type.subTypeOf(item.getType(), 25)) {
                    try {
                        URI uri = new URI(item.getStringValue());
                        resource = this.loadFromURI(collection, uri, docName, binary, mimeType);
                        break block28;
                    }
                    catch (URISyntaxException e) {
                        throw new XPathException(this.getASTNode(), "Invalid URI: " + item.getStringValue(), e);
                    }
                }
                if (binary) {
                    resource = collection.createResource(docName, "BinaryResource");
                    ((EXistResource)resource).setMimeType(mimeType);
                } else {
                    resource = collection.createResource(docName, "XMLResource");
                }
                if (Type.subTypeOf(item.getType(), 22)) {
                    resource.setContent((Object)item.getStringValue());
                } else if (item.getType() == 26) {
                    resource.setContent(item.toJavaObject([B.class));
                } else if (Type.subTypeOf(item.getType(), -1)) {
                    if (binary) {
                        StringWriter writer = new StringWriter();
                        SAXSerializer serializer = new SAXSerializer();
                        serializer.setOutput(writer, null);
                        item.toSAX(this.context.getBroker(), serializer, null);
                        resource.setContent((Object)writer.toString());
                    } else {
                        ContentHandler handler = ((XMLResource)resource).setContentAsSAX();
                        handler.startDocument();
                        item.toSAX(this.context.getBroker(), handler, null);
                        handler.endDocument();
                    }
                } else {
                    throw new XPathException("Data should be either a node or a string");
                }
                collection.storeResource(resource);
            }
            catch (XMLDBException e) {
                throw new XPathException("XMLDB reported an exception while storing document" + (Object)((Object)e), e);
            }
            catch (SAXException e) {
                throw new XPathException("SAX reported an exception while storing document", e);
            }
        }
        if (resource == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            return new StringValue(collection.getName() + "/" + resource.getId());
        }
        catch (XMLDBException e) {
            throw new XPathException("XMLDB reported an exception while retrieving the stored document", e);
        }
    }

    private Resource loadFromURI(Collection collection, URI uri, String docName, boolean binary, String mimeType) throws XPathException {
        Resource resource;
        if ("file".equals(uri.getScheme())) {
            String path = uri.getPath();
            if (path == null) {
                throw new XPathException(this.getASTNode(), "Cannot read from URI: " + uri.toASCIIString());
            }
            File file = new File(path);
            if (!file.canRead()) {
                throw new XPathException(this.getASTNode(), "Cannot read path: " + path);
            }
            resource = this.loadFromFile(collection, file, docName, binary, mimeType);
        } else {
            try {
                File temp = File.createTempFile("existDBS", ".xml");
                temp.deleteOnExit();
                FileOutputStream os = new FileOutputStream(temp);
                InputStream is = uri.toURL().openStream();
                byte[] data = new byte[1024];
                int read = 0;
                while ((read = is.read(data)) > -1) {
                    ((OutputStream)os).write(data, 0, read);
                }
                is.close();
                ((OutputStream)os).close();
                resource = this.loadFromFile(collection, temp, docName, binary, mimeType);
                temp.delete();
            }
            catch (MalformedURLException e) {
                throw new XPathException(this.getASTNode(), "Malformed URL: " + uri.toString(), e);
            }
            catch (IOException e) {
                throw new XPathException(this.getASTNode(), "IOException while reading from URL: " + uri.toString(), e);
            }
        }
        return resource;
    }

    private Resource loadFromFile(Collection collection, File file, String docName, boolean binary, String mimeType) throws XPathException {
        if (file.isFile()) {
            if (docName == null) {
                docName = file.getName();
            }
            try {
                Resource resource;
                if (binary) {
                    resource = collection.createResource(docName, "BinaryResource");
                    ((EXistResource)resource).setMimeType(mimeType);
                } else {
                    resource = collection.createResource(docName, "XMLResource");
                }
                resource.setContent((Object)file);
                collection.storeResource(resource);
                return resource;
            }
            catch (XMLDBException e) {
                throw new XPathException(this.getASTNode(), "Could not store file " + file.getAbsolutePath() + ": " + e.getMessage(), e);
            }
        }
        throw new XPathException(this.getASTNode(), file.getAbsolutePath() + " does not point to a file");
    }
}

