/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.DTDCommenter;
import DTDDoc.ExtendedDTD;
import DTDDoc.ImmutablePair;
import DTDDoc.Tools;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDSequence;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ElementTreeBuilder {
    private PrintWriter out;
    private DTDCommenter commenter;
    private ImmutablePair[] nameDTDPairs;
    private ExtendedDTD currentDTD;
    private int nextNodeId = 0;
    private Map elementNodeIds = new HashMap();

    public ElementTreeBuilder(PrintWriter printWriter, DTDCommenter dTDCommenter, ImmutablePair[] immutablePairArray) {
        this.out = printWriter;
        this.commenter = dTDCommenter;
        this.nameDTDPairs = immutablePairArray;
    }

    public void generateTree() throws Exception {
        this.out.println("<div class=\"dtree\">");
        this.out.println("<script type=\"text/javascript\">");
        this.out.println("//<!--");
        this.out.println("eltTree = new CCTree('detail');");
        this.nextNodeId = 0;
        for (int i = 0; i < this.nameDTDPairs.length; ++i) {
            try {
                this.visitCurrentDTD((ExtendedDTD)this.nameDTDPairs[i].getValue());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.out.println("document.write(eltTree);");
        this.out.println("//-->");
        this.out.println("</script>");
        this.out.println("</div>");
    }

    private void visitCurrentDTD(ExtendedDTD extendedDTD) throws Exception {
        this.currentDTD = extendedDTD;
        this.elementNodeIds = new HashMap();
        int n = this.generateTreeNode(-1, extendedDTD.getTitle(), this.commenter.getDTDBaseURI(extendedDTD), 0);
        Collection collection = Tools.sort(extendedDTD.getElementsCollection(), new Comparator(){

            public int compare(Object object, Object object2) {
                DTDElement dTDElement = (DTDElement)object;
                DTDElement dTDElement2 = (DTDElement)object2;
                return dTDElement.getName().compareToIgnoreCase(dTDElement2.getName());
            }
        });
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.visitElement(n, (DTDElement)iterator.next(), null, true);
        }
    }

    private void visitElement(int n, DTDElement dTDElement, DTDCardinal dTDCardinal, boolean bl) throws Exception {
        if (this.elementNodeIds.containsKey(dTDElement)) {
            this.generateTreeLink(n, (Integer)this.elementNodeIds.get(dTDElement), dTDElement.getName() + this.getCardinalitySymbol(dTDCardinal), this.getCardinalityModifier(dTDCardinal));
            return;
        }
        String string = dTDElement.getName();
        if (dTDElement.getContent() instanceof DTDEmpty) {
            string = "&lt;" + string + "/&gt;";
        } else if (dTDElement.getContent() instanceof DTDAny) {
            string = string + " (any)";
        }
        int n2 = this.getCardinalityModifier(dTDCardinal);
        if (this.currentDTD.isRoot(dTDElement) && bl) {
            string = string + " (root)";
            n2 |= 1;
        }
        int n3 = this.generateTreeNode(n, string + this.getCardinalitySymbol(dTDCardinal), this.commenter.makeURITo(this.currentDTD, dTDElement).toString(), n2);
        this.elementNodeIds.put(dTDElement, new Integer(n3));
        this.generateAttributesNodes(n3, dTDElement);
        if (dTDElement.getContent() instanceof DTDContainer) {
            this.visitContainer(n3, (DTDContainer)dTDElement.getContent());
        } else if (dTDElement.getContent() instanceof DTDAny) {
            Iterator iterator = this.currentDTD.getElementsCollection().iterator();
            while (iterator.hasNext()) {
                this.visitElement(n3, (DTDElement)iterator.next(), null, true);
            }
        }
    }

    public void visitContainer(int n, DTDContainer dTDContainer) throws Exception {
        if (dTDContainer instanceof DTDMixed && dTDContainer.getItems() != null && dTDContainer.getItems().length == 1 && dTDContainer.getItems()[0] instanceof DTDPCData) {
            return;
        }
        int n2 = n;
        if (!(dTDContainer instanceof DTDSequence) || dTDContainer.getCardinal() != DTDCardinal.NONE) {
            n2 = this.generateContainerNode(dTDContainer, n);
        }
        for (DTDItem dTDItem : dTDContainer.getItemsVec()) {
            if (dTDItem instanceof DTDName) {
                DTDElement dTDElement = this.currentDTD.getElementByName((DTDName)dTDItem);
                if (dTDElement != null) {
                    this.visitElement(n2, dTDElement, dTDItem.getCardinal(), true);
                    continue;
                }
                System.err.println("Malformed DTD ! Unknown element: " + ((DTDName)dTDItem).getValue() + " in " + this.currentDTD.getSystemPath());
                continue;
            }
            if (!(dTDItem instanceof DTDContainer)) continue;
            this.visitContainer(n2, (DTDContainer)dTDItem);
        }
    }

    private int generateContainerNode(DTDContainer dTDContainer, int n) {
        String string = null;
        if (dTDContainer instanceof DTDMixed) {
            string = "mixed";
        } else if (dTDContainer instanceof DTDChoice) {
            string = "choice";
        } else if (dTDContainer instanceof DTDSequence) {
            string = "sequence";
        } else {
            System.err.println("Unsupported type of container !" + string.getClass());
        }
        return this.generateTreeNode(n, "&lt;" + string + "&gt;" + this.getCardinalitySymbol(dTDContainer.getCardinal()), null, 2 | this.getCardinalityModifier(dTDContainer.getCardinal()) | 4);
    }

    private String getCardinalitySymbol(DTDCardinal dTDCardinal) {
        if (dTDCardinal == DTDCardinal.OPTIONAL) {
            return "?";
        }
        if (dTDCardinal == DTDCardinal.ZEROMANY) {
            return "*";
        }
        if (dTDCardinal == DTDCardinal.ONEMANY) {
            return "+";
        }
        return "";
    }

    private int getCardinalityModifier(DTDCardinal dTDCardinal) {
        if (dTDCardinal == DTDCardinal.NONE || dTDCardinal == DTDCardinal.ONEMANY) {
            return 1;
        }
        return 0;
    }

    private void generateAttributesNodes(int n, DTDElement dTDElement) throws Exception {
        DTDAttribute dTDAttribute;
        if (dTDElement.attributes == null || dTDElement.attributes.size() <= 0) {
            return;
        }
        Object[] objectArray = new ImmutablePair[dTDElement.attributes.size()];
        Iterator iterator = dTDElement.attributes.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            dTDAttribute = (DTDAttribute)dTDElement.attributes.get(string);
            objectArray[n2++] = new ImmutablePair(string, dTDAttribute);
        }
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            dTDAttribute = (DTDAttribute)((ImmutablePair)objectArray[i]).getValue();
            boolean bl = false;
            if (dTDAttribute.decl == DTDDecl.REQUIRED) {
                bl = true;
            }
            this.generateTreeNode(n, "@" + dTDAttribute.getName(), this.commenter.makeURITo(this.currentDTD, dTDElement, dTDAttribute).toString(), 0);
        }
    }

    private int generateTreeNode(int n, String string, String string2, int n2) {
        int n3 = this.nextNodeId++;
        string = Tools.escapeHTMLUnicode(string, true);
        if ((n2 & 2) == 2) {
            string = "<i>" + string + "</i>";
        }
        if ((n2 & 1) == 1) {
            string = "<b>" + string + "</b>";
        }
        string2 = string2 != null ? "'" + string2 + "'" : "null";
        boolean bl = (n2 & 4) == 4;
        boolean bl2 = (n2 & 8) == 8;
        String string3 = n >= 0 ? "addNode" : "addRootNode";
        this.out.println("eltTree." + string3 + "('" + n3 + "','" + string + "'," + string2 + "," + bl + "," + bl2 + ")");
        if (n >= 0) {
            this.out.println("eltTree.linkNodes('" + n + "','" + n3 + "')");
        }
        return n3;
    }

    private void generateTreeLink(int n, int n2, String string, int n3) {
        if ((n3 & 2) == 2) {
            string = "<i>" + string + "</i>";
        }
        if ((n3 & 1) == 1) {
            string = "<b>" + string + "</b>";
        }
        this.out.println("eltTree.linkNodes('" + n + "','" + n2 + "','" + string + "')");
    }

    public static void generateJavascriptSetup(PrintWriter printWriter) {
        printWriter.println("<script type=\"text/javascript\" src=\"cctree.js\"></script>");
    }
}

