/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.css.kit;

import com.japisoft.css.helper.Keywords;
import com.japisoft.css.kit.Token;
import com.japisoft.framework.preferences.Preferences;
import java.awt.Color;
import java.util.HashMap;

public class SyntaxLexer {
    Color valueOfProperty = new Color(150, 0, 0);
    Color defaultColor = Color.BLACK;
    Color classColor;
    Color idColor = this.classColor = Color.ORANGE.darker();
    Color commentColor = Color.DARK_GRAY;
    private int tokenCount;
    private Token[] maxTokens = new Token[100];
    private HashMap mapOfLastTokens = new HashMap();
    private HashMap mapOfColor = new HashMap();
    private StringBuffer sb = new StringBuffer();

    SyntaxLexer() {
        Color color = new Color(0, 150, 0);
        color = Preferences.getPreference("CSSEditor", "keywordsColor", color);
        this.mapOfColor.put("{", color);
        this.mapOfColor.put("}", color);
        this.mapOfColor.put(":", color);
        this.mapOfColor.put(";", color);
        color = new Color(0, 0, 150);
        color = Preferences.getPreference("CSSEditor", "propertiesColor", color);
        for (int i = 0; i < Keywords.properties.length; ++i) {
            this.mapOfColor.put(Keywords.properties[i], color);
        }
        this.commentColor = Preferences.getPreference("CSSEditor", "commentColor", this.commentColor);
        this.mapOfColor.put("/*", this.commentColor);
        this.valueOfProperty = Preferences.getPreference("CSSEditor", "valueColor", this.valueOfProperty);
        this.defaultColor = Preferences.getPreference("CSSEditor", "defaultColor", this.defaultColor);
        this.classColor = Preferences.getPreference("CSSEditor", "classColor", this.classColor);
        this.idColor = Preferences.getPreference("CSSEditor", "idColor", this.idColor);
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    private void resetBuffer() {
        this.sb.delete(0, this.sb.length() + 1);
    }

    public Token[] getTokenForLine(String string, int n) {
        this.tokenCount = 0;
        Token token = (Token)this.mapOfLastTokens.get(new Integer(n - 1));
        Token token2 = (Token)this.mapOfLastTokens.get(new Integer(n));
        this.resetBuffer();
        Token token3 = null;
        Token token4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (token != null && token.color == Color.DARK_GRAY) {
            bl2 = true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl2 && i > 0 && c == '*' && string.charAt(i - 1) == '/') {
                this.sb.deleteCharAt(this.sb.length() - 1);
                this.addToken(this.sb.toString());
                this.resetBuffer();
                this.addToken("/*");
                bl2 = true;
                continue;
            }
            if (bl2) {
                if (c == '/' && i > 0 && string.charAt(i - 1) == '*') {
                    this.sb.append(c);
                    this.addToken(this.sb.toString(), Color.DARK_GRAY);
                    token4 = new Token("", null);
                    this.resetBuffer();
                    bl2 = false;
                    continue;
                }
                this.sb.append(c);
                continue;
            }
            if (!bl3) {
                if (c == ':') {
                    bl3 = true;
                }
            } else if (c == '{') {
                bl3 = false;
            } else {
                if (c == ';') {
                    bl3 = false;
                    this.addToken(this.sb.toString(), this.valueOfProperty);
                    this.resetBuffer();
                    this.addToken(";");
                    bl3 = false;
                    continue;
                }
                this.sb.append(c);
                continue;
            }
            if (!bl) {
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != ';' && c != '{' && c != ':' && c != '}' && c != '/') {
                    this.addToken(this.sb.toString());
                    this.resetBuffer();
                    this.sb.append(c);
                    bl = true;
                } else if (c == '{' || c == '}' || c == ':' || c == ';') {
                    this.addToken(this.sb.toString());
                    this.resetBuffer();
                    this.addToken("" + c);
                } else {
                    this.sb.append(c);
                }
            } else if (c == ' ' || c == '\t' || c == '\n' || c == '\t' || c == '{' || c == ':' || c == ';' || c == '}' || c == ',') {
                token3 = this.addToken(this.sb.toString());
                this.resetBuffer();
                this.sb.append(c);
                bl = false;
            } else {
                this.sb.append(c);
            }
            if (token3 == null) continue;
            token4 = token3;
        }
        Color color = null;
        if (bl2) {
            color = Color.DARK_GRAY;
        }
        if ((token3 = this.addToken(this.sb.toString(), color)) != null) {
            token4 = token3;
        }
        if (token2 != null && token2.color == Color.DARK_GRAY && !bl2) {
            token4 = new Token("", null);
        }
        if (token4 != null) {
            this.mapOfLastTokens.put(new Integer(n), token4);
        }
        return this.maxTokens;
    }

    Token addToken(String string) {
        return this.addToken(string, null);
    }

    Token addToken(String string, Color color) {
        Object object;
        Color color2 = color;
        if (color2 == null) {
            color2 = (Color)this.mapOfColor.get(string.toLowerCase());
        }
        if (this.tokenCount == this.maxTokens.length) {
            object = new Token[this.maxTokens.length * 2];
            System.arraycopy(this.maxTokens, 0, object, 0, this.maxTokens.length);
            this.maxTokens = object;
        }
        object = null;
        if (color2 == null) {
            color2 = this.defaultColor;
            if (string.length() > 1) {
                if (string.startsWith(".")) {
                    color2 = this.classColor;
                } else if (string.startsWith("#")) {
                    color2 = this.idColor;
                }
            }
            object = new Token(string, color2);
            this.maxTokens[this.tokenCount++] = object;
            return null;
        }
        object = new Token(string, color2);
        this.maxTokens[this.tokenCount++] = object;
        return object;
    }

    void dump() {
        System.out.println();
        for (int i = 0; i < this.tokenCount; ++i) {
            System.out.print("[" + this.maxTokens[i] + "]");
        }
    }

    public static void main(String[] stringArray) {
        String string = "a color : flsfksldfkjsdlkj;dddd";
        SyntaxLexer syntaxLexer = new SyntaxLexer();
        syntaxLexer.getTokenForLine(string, 0);
        syntaxLexer.dump();
    }
}

