/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.dtdparser;

import com.japisoft.dtdparser.CannotFindElementException;
import com.japisoft.dtdparser.DTDMapper;
import com.japisoft.dtdparser.DTDMapperFactory;
import com.japisoft.dtdparser.ParserElement;
import com.japisoft.dtdparser.XMLGenerator;
import com.japisoft.dtdparser.document.DTDDocumentBuilder;
import com.japisoft.dtdparser.document.DefaultDTDDocumentBuilder;
import com.japisoft.dtdparser.node.RootDTDNode;
import com.japisoft.framework.toolkit.FileToolkit;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.helper.model.SchemaLocator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class DTDParser {
    private DTDDocumentBuilder cBuilder = new DefaultDTDDocumentBuilder();
    private boolean ignoreComment = false;
    private String contentToParse = null;
    private String publicExtension = null;
    private Hashtable htEntitiesReference = null;
    private HashMap externalDTDComment = null;
    private URL dtdLocation = null;
    private int cursor = 0;
    private Stack operatorStack = null;

    public void setIgnoreComment(boolean bl) {
        this.ignoreComment = bl;
    }

    public void setDTDDocumentBuilder(DTDDocumentBuilder dTDDocumentBuilder) {
        this.cBuilder = dTDDocumentBuilder;
    }

    public DTDDocumentBuilder getDTDDocumentBuilder() {
        return this.cBuilder;
    }

    private String toString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return this.toString(inputStreamReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(Reader reader) throws IOException {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            char[] cArray = new char[512];
            int n = 0;
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
        }
        finally {
            reader.close();
        }
        return stringWriter.toString();
    }

    public RootDTDNode getDTDElement() {
        return this.cBuilder.getRoot();
    }

    public XMLGenerator getXMLGenerator() {
        return this.getDTDElement();
    }

    public void setResolveIncludeForExtension(String string) {
        this.publicExtension = string;
    }

    private boolean match(String string, int n) {
        boolean bl = true;
        for (int i = 0; i + n < this.contentToParse.length() && i < string.length(); ++i) {
            if (this.contentToParse.charAt(i + n) == string.charAt(i)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseExternalDTDComment(URL uRL) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            try {
                String string;
                Object var3_4 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) continue;
                    if (this.externalDTDComment == null) {
                        this.externalDTDComment = new HashMap();
                    }
                    this.externalDTDComment.put(string, string2);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(String string) throws IOException {
        DTDMapper dTDMapper = DTDMapperFactory.getDTDMapper();
        if (dTDMapper != null && dTDMapper.isCachedEnabled()) {
            this.parse(dTDMapper.getStream(string));
            dTDMapper.updateCache(this.getDTDElement(), string);
        } else {
            this.parse(new URL(string));
        }
    }

    public void parse(URL uRL) throws IOException {
        this.dtdLocation = uRL;
        this.parse(uRL.openStream());
    }

    public void parse(InputStream inputStream) throws IOException {
        this.contentToParse = this.toString(inputStream);
        this.innerParse();
    }

    public void parse(Reader reader) throws IOException {
        this.contentToParse = this.toString(reader);
        this.innerParse();
    }

    public void parse(SchemaLocator schemaLocator) throws IOException {
        try {
            if (schemaLocator.getSource() != null && schemaLocator.getSource().indexOf("://") > -1) {
                this.dtdLocation = new URL(schemaLocator.getSource());
            }
            this.contentToParse = this.toString(schemaLocator.getReader());
            this.innerParse();
            DTDMapper dTDMapper = DTDMapperFactory.getDTDMapper();
            if (dTDMapper != null && dTDMapper.isCachedEnabled() && schemaLocator.location != null && schemaLocator.location.toLowerCase().startsWith("http:")) {
                dTDMapper.updateCache(this.getDTDElement(), schemaLocator.location);
            }
        }
        catch (Exception exception) {
            Debug.debug(exception);
            throw new IOException(exception.getMessage());
        }
    }

    private void innerParse() throws IOException {
        this.cursor = 0;
        this.cBuilder.notifyStartDTD();
        boolean bl = false;
        while (this.cursor < this.contentToParse.length()) {
            char c = this.contentToParse.charAt(this.cursor++);
            boolean bl2 = bl = this.cursor < this.contentToParse.length();
            if (c == '<') {
                int n;
                if (bl && this.contentToParse.charAt(this.cursor) == '!') {
                    if (this.match("[", this.cursor + 1)) {
                        this.cursor = this.parseConditionnal(this.cursor + 2);
                        continue;
                    }
                    if (this.match("--", this.cursor + 1)) {
                        if (this.ignoreComment) {
                            n = this.contentToParse.indexOf("-->", this.cursor + 1);
                            if (n <= 1) continue;
                            this.cursor = n + 1;
                            continue;
                        }
                        this.cursor = this.parseComment(this.cursor + 1 + "--".length());
                        continue;
                    }
                    if (this.match("ELEMENT ", this.cursor + 1)) {
                        this.cursor = this.parseElement(this.cursor + 1 + "ELEMENT ".length());
                        continue;
                    }
                    if (this.match("ATTLIST ", this.cursor + 1)) {
                        this.cursor = this.parseAttribute(this.cursor + 1 + "ATTLIST ".length());
                        continue;
                    }
                    if (this.match("ENTITY ", this.cursor + 1)) {
                        this.cursor = this.parseEntity(this.cursor + 1 + "ENTITY ".length());
                        continue;
                    }
                    if (!this.match("NOTATION", this.cursor + 1) || (n = this.contentToParse.indexOf(">", this.cursor + 1)) <= -1) continue;
                    this.cursor = n + 1;
                    continue;
                }
                if (this.contentToParse.charAt(this.cursor) != '?') continue;
                n = this.contentToParse.indexOf("?>", this.cursor + 1);
                if (n > 1) {
                    this.cursor = n + 1;
                    continue;
                }
                ++this.cursor;
                continue;
            }
            if (c != '%' || !this.managedEntityReference(this.cursor)) continue;
            --this.cursor;
        }
        this.cBuilder.notifyStopDTD();
    }

    private boolean managedEntityReference(int n) {
        if (this.htEntitiesReference == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < this.contentToParse.length(); ++i) {
            char c = this.contentToParse.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') {
                stringBuffer = null;
                break;
            }
            if (c == ';') break;
            stringBuffer.append(c);
        }
        if (stringBuffer != null && stringBuffer.length() > 0 && this.htEntitiesReference.containsKey(stringBuffer.toString())) {
            this.contentToParse = this.contentToParse.substring(0, n - 1) + this.htEntitiesReference.get(stringBuffer.toString()) + this.contentToParse.substring(n + stringBuffer.length() + 1);
            return true;
        }
        return false;
    }

    private ParserElement nextElement(int n) {
        int n2 = n;
        ParserElement parserElement = new ParserElement();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < this.contentToParse.length()) {
            int n3;
            char c;
            if ((c = this.contentToParse.charAt(n2++)) == '-') {
                try {
                    if (this.contentToParse.charAt(n2 - 1) == '-' && (n3 = this.contentToParse.indexOf("--", n2 + 1)) > -1) {
                        n2 = n3 + 2;
                        continue;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (c == '%' && n2 + 1 < this.contentToParse.length() && this.contentToParse.charAt(n2 + 1) != ' ' && this.htEntitiesReference != null && this.managedEntityReference(n2)) {
                --n2;
                continue;
            }
            if (ParserElement.isToken(c)) {
                parserElement.token = c;
                parserElement.stop = n2 - 1;
                return parserElement;
            }
            if (Character.isWhitespace(c)) continue;
            bl = true;
            if (ParserElement.isLiteral(c)) {
                for (n3 = n2; n3 < this.contentToParse.length(); ++n3) {
                    char c2 = this.contentToParse.charAt(n3);
                    if (c2 == c) {
                        parserElement.content = stringBuffer.toString();
                        parserElement.stop = n3;
                        parserElement.literal = true;
                        return parserElement;
                    }
                    if (c2 == '%') {
                        if (!this.managedEntityReference(n3 + 1)) continue;
                        --n3;
                        continue;
                    }
                    stringBuffer.append(c2);
                }
                continue;
            }
            stringBuffer.append(c);
            n3 = 0;
            while (n2 < this.contentToParse.length()) {
                if (ParserElement.isToken(c = this.contentToParse.charAt(n2++)) || Character.isWhitespace(c)) {
                    parserElement.content = stringBuffer.toString();
                    parserElement.stop = n2 - 2;
                    return parserElement;
                }
                stringBuffer.append(c);
                n3 = c;
            }
        }
        return null;
    }

    protected String downloadPublicEntity(String string) {
        Object var2_2 = null;
        if (string.indexOf("://") > -1) {
            try {
                return FileToolkit.getContentFromURL(new URL(string));
            }
            catch (Throwable throwable) {
                return "";
            }
        }
        if (this.dtdLocation != null) {
            try {
                return FileToolkit.getContentFromURL(new URL(this.dtdLocation, string));
            }
            catch (Throwable throwable) {
                return "";
            }
        }
        return "";
    }

    protected int parseEntity(int n) {
        ParserElement parserElement;
        ParserElement parserElement2 = this.nextElement(n);
        boolean bl = false;
        if (parserElement2.token == '%') {
            bl = true;
            parserElement2 = this.nextElement(parserElement2.stop + 1);
        }
        if ((parserElement = this.nextElement(parserElement2.stop + 1)).hasToken() && parserElement.token == '%') {
            bl = true;
            parserElement = this.nextElement(parserElement.stop + 1);
        }
        int n2 = 0;
        if ("SYSTEM".equals(parserElement.content)) {
            n2 = 1;
            parserElement = this.nextElement(parserElement.stop + 1);
            if (parserElement != null && parserElement.content != null) {
                parserElement.content = this.downloadPublicEntity(parserElement.content);
            } else if (bl) {
                bl = false;
            }
        } else if ("PUBLIC".equals(parserElement.content)) {
            n2 = 2;
            parserElement = this.nextElement(parserElement.stop + 1);
            parserElement = this.nextElement(parserElement.stop + 1);
            if (parserElement != null && parserElement.content != null) {
                parserElement.content = this.downloadPublicEntity(parserElement.content);
            } else if (bl) {
                bl = false;
            }
        }
        if (!bl) {
            this.cBuilder.notifyEntity(parserElement2.content, bl, n2, parserElement.content);
        }
        if (bl) {
            if (this.htEntitiesReference == null) {
                this.htEntitiesReference = new Hashtable();
            }
            if (!this.htEntitiesReference.containsKey(parserElement2.content)) {
                this.htEntitiesReference.put(parserElement2.content, parserElement.content);
            }
        }
        return parserElement.stop;
    }

    private int parseElement(int n) {
        String string;
        ParserElement parserElement = this.nextElement(n);
        if (parserElement == null) {
            return n + 1;
        }
        String string2 = parserElement.content;
        if (string2 == null) {
            return n + 1;
        }
        if (this.externalDTDComment != null && (string = (String)this.externalDTDComment.get(string2)) != null) {
            this.cBuilder.notifyComment(string);
        }
        this.cBuilder.notifyStartElement(string2);
        string = null;
        int n2 = 0;
        char c = '\u0000';
        parserElement = this.nextElement(parserElement.stop + 1);
        while (parserElement != null && parserElement.token != '>' && parserElement.token != '<') {
            if (ParserElement.isOperator(parserElement.token)) {
                if (string == null) {
                    this.cBuilder.notifyOperator(parserElement.token);
                } else {
                    c = parserElement.token;
                }
            } else if (parserElement.token == '(') {
                if (n2 == 124 || n2 == 44) {
                    if (this.operatorStack == null) {
                        this.operatorStack = new Stack();
                    }
                    this.operatorStack.push(new Character(parserElement.token));
                    if (string == null && n2 == 44) {
                        this.cBuilder.notifyElementIncludeItem(null);
                    }
                    if (string == null && n2 == 124) {
                        this.cBuilder.notifyElementChoiceItem(null);
                    }
                }
                this.cBuilder.notifyStartElementChildren();
            } else if (parserElement.token == ')') {
                if (string != null) {
                    this.cBuilder.notifyElementIncludeItem(string);
                    string = null;
                    if (c > '\u0000') {
                        this.cBuilder.notifyOperator(c);
                        c = '\u0000';
                    }
                }
                if (this.operatorStack != null && !this.operatorStack.isEmpty()) {
                    n2 = ((Character)this.operatorStack.pop()).charValue();
                }
                this.cBuilder.notifyStopElementChildren();
            } else if (parserElement.token == '|') {
                n2 = parserElement.token;
            } else if (parserElement.token == ',') {
                n2 = parserElement.token;
            } else {
                string = parserElement.content;
            }
            if (string != null) {
                if (n2 == 124) {
                    this.cBuilder.notifyElementChoiceItem(string);
                    if (c > '\u0000') {
                        this.cBuilder.notifyOperator(c);
                        c = '\u0000';
                    }
                    string = null;
                } else if (n2 == 44) {
                    this.cBuilder.notifyElementIncludeItem(string);
                    string = null;
                    if (c > '\u0000') {
                        this.cBuilder.notifyOperator(c);
                        c = '\u0000';
                    }
                }
            }
            parserElement = this.nextElement(parserElement.stop + 1);
            if (parserElement.token != '>' || string == null) continue;
            this.cBuilder.notifyElementIncludeItem(string);
            this.cBuilder.notifyStopElement();
        }
        this.cBuilder.notifyStopElement();
        if (parserElement != null) {
            return parserElement.stop + 1;
        }
        return n + 1;
    }

    private int parseAttribute(int n) throws CannotFindElementException {
        ParserElement parserElement = this.nextElement(n);
        if (parserElement == null) {
            return n + 1;
        }
        String string = parserElement.content;
        ParserElement parserElement2 = null;
        while (!parserElement.hasToken() || parserElement.token != '>') {
            if (parserElement2 == null) {
                parserElement = this.nextElement(parserElement.stop + 1);
            } else {
                parserElement = parserElement2;
                parserElement2 = null;
            }
            if (parserElement.hasToken() && parserElement.token == '>') break;
            String string2 = parserElement.content;
            parserElement = this.nextElement(parserElement.stop + 1);
            Vector<String> vector = new Vector<String>();
            int n2 = 6;
            if (parserElement.hasToken() && parserElement.token == '(') {
                while (parserElement.token != ')' && parserElement.token != '>' && (parserElement = this.nextElement(parserElement.stop + 1)) != null) {
                    if (parserElement.hasToken()) continue;
                    vector.addElement(parserElement.content);
                }
            } else if ("ID".equals(parserElement.content)) {
                n2 = 0;
            } else if ("IDREF".equals(parserElement.content)) {
                n2 = 1;
            } else if ("ENTITY".equals(parserElement.content)) {
                n2 = 2;
            } else if ("ENTITIES".equals(parserElement.content)) {
                n2 = 3;
            } else if ("NMTOKEN".equals(parserElement.content)) {
                n2 = 4;
            } else if ("NMTOKENS".equals(parserElement.content)) {
                n2 = 5;
            } else if ("CDATA".equals(parserElement.content)) {
                n2 = 6;
            }
            int n3 = 1;
            parserElement = this.nextElement(parserElement.stop + 1);
            if (parserElement == null) {
                return n + 1;
            }
            String string3 = "";
            if (parserElement.literal) {
                string3 = parserElement.content;
            }
            if ("#IMPLIED".equals(parserElement.content)) {
                n3 = 1;
            } else if ("#REQUIRED".equals(parserElement.content)) {
                n3 = 0;
            } else if ("#FIXED".equals(parserElement.content)) {
                n3 = 2;
            }
            if (!parserElement.literal && (parserElement = this.nextElement(parserElement.stop + 1)) != null) {
                if (parserElement.literal) {
                    string3 = parserElement.content;
                } else {
                    parserElement2 = parserElement;
                }
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.cBuilder.notifyAttribute(string, string2, n2, (String[])objectArray, n3, string3);
        }
        return parserElement.stop + 1;
    }

    private int parseComment(int n) {
        int n2 = this.contentToParse.indexOf("-->", n);
        if (n2 > -1) {
            this.cBuilder.notifyComment(this.contentToParse.substring(n, n2));
            return n2 + 3;
        }
        return n + 1;
    }

    private int parseConditionnal(int n) {
        ParserElement parserElement = this.nextElement(n);
        if (parserElement == null) {
            return n + 1;
        }
        if ("IGNORE".equals(parserElement.content)) {
            int n2 = this.contentToParse.indexOf("]]>", n);
            if (n2 > -1) {
                return n2 + 3;
            }
            return n + 1;
        }
        if ("INCLUDE".equals(parserElement.content)) {
            int n3 = this.contentToParse.indexOf("[", n);
            if (n3 > -1) {
                return n3 + 1;
            }
            return n + 1;
        }
        return n + 1;
    }
}

