/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.help;

import com.japisoft.editix.action.xsl.XSLTAction;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dialog.BasicOKDialogComponent;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManager;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class UIHelpAction
extends AbstractAction {
    DocumentDialog dialog;

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog = new DocumentDialog("Please wait while generating documentation...");
        JobManager.addJob(new DocGeneratorJob());
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
    }

    class DocumentDialog
    extends BasicOKDialogComponent {
        JEditorPane ep;

        public DocumentDialog(String string) {
            super(ApplicationModel.MAIN_FRAME, "Documentation", "Documentation", "EditiX menu content", null);
            this.ep = null;
            this.ep = new JEditorPane("text/html", string);
            this.setUI(new JScrollPane(this.ep));
            this.ep.setEditable(false);
            this.ep.setCaretPosition(0);
            this.setSize(600, 600);
        }

        public void setContent(String string) {
            this.ep.setText(string);
            this.ep.setCaretPosition(0);
        }
    }

    class DocGeneratorJob
    implements Job {
        DocGeneratorJob() {
        }

        public Object getSource() {
            return UIHelpAction.this;
        }

        public boolean isAlone() {
            return true;
        }

        public void dispose() {
        }

        public void run() {
            TransformerFactory transformerFactory = XSLTAction.getTransformerFactoryV1(false);
            try {
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream("doc.xsl")));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                transformer.transform(new StreamSource(ClassLoader.getSystemResourceAsStream("editix.xml")), new StreamResult(byteArrayOutputStream));
                UIHelpAction.this.dialog.setContent(byteArrayOutputStream.toString());
            }
            catch (Throwable throwable) {
                UIHelpAction.this.dialog.setContent("Error : " + throwable.getMessage());
            }
        }

        public void stopIt() {
        }
    }
}

