/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.search;

import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.dom.DocumentImpl;
import com.japisoft.fastparser.dom.DomNodeFactory;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.dialog.actions.StoringLocationAction;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.StringReader;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathSyntaxException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathDialog
extends EditixDialog
implements ActionListener,
ListSelectionListener {
    private boolean searchMode;
    JPanel contentPane;
    JComboBox cbXPath = new JComboBox();
    JLabel lblXpath = new JLabel();
    JLabel lblVars = new JLabel();
    JScrollPane spVariables = new JScrollPane();
    JTable tbVariables = new JTable();
    JLabel lblNamespaces = new JLabel();
    JScrollPane spNamespaces = new JScrollPane();
    JTable tbNamespaces = new JTable();
    JButton btnApplyFromRoot = new JButton();
    JButton cBtnApplyFromCurrentNode = new JButton();
    JButton btnCopy = new JButton();
    JLabel lblResult = new JLabel();
    JScrollPane spResult = new JScrollPane();
    JTable tbResult = new JTable();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private DefaultTableModel modelVariables;
    private DefaultTableModel modelNamespaces = null;

    public XPathDialog(String string, boolean bl, DefaultTableModel defaultTableModel, DefaultTableModel defaultTableModel2) {
        super("XPath", bl ? "XPath finder" : "XPath builder", string, DialogActionModel.getDefaultDialogCloseActionModel().addDialogAction(new StoringLocationAction()));
        this.initUI();
        this.initModel(defaultTableModel, defaultTableModel2);
        this.searchMode = bl;
    }

    public void beforeShowing() {
        super.beforeShowing();
        this.btnApplyFromRoot.addActionListener(this);
        this.cBtnApplyFromCurrentNode.addActionListener(this);
        this.btnCopy.addActionListener(this);
        this.tbResult.getSelectionModel().addListSelectionListener(this);
    }

    public void beforeClosing() {
        super.beforeClosing();
        this.btnApplyFromRoot.removeActionListener(this);
        this.cBtnApplyFromCurrentNode.removeActionListener(this);
        this.btnCopy.removeActionListener(this);
        this.tbResult.getSelectionModel().removeListSelectionListener(this);
        ((CustomCellEditor2)this.tbVariables.getColumnModel().getColumn(0).getCellEditor()).dispose();
        ((CustomCellEditor2)this.tbVariables.getColumnModel().getColumn(2).getCellEditor()).dispose();
        ((CustomCellEditor2)this.tbNamespaces.getColumnModel().getColumn(0).getCellEditor()).dispose();
        ((CustomCellEditor2)this.tbNamespaces.getColumnModel().getColumn(1).getCellEditor()).dispose();
    }

    private void initUI() {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(430, 500));
        this.cbXPath.setEditable(true);
        this.cbXPath.setModel(new DefaultComboBoxModel());
        this.lblXpath.setText("XPath expression");
        this.lblVars.setText("Variables");
        this.lblNamespaces.setText("Namespaces");
        this.contentPane.setPreferredSize(new Dimension(379, 350));
        this.btnApplyFromRoot.setToolTipText("Apply this XPath expression from the root node");
        this.btnApplyFromRoot.setText("Apply from root");
        this.cBtnApplyFromCurrentNode.setToolTipText("Apply from the current document node");
        this.cBtnApplyFromCurrentNode.setText("Apply from current");
        this.btnCopy.setToolTipText("Copy the current XPath expression");
        this.btnCopy.setText("Copy");
        this.lblResult.setText("Result");
        this.tbResult.setToolTipText("Click on a line for selecting the same one in the editor");
        this.contentPane.add((Component)this.lblXpath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 17, 0, 31), 0, 0));
        this.contentPane.add((Component)this.cbXPath, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 17, 0, 17), 0, 0));
        this.contentPane.add((Component)this.spVariables, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 17, 0, 17), 0, 0));
        this.contentPane.add((Component)this.lblVars, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 17, 0, 81), 0, 0));
        this.spVariables.getViewport().add((Component)this.tbVariables, null);
        this.contentPane.add((Component)this.lblNamespaces, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 17, 0, 61), 0, 0));
        this.contentPane.add((Component)this.spNamespaces, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 17, 0, 17), 0, 0));
        this.contentPane.add((Component)this.btnApplyFromRoot, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 17, 0, 0), 0, 0));
        this.spNamespaces.getViewport().add((Component)this.tbNamespaces, null);
        this.contentPane.add((Component)this.lblResult, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 17, 0, 99), 0, 0));
        this.contentPane.add((Component)this.spResult, new GridBagConstraints(0, 8, 3, 2, 1.0, 1.0, 10, 1, new Insets(0, 17, 17, 17), 0, 0));
        this.spResult.getViewport().add((Component)this.tbResult, null);
        this.contentPane.add((Component)this.btnCopy, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 7, 0, 17), 25, -5));
        this.contentPane.add((Component)this.cBtnApplyFromCurrentNode, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, -5));
    }

    private void initModel(DefaultTableModel defaultTableModel, DefaultTableModel defaultTableModel2) {
        this.initVariables(defaultTableModel);
        this.initNamespaces(defaultTableModel2);
        this.initResults();
    }

    private void initVariables(DefaultTableModel defaultTableModel) {
        this.modelVariables = defaultTableModel == null ? new DefaultTableModel(new String[]{"Name", "Type", "Value"}, Preferences.getPreference("xpath", "maxVariables", 20)) : defaultTableModel;
        this.tbVariables.setModel(this.modelVariables);
        this.tbVariables.getColumnModel().getColumn(1).setCellEditor(new CustomCellEditor());
        this.tbVariables.getColumnModel().getColumn(1).setCellRenderer(new CustomCellRenderer());
        this.tbVariables.getColumnModel().getColumn(2).setCellEditor(new CustomCellEditor2());
        this.tbVariables.getColumnModel().getColumn(0).setCellEditor(new CustomCellEditor2());
        this.tbVariables.setSelectionMode(0);
        this.tbVariables.setSelectionBackground(Color.WHITE);
        this.tbVariables.setSelectionForeground(Color.BLACK);
    }

    private void initNamespaces(DefaultTableModel defaultTableModel) {
        this.modelNamespaces = defaultTableModel == null ? new DefaultTableModel(new String[]{"Alias", "Namespace"}, Preferences.getPreference("xpath", "maxNamespaces", 10)) : defaultTableModel;
        this.tbNamespaces.setModel(this.modelNamespaces);
        this.tbNamespaces.setSelectionMode(0);
        this.tbNamespaces.setSelectionBackground(Color.WHITE);
        this.tbNamespaces.setSelectionForeground(Color.BLACK);
        this.tbNamespaces.getColumnModel().getColumn(0).setCellEditor(new CustomCellEditor2());
        this.tbNamespaces.getColumnModel().getColumn(1).setCellEditor(new CustomCellEditor2());
    }

    private void initResults() {
        this.tbResult.setSelectionMode(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnApplyFromRoot) {
            this.applyFromRoot();
        } else if (actionEvent.getSource() == this.cBtnApplyFromCurrentNode) {
            this.applyFromCurrent();
        } else if (actionEvent.getSource() == this.btnCopy) {
            this.copy();
        }
    }

    private Node getNodeFromRoot() throws Throwable {
        if (this.cbXPath.getSelectedItem() == null) {
            throw new RuntimeException("No expression found");
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
        if (xMLContainer == null) {
            xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        }
        String string = xMLContainer.getText();
        Parser parser = new Parser();
        parser.setNodeFactory(new DomNodeFactory());
        parser.setReader(new StringReader(string));
        parser.parse();
        return (Node)((Object)parser.getDocument().getRoot());
    }

    private void applyFromNode(Node node) {
        this.tbResult.setModel(new DefaultTableModel(new Object[]{"Result"}, 0));
        this.unshowSyntaxError();
        try {
            XPath xPath = this.buildXPath();
            this.cbXPath.setForeground(Color.BLACK);
            if (node == null) {
                throw new RuntimeException("");
            }
            try {
                try {
                    Object object = xPath.evaluate(node);
                    if (object instanceof List) {
                        this.showResult((List)object);
                    } else if (!this.searchMode) {
                        EditixFactory.buildAndShowInformationDialog("Result = " + object);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            catch (XPathSyntaxException xPathSyntaxException) {
                this.showSyntaxError(xPathSyntaxException.getPosition(), xPathSyntaxException.getMessage());
            }
        }
        catch (Throwable throwable) {
            if ("true".equals(System.getProperty("debug.editix"))) {
                throwable.printStackTrace();
            }
            EditixFactory.buildAndShowErrorDialog("Can't apply expression : " + throwable.getMessage());
        }
    }

    private void applyFromRoot() {
        try {
            Node node = this.getNodeFromRoot();
            DocumentImpl documentImpl = new DocumentImpl((Element)node);
            this.applyFromNode(documentImpl);
        }
        catch (Throwable throwable) {
            if ("true".equals(System.getProperty("debug.editix"))) {
                throwable.printStackTrace();
            }
            EditixFactory.buildAndShowErrorDialog("Can't apply expression : " + throwable.getMessage());
        }
    }

    private void applyFromCurrent() {
        try {
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
            SimpleNode simpleNode = xMLContainer.getCurrentNode();
            if (simpleNode == null) {
                this.applyFromRoot();
            } else {
                String string = simpleNode.getXPathLocation();
                SimpleNode simpleNode2 = (SimpleNode)((Object)this.getNodeFromRoot());
                Node node = (Node)((Object)simpleNode2.getNodeForXPathLocation(string, false));
                this.applyFromNode(node);
            }
        }
        catch (Throwable throwable) {
            EditixFactory.buildAndShowErrorDialog("Can't apply expression : " + throwable.getMessage());
        }
    }

    private void copy() {
        if (this.cbXPath.getSelectedItem() == null) {
            return;
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("" + this.cbXPath.getSelectedItem()), null);
    }

    private void unshowSyntaxError() {
        this.cbXPath.setForeground(Color.BLACK);
        ((JTextComponent)this.cbXPath.getEditor().getEditorComponent()).setCaretColor(Color.BLACK);
    }

    private void showSyntaxError(int n, String string) {
        this.cbXPath.setForeground(Color.RED);
        ((JTextComponent)this.cbXPath.getEditor().getEditorComponent()).setCaretPosition(n);
        ((JTextComponent)this.cbXPath.getEditor().getEditorComponent()).setCaretColor(Color.red);
        EditixFactory.buildAndShowErrorDialog(string);
        this.cbXPath.requestFocus();
    }

    private void showResult(List list) {
        int n;
        String string = null;
        string = list.size() == 0 ? "No Result" : list.size() + " result(s)";
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{string}, 0);
        for (n = 0; n < list.size(); ++n) {
            defaultTableModel.addRow(new Object[]{list.get(n)});
        }
        this.tbResult.setModel(defaultTableModel);
        n = 1;
        String string2 = (String)this.cbXPath.getSelectedItem();
        for (int i = 1; i < this.cbXPath.getItemCount(); ++i) {
            if (!this.cbXPath.getItemAt(i).equals(string2)) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            this.cbXPath.addItem(string2);
        }
    }

    public String[] getItems() {
        String[] stringArray = new String[this.cbXPath.getItemCount()];
        for (int i = 0; i < this.cbXPath.getItemCount(); ++i) {
            stringArray[i] = (String)this.cbXPath.getItemAt(i);
        }
        return stringArray;
    }

    public void setItems(String[] stringArray) {
        this.cbXPath.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public DefaultTableModel getVariablesModel() {
        return this.modelVariables;
    }

    public DefaultTableModel getNamespacesModel() {
        return this.modelNamespaces;
    }

    public void setVariablesModel(DefaultTableModel defaultTableModel) {
        this.tbVariables.setModel(defaultTableModel);
    }

    public void setNamespacesModel(DefaultTableModel defaultTableModel) {
        this.tbNamespaces.setModel(defaultTableModel);
    }

    private XPath buildXPath() throws Throwable {
        String string;
        String string2;
        DOMXPath dOMXPath = new DOMXPath((String)this.cbXPath.getSelectedItem());
        SimpleVariableContext simpleVariableContext = null;
        for (int i = 0; i < this.modelVariables.getRowCount(); ++i) {
            String string3 = (String)this.modelVariables.getValueAt(i, 0);
            if (string3 == null || "".equals(string3) || string3.length() <= 0) continue;
            if (simpleVariableContext == null) {
                simpleVariableContext = new SimpleVariableContext();
                dOMXPath.setVariableContext(simpleVariableContext);
            }
            string2 = (String)this.modelVariables.getValueAt(i, 1);
            string = (String)this.modelVariables.getValueAt(i, 2);
            if (string == null) continue;
            if ("String".equals(string2)) {
                simpleVariableContext.setVariableValue(string3, string);
                continue;
            }
            if ("Decimal".equals(string2)) {
                simpleVariableContext.setVariableValue(string3, new Double("" + string));
                continue;
            }
            if (!"Boolean".equals(string2)) continue;
            String string4 = ("" + string).toLowerCase();
            simpleVariableContext.setVariableValue(string3, new Boolean("true".equals(string4)));
        }
        SimpleNamespaceContext simpleNamespaceContext = null;
        for (int i = 0; i < this.modelNamespaces.getRowCount(); ++i) {
            string2 = (String)this.modelNamespaces.getValueAt(i, 0);
            if (string2 == null || "".equals(string2) || string2.length() <= 0 || (string = (String)this.modelNamespaces.getValueAt(i, 1)) == null) continue;
            if (simpleNamespaceContext == null) {
                simpleNamespaceContext = new SimpleNamespaceContext();
                dOMXPath.setNamespaceContext(simpleNamespaceContext);
            }
            simpleNamespaceContext.addNamespace(string2, string);
        }
        return dOMXPath;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tbResult.getSelectedRow();
        if (n > -1) {
            SimpleNode simpleNode = (SimpleNode)this.tbResult.getModel().getValueAt(n, 0);
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
            if (simpleNode.getStartingLine() > 0) {
                xMLContainer.getEditor().highlightLine(simpleNode.getStartingLine());
            }
        }
    }

    class CustomCellEditor
    extends DefaultCellEditor {
        private JComboBox cb;
        private int lastRow;

        public CustomCellEditor() {
            super(new JComboBox<String>(new String[]{"String", "Decimal", "Boolean"}));
            this.cb = null;
            this.lastRow = 0;
            this.cb = (JComboBox)this.getComponent();
            this.cb.setSelectedIndex(0);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.lastRow = n;
            this.cb.setSelectedItem(object);
            return this.cb;
        }

        public boolean stopCellEditing() {
            XPathDialog.this.modelVariables.setValueAt(this.cb.getSelectedItem(), this.lastRow, 1);
            return super.stopCellEditing();
        }

        public void cancelCellEditing() {
            this.stopCellEditing();
        }
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private JComboBox cb = new JComboBox<String>(new String[]{"String", "Decimal", "Boolean"});

        public CustomCellRenderer() {
            this.cb.setSelectedIndex(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.cb.setSelectedItem(object);
            return this.cb;
        }
    }

    class CustomCellEditor2
    extends DefaultCellEditor
    implements FocusListener {
        private JTextField tf;
        private int lastRow;
        private int lastCol;

        public CustomCellEditor2() {
            super(new JTextField());
            this.tf = null;
            this.lastRow = 0;
            this.lastCol = 0;
            this.tf = (JTextField)this.getComponent();
            this.tf.addFocusListener(this);
        }

        public void dispose() {
            this.tf.removeFocusListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.lastRow = n;
            this.lastCol = n2;
            this.tf.setText(object == null ? "" : object.toString());
            return this.tf;
        }

        public boolean stopCellEditing() {
            XPathDialog.this.modelVariables.setValueAt(this.tf.getText(), this.lastRow, this.lastCol);
            return super.stopCellEditing();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.stopCellEditing();
        }
    }
}

