/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.EditixStatusBar;
import com.japisoft.framework.actions.SynchronizableAction;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class LockedTagAction
extends AbstractAction
implements SynchronizableAction {
    private Icon okIcon = null;

    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        boolean bl = xMLContainer.getDocumentIntegrity().isProtectTag();
        if (bl) {
            xMLContainer.getDocumentIntegrity().setProtectTag(false);
            EditixStatusBar.ACCESSOR.setXPathLocation("Tag update enabled");
        } else {
            xMLContainer.getDocumentIntegrity().setProtectTag(true);
            EditixStatusBar.ACCESSOR.setXPathLocation("Tag update disabled");
        }
        xMLContainer.setProperty(this.getClass().getName(), "" + !bl);
        this.refreshState(xMLContainer);
    }

    public void synchronizeState(Object object) {
        if (object instanceof XMLContainer) {
            XMLContainer xMLContainer = (XMLContainer)object;
            boolean bl = this.refreshState(xMLContainer);
            if (bl) {
                if (!xMLContainer.getDocumentIntegrity().isProtectTag()) {
                    xMLContainer.getDocumentIntegrity().setProtectTag(true);
                }
            } else if (xMLContainer.getDocumentIntegrity().isProtectTag()) {
                xMLContainer.getDocumentIntegrity().setProtectTag(false);
            }
            xMLContainer.getEditor().requestFocus();
            xMLContainer.getEditor().repaint();
        }
    }

    private boolean refreshState(XMLContainer xMLContainer) {
        boolean bl = "true".equals(xMLContainer.getProperty(this.getClass().getName(), "false"));
        if (!bl) {
            if (this.okIcon == null) {
                this.okIcon = (Icon)this.getValue("SmallIcon");
            }
            this.putValue("SmallIcon", this.okIcon);
        } else {
            if (this.okIcon == null) {
                this.okIcon = (Icon)this.getValue("SmallIcon");
            }
            this.putValue("SmallIcon", this.getValue("SmallIcon2"));
        }
        return bl;
    }
}

