/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xsl;

import com.japisoft.editix.EditixEntityResolver;
import com.japisoft.editix.action.fop.FOPAction;
import com.japisoft.editix.action.xquery.XQueryAction;
import com.japisoft.editix.action.xsl.XSLTDialog;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.toolkit.Toolkit;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.editix.xslt.debug.XSLTManager;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.job.HeavyJob;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.xml.XSLTTransformer;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.xml.validator.XMLPadSAXParserFactory;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.w3c.dom.Node;

public class XSLTAction
extends AbstractAction
implements HeavyJob,
ErrorListener {
    private boolean transformationError = false;
    private static XMLContainer workingContainer;
    protected IXMLPanel containerXSLT;
    public String errorMessage = null;
    protected String prefixForParameter = "xslt";
    public static boolean DEBUG_MODE;

    public void error(TransformerException transformerException) throws TransformerException {
        XSLTManager.processError(this.containerXSLT != null ? this.containerXSLT.getMainContainer() : workingContainer, transformerException);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        XSLTManager.processError(this.containerXSLT != null ? this.containerXSLT.getMainContainer() : workingContainer, transformerException);
    }

    public void warning(TransformerException transformerException) throws TransformerException {
    }

    protected void initAction() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.initAction();
        this.transformationError = false;
        workingContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (workingContainer == null) {
            return;
        }
        IXMLPanel iXMLPanel = EditixFrame.ACCESSOR.getSelectedPanel();
        if (EditixFactory.mustSaveDialog(workingContainer)) {
            return;
        }
        boolean bl = ActionModel.activeActionByName(ActionModel.SAVE_ACTION, workingContainer, workingContainer.getEditor());
        if (!bl) {
            return;
        }
        XSLTDialog xSLTDialog = this.getDialog();
        xSLTDialog.init(iXMLPanel);
        xSLTDialog.setVisible(true);
        xSLTDialog.dispose();
        if (xSLTDialog.isOk()) {
            xSLTDialog.store(iXMLPanel);
            this.transform(iXMLPanel, true, false, false, this);
        } else {
            workingContainer = null;
        }
    }

    protected XSLTDialog getDialog() {
        return EditixFactory.getConfigDialog(false);
    }

    public String getName() {
        if (this instanceof XQueryAction) {
            return "XQuery Transforming";
        }
        return "XSLT Transforming";
    }

    public void dispose() {
        this.containerXSLT = null;
        workingContainer = null;
    }

    public Object getSource() {
        return null;
    }

    public boolean isAlone() {
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void run() {
        this.errorMessage = null;
        this.containerXSLT.getMainContainer().getErrorManager().initErrorProcessing();
        boolean bl = XSLTAction.finalTransform(this.containerXSLT, DEBUG_MODE, false, this);
        if (!bl) {
            this.errorMessage = "Error found";
        }
        this.containerXSLT.getMainContainer().getErrorManager().stopErrorProcessing();
    }

    public void stopIt() {
    }

    public static TransformerFactory getTransformerFactoryV1(boolean bl) {
        TransformerFactory transformerFactory = null;
        if (bl) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            transformerFactory = new com.icl.saxon.TransformerFactoryImpl();
        } else {
            transformerFactory = XSLTTransformer.getTransformerFactory();
        }
        return transformerFactory;
    }

    public static TransformerFactory getTransformerFactoryV2(boolean bl) {
        TransformerFactoryImpl transformerFactoryImpl = null;
        if (bl) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        transformerFactoryImpl = new TransformerFactoryImpl();
        try {
            transformerFactoryImpl.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            transformerFactoryImpl.setAttribute("http://saxon.sf.net/feature/optimizationLevel", new Integer(0));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return transformerFactoryImpl;
    }

    public boolean transform(IXMLPanel iXMLPanel, boolean bl, boolean bl2, boolean bl3, ErrorListener errorListener) {
        return XSLTAction.applyTransformation(iXMLPanel, bl, bl2, bl3, errorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean applyTransformation(IXMLPanel iXMLPanel, boolean bl, boolean bl2, boolean bl3, ErrorListener errorListener) {
        DEBUG_MODE = bl2;
        if (!bl || bl2 || bl3) {
            try {
                iXMLPanel.getMainContainer().getErrorManager().initErrorProcessing();
                boolean bl4 = XSLTAction.finalTransform(iXMLPanel, bl2, bl3, errorListener);
                return bl4;
            }
            finally {
                iXMLPanel.getMainContainer().getErrorManager().stopErrorProcessing();
                workingContainer = null;
            }
        }
        XSLTAction xSLTAction = (XSLTAction)com.japisoft.framework.application.descriptor.ActionModel.restoreAction("transformFromXSLT");
        if (xSLTAction == null) {
            System.err.println("Can't find XSLT action transformFromXSLT");
            return false;
        }
        xSLTAction.containerXSLT = iXMLPanel;
        xSLTAction.errorMessage = null;
        JobManager.addJob(xSLTAction);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean finalTransform(IXMLPanel iXMLPanel, boolean bl, boolean bl2, ErrorListener errorListener) {
        Object object;
        double d;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        XMLContainer xMLContainer;
        String string;
        String string2;
        String string3;
        block26: {
            string3 = (String)iXMLPanel.getProperty("xslt.data.file");
            string2 = (String)iXMLPanel.getProperty("xslt.xslt.file");
            string = (String)iXMLPanel.getProperty("xslt.result.file");
            if (string3 == null || "".equals(string3)) {
                EditixFactory.buildAndShowErrorDialog("No data file");
                return false;
            }
            if (string2 == null || "".equals(string2)) {
                EditixFactory.buildAndShowErrorDialog("No stylesheet ?");
                return false;
            }
            xMLContainer = iXMLPanel.getMainContainer();
            String string4 = xMLContainer.getDocumentInfo().getType();
            if (xMLContainer.hasErrorMessage()) {
                xMLContainer.getErrorManager().notifyNoError(false);
            }
            bl5 = "true".equals((String)iXMLPanel.getProperty("xslt.openFile"));
            bl4 = "true".equals((String)iXMLPanel.getProperty("xslt.displayFile"));
            bl3 = "true".equals((String)iXMLPanel.getProperty("xslt.fop"));
            d = 1.0;
            if ("XSLT".equals(string4) || "XSLT2".equals(string4)) {
                if (xMLContainer.getRootNode() != null && (object = xMLContainer.getRootNode().getAttribute("version")) != null) {
                    try {
                        d = Double.parseDouble((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                try {
                    object = new BufferedReader(new FileReader(string2));
                    try {
                        String string5 = null;
                        ((BufferedReader)object).readLine();
                        boolean bl6 = false;
                        while ((string5 = ((BufferedReader)object).readLine()) != null) {
                            if (string5.indexOf("stylesheet") > -1) {
                                bl6 = true;
                            }
                            if (!bl6) continue;
                            int n = 0;
                            String string6 = null;
                            n = string5.indexOf("version");
                            if (n <= -1) continue;
                            for (int i = n + 7; i < string5.length(); ++i) {
                                if (string5.charAt(i) == '\"' || string5.charAt(i) == '\'') {
                                    if (string6 != null) {
                                        d = Double.parseDouble(string6);
                                        break block26;
                                    }
                                    string6 = "";
                                    continue;
                                }
                                if (string6 == null) continue;
                                string6 = string6 + string5.charAt(i);
                            }
                        }
                    }
                    finally {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        object = null;
        if (d == 2.0) {
            object = XSLTAction.getTransformerFactoryV2(bl);
        } else if (d == 1.0) {
            object = XSLTAction.getTransformerFactoryV1(bl);
        }
        ((TransformerFactory)object).setErrorListener(errorListener);
        return XSLTAction.applyCommonTransformation((int)d, bl5, bl4, bl3, string3, string2, string, xMLContainer, iXMLPanel, bl, bl2, (TransformerFactory)object);
    }

    private static boolean applyCommonTransformation(int n, boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, XMLContainer xMLContainer, IXMLPanel iXMLPanel, boolean bl4, boolean bl5, TransformerFactory transformerFactory) {
        if ("".equals(string3)) {
            string3 = "temp.xml";
        }
        if (bl4) {
            XSLTManager.updateDebugListenerForFactory(iXMLPanel, transformerFactory);
        }
        if (bl5) {
            XSLTManager.updateProfilerListenerForFactory(iXMLPanel, transformerFactory);
        }
        transformerFactory.setURIResolver((URIResolver)((Object)EditixEntityResolver.getInstance()));
        if ("true".equals(System.getProperty("editix.debug"))) {
            System.out.println("Transformer=" + transformerFactory);
        }
        String string4 = null;
        String string5 = null;
        Object object = null;
        xMLContainer.getErrorManager().notifyNoError(false);
        try {
            int n2;
            Object object2;
            Object object3;
            Object object4;
            Transformer transformer = null;
            try {
                object4 = Toolkit.getCurrentFileEncoding();
                object = "DEFAULT".equals(object4) || "AUTOMATIC".equals(object4) ? null : object4;
                object3 = null;
                try {
                    object3 = transformerFactory.getAssociatedStylesheet(new StreamSource(string2), string4, string5, (String)object);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    // empty catch block
                }
                transformer = object3 == null ? transformerFactory.newTransformer(new StreamSource(string2)) : transformerFactory.newTransformer((Source)object3);
            }
            catch (TransformerException transformerException) {
                XSLTManager.processError(xMLContainer, transformerException);
                return false;
            }
            if (string3 == null) {
                string3 = xMLContainer.getCurrentDocumentLocation();
                object4 = new File(string3).getParentFile();
                string3 = new File((File)object4, "XSLResult").toString();
            }
            for (int i = 0; i < 100; ++i) {
                object3 = (String)iXMLPanel.getProperty("xslt.param.name." + i);
                object2 = (String)iXMLPanel.getProperty("xslt.param.value." + i);
                if (object3 == null || object2 == null || "".equals(object3) || "".equals(object2)) continue;
                ApplicationModel.debug("Parameter : " + (String)object3 + " = " + (String)object2);
                transformer.setParameter((String)object3, object2);
            }
            StreamResult streamResult = null;
            object3 = null;
            if (!bl4) {
                object2 = XMLPadSAXParserFactory.getNewDocumentBuilder(false, false);
                if (SharedProperties.DEFAULT_ENTITY_RESOLVER != null) {
                    ((DocumentBuilder)object2).setEntityResolver(SharedProperties.DEFAULT_ENTITY_RESOLVER);
                }
                try {
                    object3 = ((DocumentBuilder)object2).parse(new File(string));
                }
                catch (Throwable throwable) {
                    xMLContainer.getErrorManager().notifyError("Can't parse the data source " + string + " Please fix it before transforming", 0);
                    return false;
                }
            }
            object2 = null;
            object2 = object3 != null ? new DOMSource((Node)object3) : new StreamSource(string);
            String string6 = null;
            String string7 = null;
            if (bl3 && (n2 = string3.lastIndexOf(".")) > -1) {
                string6 = string3.substring(n2 + 1).toLowerCase();
                string7 = string3;
                string3 = string3.substring(0, n2 + 1) + "fo";
            }
            streamResult = n == 1 ? new StreamResult(string3) : new StreamResult(new File(string3));
            workingContainer = iXMLPanel.getMainContainer();
            transformer.transform((Source)object2, streamResult);
            workingContainer = null;
            if (bl) {
                String string8 = DocumentModel.getTypeForFileName(string3);
                com.japisoft.framework.application.descriptor.ActionModel.activeActionById("open", null, string3, string8);
            } else if (bl2) {
                BrowserCaller.displayURL(string3);
            } else if (bl3) {
                if ("pdf".equals(string6)) {
                    iXMLPanel.setProperty("fo.render", "PDF");
                } else if ("rtf".equals(string6)) {
                    iXMLPanel.setProperty("fo.render", "RTF");
                } else if ("svg".equals(string6)) {
                    iXMLPanel.setProperty("fo.render", "SVG");
                } else if ("ps".equals(string6)) {
                    iXMLPanel.setProperty("fo.render", "PS");
                } else {
                    EditixFactory.buildAndShowWarningDialog("Unknown FOP target file :" + string6 + "?");
                    return false;
                }
                iXMLPanel.setProperty("fo.output", string7);
                iXMLPanel.setProperty("fo.source", string3);
                FOPAction.applyFO(iXMLPanel.getMainContainer(), false);
            }
            if (!bl3 && iXMLPanel instanceof IXMLPanel) {
                iXMLPanel.setProperty(XSLTEditor.LOADRES_CMD, "ok");
            }
        }
        catch (TransformerException transformerException) {
            ApplicationModel.debug(transformerException);
            XSLTManager.processError(xMLContainer, transformerException);
        }
        catch (Throwable throwable) {
            ApplicationModel.debug(throwable);
            return false;
        }
        return true;
    }

    static {
        DEBUG_MODE = false;
    }
}

