/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.berkley;

import com.japisoft.editix.db.AbstractNodeDb;
import com.japisoft.editix.db.ContainerNodeDb;
import com.japisoft.editix.db.NodeDb;
import com.japisoft.editix.db.berkley.BerkleyFileNodeImpl;
import com.japisoft.editix.db.berkley.BerkleyRootDbImpl;
import com.japisoft.editix.ui.EditixFactory;
import com.sleepycat.dbxml.XmlContainer;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlValue;

public class BerkleyContainerDbImpl
extends AbstractNodeDb
implements ContainerNodeDb {
    protected XmlContainer container;

    public BerkleyContainerDbImpl(XmlContainer xmlContainer) {
        this.container = xmlContainer;
    }

    public boolean canCreateSubContainer() {
        return false;
    }

    public ContainerNodeDb createSubContainer(String string) throws Exception {
        return null;
    }

    public String getContent(String string) throws Exception {
        return this.container.getDocument(string).getContentAsString();
    }

    public boolean delete(String string) throws Exception {
        if (EditixFactory.buildAndShowConfirmDialog("This operation may crash EditiX due a problem with the berkley API, are you sure ?")) {
            this.container.deleteDocument(string);
            return true;
        }
        return false;
    }

    public NodeDb[] request(String string) throws Exception {
        return ((BerkleyRootDbImpl)this.getParent()).request(string);
    }

    public void setContent(String string, String string2) throws Exception {
        this.container.putDocument(string, string2);
    }

    public void setContent(XmlDocument xmlDocument) throws Exception {
        this.container.updateDocument(xmlDocument);
        this.container.sync();
    }

    public void open() throws Exception {
        XmlResults xmlResults = this.container.getAllDocuments(null);
        if (xmlResults != null) {
            while (xmlResults.hasNext()) {
                XmlValue xmlValue = xmlResults.next();
                XmlDocument xmlDocument = xmlValue.asDocument();
                this.addChild(new BerkleyFileNodeImpl(xmlDocument));
            }
        }
    }

    public void close() {
        try {
            this.container.close();
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
        super.close();
    }

    public void refresh() throws Exception {
    }
}

