/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.xmldb;

import com.japisoft.editix.db.NodeDb;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.db.xmldb.XmlDbContainerDbImpl;
import com.japisoft.editix.db.xmldb.XmlDbFileNodeDbImpl;
import com.japisoft.editix.ui.EditixFactory;
import java.util.ArrayList;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XPathQueryService;

public class XmlDbRootDbImpl
extends XmlDbContainerDbImpl
implements RootNodeDb {
    public static String XMLRESOURCE_TYPE = "XMLResource";
    public static String BINARYRESOURCE_TYPE = "BinaryResource";

    public XmlDbRootDbImpl(String string, String string2, String string3, String string4) throws Exception {
        super(null);
        this.driverName = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
        int n = string2.indexOf("/");
        String string5 = string2.substring(0, n);
        n = string2.indexOf("//");
        int n2 = string2.indexOf("/", n + 2);
        String string6 = string2.substring(n + 2, n2);
        this.name = string5 + "-" + string6;
        if (string2.endsWith("/")) {
            string2 = string2 + "db";
        }
        this.col = DatabaseManager.getCollection((String)string2, (String)string3, (String)string4);
    }

    public String toString() {
        return this.name;
    }

    public boolean canConnect() {
        try {
            return this.col != null && this.col.isOpen() && this.col.getResourceCount() >= 0;
        }
        catch (XMLDBException xMLDBException) {
            return false;
        }
    }

    public NodeDb[] request(String string) throws Exception {
        return this.request(this.col, string);
    }

    public NodeDb[] request(Collection collection, String string) throws Exception {
        NodeDb[] nodeDbArray;
        Service[] serviceArray = collection.getServices();
        if (serviceArray == null) {
            throw new Exception("Can't execute a query for this database");
        }
        XPathQueryService xPathQueryService = null;
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!(serviceArray[i] instanceof XPathQueryService)) continue;
            xPathQueryService = (XPathQueryService)serviceArray[i];
            break;
        }
        if (xPathQueryService == null) {
            xPathQueryService = (XPathQueryService)collection.getService("XPathQueryService", "1.0");
        }
        if (xPathQueryService == null) {
            throw new Exception("Can't find a service for this query");
        }
        xPathQueryService.setProperty("indent", "yes");
        ResourceSet resourceSet = xPathQueryService.query(string);
        ResourceIterator resourceIterator = resourceSet.getIterator();
        ArrayList<XmlDbFileNodeDbImpl> arrayList = new ArrayList<XmlDbFileNodeDbImpl>();
        XmlDbContainerDbImpl xmlDbContainerDbImpl = null;
        String string2 = null;
        while (resourceIterator.hasMoreResources()) {
            nodeDbArray = resourceIterator.nextResource();
            Collection collection2 = nodeDbArray.getParentCollection();
            if (collection2 == null) continue;
            if (string2 == null || !collection2.getName().equals(string2)) {
                if ((collection2 = this.getCollectionByName(collection2.getName())) == null) {
                    EditixFactory.buildAndShowInformationDialog("" + nodeDbArray.getContent());
                    continue;
                }
                xmlDbContainerDbImpl = new XmlDbContainerDbImpl(collection2);
            }
            string2 = collection2.getName();
            if (nodeDbArray.getId() == null) continue;
            XmlDbFileNodeDbImpl xmlDbFileNodeDbImpl = new XmlDbFileNodeDbImpl(xmlDbContainerDbImpl, nodeDbArray.getId());
            xmlDbContainerDbImpl.addChild(xmlDbFileNodeDbImpl);
            arrayList.add(xmlDbFileNodeDbImpl);
        }
        nodeDbArray = new NodeDb[arrayList.size()];
        for (int i = 0; i < nodeDbArray.length; ++i) {
            nodeDbArray[i] = (NodeDb)arrayList.get(i);
        }
        return nodeDbArray;
    }

    public String toXml() {
        return "<connection driver='" + this.driverName + "' url='" + this.url + "' user='" + this.user + "' password='" + this.password + "'/>";
    }

    public boolean canBeDeleted() {
        return true;
    }
}

