/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.document;

import com.japisoft.editix.Debugger;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.Encoding;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.xml.validator.Validator;
import java.awt.Color;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class DocumentModel {
    private static ArrayList model = null;
    public static String[] DOCUMENT_TYPE;
    static Hashtable PARENT_TYPE;
    static XMLDocumentInfo defDoc;

    public static String getParentType(String string) {
        return (String)PARENT_TYPE.get(string);
    }

    public static void loadModel() {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("documents.xml");
        if (inputStream == null) {
            System.err.println("Can't find documents.xml !");
            System.exit(1);
            return;
        }
        Parser parser = new Parser();
        parser.setInputStream(inputStream);
        try {
            int n;
            parser.parse();
            SimpleNode simpleNode = (SimpleNode)parser.getDocument().getRoot();
            model = new ArrayList();
            for (n = 0; n < simpleNode.childCount(); ++n) {
                model.add(DocumentModel.buildDocument(simpleNode.childAt(n)));
            }
            DOCUMENT_TYPE = new String[DocumentModel.getDocumentCount()];
            for (n = 0; n < DocumentModel.getDocumentCount(); ++n) {
                XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(n);
                DocumentModel.DOCUMENT_TYPE[n] = xMLDocumentInfo.getType();
            }
        }
        catch (Exception exception) {
            System.err.println("Can't parse documents.xml : " + exception.getMessage() + " !");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static int getDocumentCount() {
        if (model == null) {
            return 0;
        }
        return model.size();
    }

    static XMLDocumentInfo prepareDocument(XMLDocumentInfo xMLDocumentInfo) {
        xMLDocumentInfo.setParam("default-encoding", Preferences.getPreference("template", "default-encoding", Encoding.BASIC_ENCODINGS)[0]);
        xMLDocumentInfo.setParam("company", Preferences.getPreference("template", "company", ""));
        xMLDocumentInfo.setParam("firstName", Preferences.getPreference("template", "firstName", ""));
        xMLDocumentInfo.setParam("lastName", Preferences.getPreference("template", "lastName", ""));
        xMLDocumentInfo.setParam("address", Preferences.getPreference("template", "address", ""));
        xMLDocumentInfo.setParam("phone", Preferences.getPreference("template", "phone", ""));
        xMLDocumentInfo.setParam("email", Preferences.getPreference("template", "email", ""));
        xMLDocumentInfo.setParam("website", Preferences.getPreference("template", "website", ""));
        return xMLDocumentInfo;
    }

    public static XMLDocumentInfo getDocumentForType(String string) {
        for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
            XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(i);
            if (!xMLDocumentInfo.getType().equals(string)) continue;
            return DocumentModel.prepareDocument(xMLDocumentInfo);
        }
        throw new RuntimeException("Can't find the type " + string);
    }

    public static XMLDocumentInfo getDocumentForExt(String string) {
        if (string != null) {
            for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
                XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(i);
                if (!xMLDocumentInfo.matchFileExt(string)) continue;
                return xMLDocumentInfo;
            }
        }
        return DocumentModel.getDefaultDocument();
    }

    public static XMLDocumentInfo getDocumentAt(int n) {
        if (model == null) {
            return null;
        }
        return (XMLDocumentInfo)model.get(n);
    }

    public static XMLDocumentInfo getDefaultDocument() {
        if (defDoc == null) {
            defDoc = DocumentModel.getDocumentForType("XML");
        }
        return defDoc;
    }

    public static XMLDocumentInfo getDocumentByFileName(String string) {
        if (string == null) {
            return new XMLDocumentInfo();
        }
        String string2 = "xml";
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForExt(string2);
        return xMLDocumentInfo;
    }

    public static String getTypeForFileName(String string) {
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentByFileName(string);
        return xMLDocumentInfo.getType();
    }

    static XMLDocumentInfo buildDocument(SimpleNode simpleNode) {
        String string;
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        SimpleNode simpleNode2;
        XMLDocumentInfo xMLDocumentInfo = new XMLDocumentInfo();
        if (defDoc == null) {
            defDoc = xMLDocumentInfo;
        }
        SimpleNode simpleNode3 = simpleNode.childAt(0);
        String string2 = simpleNode3.getAttribute("icon");
        boolean bl = "true".equals(simpleNode3.getAttribute("tree"));
        String string3 = simpleNode3.getAttribute("systemHelper");
        boolean bl2 = "true".equals(simpleNode3.getAttribute("rt", "true"));
        xMLDocumentInfo.setRealTimeTree(bl2);
        xMLDocumentInfo.setTreeAvailable(bl);
        xMLDocumentInfo.setSystemHelperClass(string3);
        boolean bl3 = "true".equals(simpleNode3.getAttribute("sc", "true"));
        xMLDocumentInfo.setSyntaxColor(bl3);
        boolean bl4 = "true".equals(simpleNode3.getAttribute("ac", "true"));
        xMLDocumentInfo.setAutoClosing(bl4);
        boolean bl5 = "true".equals(simpleNode3.getAttribute("sh", "true"));
        xMLDocumentInfo.setSyntaxHelper(bl5);
        xMLDocumentInfo.setType(simpleNode.getAttribute("type"));
        xMLDocumentInfo.setDocumentDescription(simpleNode.getAttribute("label"));
        xMLDocumentInfo.setParentType(simpleNode.getAttribute("parentType"));
        xMLDocumentInfo.setSelectFirstTagAfterReading("true".equals(simpleNode.getAttribute("selectTag")));
        if (xMLDocumentInfo.getParentType() != null && xMLDocumentInfo.getType() != null) {
            PARENT_TYPE.put(xMLDocumentInfo.getType(), xMLDocumentInfo.getParentType());
        }
        if (string2 != null) {
            try {
                xMLDocumentInfo.setDocumentIconPath(string2);
                xMLDocumentInfo.setDocumentIcon(EditixFactory.getImageIcon(string2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("ext"), false);
        while (enumeration.hasMoreElements()) {
            simpleNode2 = (SimpleNode)enumeration.nextElement();
            xMLDocumentInfo.addFileExt(simpleNode2.getAttribute("name"));
            if (!"true".equals(simpleNode2.getAttribute("def"))) continue;
            object3 = null;
            object3 = simpleNode2.getAttribute("name");
            xMLDocumentInfo.setDefaultFileExt((String)object3);
        }
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("defDTD"), false);
        if (enumeration.hasMoreElements()) {
            simpleNode2 = (SimpleNode)enumeration.nextElement();
            object3 = simpleNode2.getAttribute("path");
            object2 = simpleNode2.getAttribute("doc");
            if (object3 != null) {
                Debugger.print("Reset DTD " + (String)object3 + " for " + xMLDocumentInfo.getType());
                xMLDocumentInfo.setDefaultDTD(simpleNode2.getAttribute("root"), (String)object3);
                if (object2 != null) {
                    serializable = ClassLoader.getSystemResource((String)object2);
                    object2 = ((URL)serializable).toExternalForm();
                }
                xMLDocumentInfo.setDTDExternalCommentFile((String)object2);
            }
        } else {
            Debugger.print("No DTD for " + xMLDocumentInfo.getType());
        }
        simpleNode2 = treeWalker.getOneNodeByCriteria(new NodeNameCriteria("namespace"), false);
        if (simpleNode2 != null) {
            if (simpleNode2.childCount() > 0) {
                object3 = simpleNode2.childAt(0).getContent();
                xMLDocumentInfo.setDefaultNamespace((String)object3);
            } else {
                System.err.println("No namespace content for the document model !");
            }
        }
        if ((object3 = treeWalker.getOneNodeByCriteria(new NodeNameCriteria("activator"), false)) != null && (object2 = ((SimpleNode)object3).getAttribute("attributes")) != null) {
            serializable = new StringTokenizer((String)object2, ";,");
            object = new String[((StringTokenizer)((Object)serializable)).countTokens()];
            int n = 0;
            while (((StringTokenizer)((Object)serializable)).hasMoreTokens()) {
                object[n++] = ((StringTokenizer)((Object)serializable)).nextToken();
            }
            xMLDocumentInfo.setListOfAttributesWithAutoAssistant((String[])object);
        }
        if ((enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("defSchema"), false)).hasMoreElements() && (serializable = ((SimpleNode)(object2 = (SimpleNode)enumeration.nextElement())).getAttribute("path")) != null) {
            Debugger.print("Reset Schema " + (String)((Object)serializable) + " for " + xMLDocumentInfo.getType());
            xMLDocumentInfo.setDefaultSchema(((SimpleNode)object2).getAttribute("root"), (String)((Object)serializable));
        }
        if ((object2 = treeWalker.getFirstTagNodeByName("validator", false)) != null) {
            if (((SimpleNode)object2).hasAttribute("schemaPath")) {
                serializable = ClassLoader.getSystemClassLoader().getResource(((SimpleNode)object2).getAttribute("schemaPath"));
                if (serializable != null) {
                    xMLDocumentInfo.setSchemaXSDValid((URL)serializable);
                    xMLDocumentInfo.setSchemaXSDNSValid(((SimpleNode)object2).getAttribute("schemaNS"));
                } else {
                    ApplicationModel.debug("Can't find " + ((SimpleNode)object2).getAttribute("schemaPath") + "!!!");
                }
            } else if (((SimpleNode)object2).hasAttribute("relaxngPath")) {
                serializable = ClassLoader.getSystemClassLoader().getResource(((SimpleNode)object2).getAttribute("relaxngPath"));
                if (serializable != null) {
                    xMLDocumentInfo.setSchemaRNGValid((URL)serializable);
                } else {
                    ApplicationModel.debug("Can't find " + ((SimpleNode)object2).getAttribute("relaxngPath") + "!!!");
                }
            } else if (((SimpleNode)object2).hasAttribute("class")) {
                try {
                    serializable = (Validator)Class.forName(((SimpleNode)object2).getAttribute("class")).newInstance();
                    xMLDocumentInfo.setCustomValidator((Validator)((Object)serializable));
                }
                catch (Exception exception) {
                    Debug.debug(exception);
                }
            }
        }
        serializable = null;
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("assistant"), false);
        while (enumeration.hasMoreElements()) {
            object = (SimpleNode)enumeration.nextElement();
            String string4 = ((SimpleNode)object).getAttribute("class");
            if ("none".equals(string4)) {
                xMLDocumentInfo.setDefaultAssistant(false);
                break;
            }
            if (serializable == null) {
                serializable = new ArrayList();
            }
            try {
                ApplicationModel.debug("Loading " + string4);
                serializable.add(Class.forName(string4).newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (serializable != null) {
            xMLDocumentInfo.setHelperHandlers((ArrayList)serializable, "true".equals(simpleNode.getAttribute("assistantAppend")));
        }
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("refactor"), false);
        object = null;
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode4 = (SimpleNode)enumeration.nextElement();
            string = simpleNode4.getAttribute("class");
            try {
                ApplicationModel.debug("Loading " + string);
                if (object == null) {
                    object = new ArrayList();
                }
                ((ArrayList)object).add(Class.forName(string).newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (object != null) {
            xMLDocumentInfo.setProperty("refactor", object);
        }
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("prefix"), false);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode5 = (SimpleNode)enumeration.nextElement();
            string = simpleNode5.getAttribute("name");
            String string5 = simpleNode5.getAttribute("color");
            Color color = Color.decode(string5);
            xMLDocumentInfo.setColorForPrefix(string, color);
        }
        if ("DTD".equals(xMLDocumentInfo.getType())) {
            xMLDocumentInfo.setDtdMode(true);
        }
        return xMLDocumentInfo;
    }

    static {
        PARENT_TYPE = new Hashtable();
        DocumentModel.loadModel();
        defDoc = null;
    }
}

