/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.template;

import com.japisoft.editix.document.TemplateInfo;
import com.japisoft.editix.document.TemplateModel;
import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.dialog.actions.AbstractDialogAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewTemplateDialog
extends EditixDialog
implements ChangeListener,
MouseListener,
ActionListener,
ListSelectionListener {
    private JTabbedPane tp = new JTabbedPane(3);
    private boolean editMode = false;
    boolean modified = false;
    private JList systemDoc = null;
    private JList userDoc = null;

    public NewTemplateDialog() {
        super("New document", "New document", "Select a document template. Use the Template menu for changing it");
        this.initUI();
    }

    public void preparePanelButtons() {
    }

    public NewTemplateDialog(boolean bl) {
        super("Edit template", "Edit/Remove template", "Edit template or remove it");
        this.editMode = bl;
        this.initUI();
        if (bl) {
            JToolBar jToolBar = new JToolBar();
            AbstractDialogAction abstractDialogAction = null;
            if (!this.actionModel.hasDialogActionForId(20)) {
                abstractDialogAction = new AbstractDialogAction(20, false){};
                abstractDialogAction.putValue("Name", "Edit");
                abstractDialogAction.putValue("ActionCommandKey", "Edit");
                abstractDialogAction.setForDialogFooter(false);
                this.actionModel.addDialogAction(abstractDialogAction);
                jToolBar.add(abstractDialogAction);
            } else {
                jToolBar.add(this.actionModel.getDialogActionForId(20));
            }
            if (!this.actionModel.hasDialogActionForId(21)) {
                abstractDialogAction = new AbstractDialogAction(21, false){};
                abstractDialogAction.putValue("Name", "Remove");
                abstractDialogAction.putValue("ActionCommandKey", "Remove");
                abstractDialogAction.setForDialogFooter(false);
                this.actionModel.addDialogAction(abstractDialogAction);
                jToolBar.add(abstractDialogAction);
            } else {
                jToolBar.add(this.actionModel.getDialogActionForId(21));
            }
            this.getContentPane().add((Component)jToolBar, "North");
        }
        this.setEnabled(21, false);
    }

    protected void beforeClosing() {
        super.beforeClosing();
        this.systemDoc.getSelectionModel().removeListSelectionListener(this);
        this.systemDoc.removeMouseListener(this);
        this.userDoc.getSelectionModel().removeListSelectionListener(this);
        this.userDoc.removeMouseListener(this);
        this.tp.removeChangeListener(this);
        if (this.actionModel.hasDialogActionForId(20)) {
            ((AbstractDialogAction)this.actionModel.getDialogActionForId(20)).setActionDelegate(null);
        }
        if (this.actionModel.hasDialogActionForId(21)) {
            ((AbstractDialogAction)this.actionModel.getDialogActionForId(21)).setActionDelegate(null);
        }
    }

    protected void beforeShowing() {
        super.beforeShowing();
        this.systemDoc.requestFocus();
        this.systemDoc.getSelectionModel().addListSelectionListener(this);
        this.systemDoc.addMouseListener(this);
        this.userDoc.getSelectionModel().addListSelectionListener(this);
        this.userDoc.addMouseListener(this);
        this.tp.addChangeListener(this);
        this.initDocuments();
        if (this.tp.getTabCount() > 1) {
            this.tp.setEnabledAt(1, this.userDoc.getModel().getSize() > 0);
        }
        if (this.actionModel.hasDialogActionForId(20)) {
            ((AbstractDialogAction)this.actionModel.getDialogActionForId(20)).setActionDelegate(this);
        }
        if (this.actionModel.hasDialogActionForId(21)) {
            ((AbstractDialogAction)this.actionModel.getDialogActionForId(21)).setActionDelegate(this);
        }
        this.systemDoc.setSelectedIndex(0);
        this.userDoc.setSelectedIndex(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TemplateInfo templateInfo = null;
        templateInfo = this.tp.getSelectedIndex() == 0 ? (TemplateInfo)this.systemDoc.getSelectedValue() : (TemplateInfo)this.userDoc.getSelectedValue();
        if (templateInfo == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if ("Edit".equals(string)) {
            String string2 = templateInfo.location;
            if (templateInfo.system) {
                URL uRL = ClassLoader.getSystemResource(templateInfo.location);
                if (uRL == null) {
                    EditixFactory.buildAndShowErrorDialog("Can't find " + templateInfo.location);
                    return;
                }
                string2 = uRL.getFile();
                if (string2 != null) {
                    string2 = string2.replaceAll("%20", " ");
                }
            }
            ActionModel.activeActionById("open", actionEvent, string2, templateInfo.type);
        } else if ("Remove".equals(string)) {
            TemplateModel.removeTemplate(templateInfo);
            this.initDocuments();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    private void initDocuments() {
        DefaultListModel defaultListModel = null;
        DefaultListModel<TemplateInfo> defaultListModel2 = null;
        if (this.systemDoc.getModel() instanceof DefaultListModel) {
            defaultListModel = (DefaultListModel)this.systemDoc.getModel();
            defaultListModel.removeAllElements();
        } else {
            defaultListModel = new DefaultListModel();
        }
        if (this.userDoc.getModel() instanceof DefaultListModel) {
            defaultListModel2 = (DefaultListModel<TemplateInfo>)this.userDoc.getModel();
            defaultListModel2.removeAllElements();
        } else {
            defaultListModel2 = new DefaultListModel<TemplateInfo>();
        }
        for (int i = 0; i < TemplateModel.getTemplateCount(); ++i) {
            if (TemplateModel.getTemplate((int)i).system) {
                defaultListModel.addElement(TemplateModel.getTemplate(i));
                continue;
            }
            if (defaultListModel2 == null) {
                defaultListModel2 = new DefaultListModel<TemplateInfo>();
            }
            defaultListModel2.addElement(TemplateModel.getTemplate(i));
        }
        this.systemDoc.setModel(defaultListModel);
        this.userDoc.setModel(defaultListModel2);
        this.systemDoc.setSelectedIndex(0);
        if (defaultListModel2.size() > 0) {
            this.userDoc.setSelectedIndex(0);
        }
    }

    private void initUI() {
        if (this.systemDoc == null) {
            this.systemDoc = new JList();
        }
        if (this.userDoc == null) {
            this.userDoc = new JList();
        }
        CustomCellRenderer customCellRenderer = new CustomCellRenderer();
        this.systemDoc.setCellRenderer(customCellRenderer);
        this.userDoc.setCellRenderer(customCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.systemDoc);
        this.tp.addTab("System", jScrollPane);
        if (this.userDoc != null) {
            this.tp.addTab("User", new JScrollPane(this.userDoc));
        }
        this.getContentPane().add((Component)this.tp, "Center");
        if (this.editMode) {
            this.setSize(480, 300);
        } else {
            this.setSize(300, 320);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.setEnabled(21, this.tp.getSelectedIndex() == 1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public TemplateInfo getTemplateInfo() {
        if (this.tp.getSelectedIndex() == 0) {
            return (TemplateInfo)this.systemDoc.getSelectedValue();
        }
        return (TemplateInfo)this.userDoc.getSelectedValue();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.tp.getSelectedIndex() == 0) {
            if (this.systemDoc.getSelectedValue() == null) {
                return;
            }
            if (this.editMode) {
                this.setEnabled(21, !((TemplateInfo)this.systemDoc.getSelectedValue()).system);
            }
        } else {
            if (this.userDoc.getSelectedValue() == null) {
                return;
            }
            if (this.editMode) {
                this.setEnabled(21, !((TemplateInfo)this.userDoc.getSelectedValue()).system);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.dispose(DialogManager.OK_ID);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class CustomCellRenderer
    extends DefaultListCellRenderer {
        CustomCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            TemplateInfo templateInfo = (TemplateInfo)object;
            jLabel.setText(templateInfo.label);
            jLabel.setIcon(templateInfo.icon);
            return jLabel;
        }
    }
}

