/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.framework.ui.toolkit.FileManager;
import com.japisoft.xmlpad.error.ErrorSelectionListener;
import com.japisoft.xmlpad.error.ErrorView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class EditixErrorPanel
extends JPanel
implements ErrorView,
ListSelectionListener,
MouseListener,
MouseMotionListener {
    private JTable table = null;
    private DefaultTableModel model = null;
    private ArrayList listeners = null;
    private ArrayList errorData = null;
    private ArrayList errorSelectionListeners = null;
    private String lastErrorLocation = null;
    static Icon INPUT_ERROR;
    static Icon OUTPUT_ERROR;
    static CustomTableRenderer RENDERER;

    private void buildit() {
        this.table = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public TableCellRenderer getDefaultRenderer(Class clazz) {
                return EditixErrorPanel.getRenderer();
            }
        };
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getActionMap().put("select-up", new SelectUp());
        this.table.getActionMap().put("select-down", new SelectDown());
        this.table.getInputMap(2).put(KeyStroke.getKeyStroke(38, 192), "select-up");
        this.table.getInputMap(2).put(KeyStroke.getKeyStroke(40, 192), "select-down");
        this.resetModel();
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.table));
        this.setPreferredSize(new Dimension(0, this.table.getTableHeader().getPreferredSize().height + this.table.getRowHeight() * 5));
    }

    public void addNotify() {
        super.addNotify();
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.table.getSelectionModel().removeListSelectionListener(this);
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    public void dispose() {
        this.listeners = null;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.displayError();
    }

    private void displayError() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            int n2 = n * 3;
            int n3 = (Integer)this.errorData.get(n2 + 2);
            boolean bl = (Boolean)this.errorData.get(n2);
            String string = (String)this.errorData.get(n2 + 1);
            String string2 = (String)this.table.getValueAt(n, 1);
            if (this.errorSelectionListeners != null) {
                for (int i = 0; i < this.errorSelectionListeners.size(); ++i) {
                    ErrorSelectionListener errorSelectionListener = (ErrorSelectionListener)this.errorSelectionListeners.get(i);
                    errorSelectionListener.errorSelected(string, n3, string2);
                }
            }
        }
    }

    public JComponent getView() {
        if (this.table == null) {
            this.buildit();
        }
        return this;
    }

    public boolean isShownForOnTheFly() {
        return false;
    }

    public void addErrorSelectionListener(ErrorSelectionListener errorSelectionListener) {
        if (this.errorSelectionListeners == null) {
            this.errorSelectionListeners = new ArrayList();
        }
        this.errorSelectionListeners.add(errorSelectionListener);
    }

    public void removeErrorSelectionListener(ErrorSelectionListener errorSelectionListener) {
        if (this.errorSelectionListeners != null) {
            this.errorSelectionListeners.remove(errorSelectionListener);
        }
    }

    public void initErrorProcessing() {
        this.model = null;
        this.errorData = null;
    }

    private void resetModel() {
        if (this.model != null && this.table != null) {
            this.table.setModel(this.model);
            this.table.getColumnModel().getColumn(0).setMaxWidth(25);
            this.table.getColumnModel().getColumn(1).setHeaderValue("<html><body><b>" + this.table.getModel().getRowCount() + " Message(s)</b> / Click on each error for highlighting <b>( ctrl-shift-up / ctrl-shift-down )</b> </body></html>");
        }
    }

    public void stopErrorProcessing() {
        this.resetModel();
        if (this.table != null) {
            this.model = null;
        }
        this.lastErrorLocation = null;
    }

    public void selectFirstError() {
        if (this.table != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditixErrorPanel.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            });
        }
    }

    public void initOnceAdded() {
        this.selectFirstError();
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        if (this.model == null && !bl2) {
            this.model = new DefaultTableModel(new Object[]{"In", "Message"}, 0);
        }
        if (!bl2) {
            if (this.errorData == null) {
                this.errorData = new ArrayList();
            }
            this.errorData.add(new Boolean(bl));
            if (string != null) {
                this.lastErrorLocation = string;
            }
            if (!bl && string == null) {
                string = this.lastErrorLocation;
            }
            this.errorData.add(string);
            this.errorData.add(new Integer(n));
            this.model.addRow(new Object[]{new Boolean(bl), string2});
        }
    }

    public void notifyNoError(boolean bl) {
    }

    static CustomTableRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new CustomTableRenderer();
        }
        return RENDERER;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() > 1) {
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            if (n > -1) {
                this.table.getSelectionModel().setSelectionInterval(n, n);
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new CopyErrorAction(this.table.getSelectedRow()));
                jPopupMenu.add(new CopyErrorsAction());
                jPopupMenu.addSeparator();
                jPopupMenu.add(new ExportErrorsAction());
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            this.displayError();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.table.rowAtPoint(point);
        if (n > -1) {
            String string = (String)this.table.getModel().getValueAt(n, 1);
            string = string.replaceAll("<", "&lt;");
            string = string.replaceAll(">", "&gt;");
            this.table.setToolTipText(EditixErrorPanel.getErrorTooltip(n, string));
        }
    }

    static String getErrorTooltip(int n, String string) {
        return "<html><body><div width='80%'><b>Error " + (n + 1) + "</b><br>" + string + "</div></body><html>";
    }

    private String getErrors() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(System.getProperty("line.separator"));
            }
            stringBuffer.append(this.table.getModel().getValueAt(i, 1));
        }
        return stringBuffer.toString();
    }

    static {
        RENDERER = null;
    }

    class SelectUp
    extends AbstractAction {
        SelectUp() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditixErrorPanel.this.table.getSelectedRow();
            if (n > 0) {
                EditixErrorPanel.this.table.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        }
    }

    class SelectDown
    extends AbstractAction {
        SelectDown() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditixErrorPanel.this.table.getSelectedRow();
            if (n < EditixErrorPanel.this.table.getRowCount() - 1) {
                EditixErrorPanel.this.table.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        }
    }

    class ExportErrorsAction
    extends AbstractAction {
        ExportErrorsAction() {
            this.putValue("Name", "Save all the errors in a file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileManager.getSelectedFile(false, "txt", "Errors file");
            if (file != null) {
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    try {
                        fileWriter.write(EditixErrorPanel.this.getErrors());
                    }
                    finally {
                        fileWriter.close();
                    }
                }
                catch (IOException iOException) {
                    EditixFactory.buildAndShowErrorDialog("Can't save to " + file);
                }
            }
        }
    }

    class CopyErrorsAction
    extends AbstractAction {
        CopyErrorsAction() {
            this.putValue("Name", "Copy all the errors to the clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringSelection stringSelection = new StringSelection(EditixErrorPanel.this.getErrors());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    class CopyErrorAction
    extends AbstractAction {
        private int row;

        CopyErrorAction(int n) {
            this.putValue("Name", "Copy this error to the clipboard");
            this.row = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.row > -1) {
                StringSelection stringSelection = new StringSelection("" + EditixErrorPanel.this.table.getModel().getValueAt(this.row, 1));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        }
    }

    static class CustomTableRenderer
    implements TableCellRenderer {
        private FastLabel error = new FastLabel();
        private JTextArea msg = new JTextArea();

        public CustomTableRenderer() {
            if (INPUT_ERROR == null) {
                INPUT_ERROR = new ImageIcon(ClassLoader.getSystemResource("images/element_into.png"));
            }
            if (OUTPUT_ERROR == null) {
                OUTPUT_ERROR = new ImageIcon(ClassLoader.getSystemResource("images/element_previous.png"));
            }
            this.msg.setLineWrap(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.error.setBackground(jTable.getSelectionBackground());
                this.error.setForeground(jTable.getSelectionForeground());
                this.msg.setBackground(jTable.getSelectionBackground());
                this.msg.setForeground(jTable.getSelectionForeground());
            } else {
                this.error.setBackground(jTable.getBackground());
                this.error.setForeground(jTable.getForeground());
                this.msg.setBackground(jTable.getBackground());
                this.msg.setForeground(jTable.getForeground());
            }
            if (n2 == 1) {
                this.msg.setText((String)object);
                return this.msg;
            }
            Boolean bl3 = (Boolean)object;
            if (bl3.booleanValue()) {
                this.error.setIcon(INPUT_ERROR);
            } else {
                this.error.setIcon(OUTPUT_ERROR);
            }
            return this.error;
        }
    }
}

