/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class FastLabel
extends JComponent
implements MouseListener {
    String text;
    private boolean border;
    private boolean center;
    boolean error;
    private boolean message;
    private Action action;
    int x = 4;
    int hc = 0;
    boolean popupMode;
    private Polygon polygon = null;
    int lastSize = 0;
    private Color DARKRED = Color.RED.darker();
    private Icon icon;
    private String errorNumber = null;

    public FastLabel(boolean bl) {
        this.border = bl;
    }

    public FastLabel(boolean bl, boolean bl2) {
        this(bl);
        this.center = bl2;
    }

    public FastLabel(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2);
        this.error = bl3;
    }

    public void setMessage(String string) {
        this.message = true;
        this.showText(string);
    }

    public void setMessageMode(boolean bl) {
        this.message = bl;
    }

    public void setText(String string) {
        this.message = false;
        this.showText(string);
    }

    private void showText(String string) {
        this.text = string;
        if (this.center && string != null) {
            this.x = 2 + (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(string)) / 2;
        }
        if (!this.error) {
            int n;
            FontMetrics fontMetrics;
            int n2;
            this.setToolTipText(string);
            if (string != null && (n2 = (fontMetrics = this.getFontMetrics(this.getFont())).stringWidth(string)) > (n = (int)((double)this.getWidth() * 0.9))) {
                int n3 = (int)((double)n / (double)n2 * (double)string.length());
                try {
                    this.text = string.substring(0, n3 - 3) + "...";
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setPopupMode(boolean bl) {
        this.popupMode = bl;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.repaint();
    }

    public void setErrorNumber(String string) {
        this.errorNumber = string;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.border) {
            graphics.setColor(Color.GRAY);
            graphics.draw3DRect(2, 2, this.getWidth() - 4, this.getHeight() - 4, true);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics, 3, 3);
        }
        if (this.text != null) {
            if (this.message) {
                graphics.setColor(Color.BLUE);
            } else {
                graphics.setColor(this.error ? Color.RED : Color.BLACK);
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.drawString(this.text, this.x, this.hc == 0 ? (this.hc = (this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent()) : this.hc);
            if (this.popupMode) {
                int n = (int)((double)this.getWidth() * 0.9);
                if (this.getWidth() != this.lastSize || this.polygon == null) {
                    this.polygon = new Polygon(new int[]{n, n + 4, n + 8}, new int[]{this.getHeight() - 5, 5, this.getHeight() - 5}, 3);
                }
                graphics.setColor(this.DARKRED);
                graphics.fillPolygon(this.polygon);
                if (this.errorNumber != null) {
                    graphics.drawString(this.errorNumber, n + 10, this.hc == 0 ? (this.hc = fontMetrics.getHeight()) : this.hc);
                }
                this.lastSize = this.getWidth();
            }
        }
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void layout() {
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

