/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels;

import com.japisoft.editix.action.panels.PanelAction;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.PanelStateListener;
import com.japisoft.editix.ui.PanelStateManager;
import com.japisoft.editix.ui.panels.Panel;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xmlpad.XMLContainer;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Action;

public class PanelManager {
    private static String shownPanel;

    public static void showByAction(String string) {
        Panel panel = PanelManager.getPanelByAction(string);
        if (panel != null) {
            panel.showPanel();
        }
    }

    public static void hideByAction(String string) {
        Panel panel = PanelManager.getPanelByAction(string);
        if (panel != null) {
            panel.hidePanel();
        }
    }

    public static void initByAction(String string) {
        Panel panel = PanelManager.getPanelByAction(string);
        if (panel != null) {
            panel.init();
        }
    }

    public static void saveState(boolean bl) {
        Iterator iterator = ActionModel.getActionsName();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Action action = ActionModel.restoreAction(string);
            if (!(action instanceof PanelAction) || !((PanelAction)action).isPrepared()) continue;
            ((PanelAction)action).preparePanel().stop();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(string).append("=").append(((PanelAction)action).preparePanel().isShown());
            if (!bl) continue;
            ((PanelAction)action).preparePanel().setState(false);
        }
        Preferences.setPreference(Preferences.SYSTEM_GP, "panelmanager.state", stringBuffer.toString());
        if (shownPanel != null) {
            Preferences.setPreference(Preferences.SYSTEM_GP, "panelmanager.shownpanel", shownPanel);
        }
    }

    public static void saveShownState(String string) {
        shownPanel = string;
    }

    public static void restoreState() {
        String string = Preferences.getPreference(Preferences.SYSTEM_GP, "panelmanager.state", (String)null);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                String string3 = string2.substring(0, n);
                boolean bl = "true".equals(string2.substring(n + 1));
                if (!bl) continue;
                PanelManager.showByAction(string3);
            }
        }
        if ((shownPanel = Preferences.getPreference(Preferences.SYSTEM_GP, "panelmanager.shownpanel", (String)null)) != null) {
            EditixFrame.dockingSpace.showPane(shownPanel);
        }
    }

    public static Panel getPanelByAction(String string) {
        Action action = ActionModel.restoreAction(string);
        if (action instanceof PanelAction) {
            return ((PanelAction)action).preparePanel();
        }
        return null;
    }

    public static Panel getShownPanelByAction(String string) {
        PanelAction panelAction;
        Action action = ActionModel.restoreAction(string);
        if (action instanceof PanelAction && (panelAction = (PanelAction)action).isPrepared()) {
            return panelAction.preparePanel();
        }
        return null;
    }

    private static void resetCurrentXMLContainerForPanels(XMLContainer xMLContainer) {
        Iterator iterator = ActionModel.getActionsName();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Action action = ActionModel.restoreAction(string);
            if (!(action instanceof PanelAction) || !((PanelAction)action).isPrepared()) continue;
            ((PanelAction)action).preparePanel().setCurrentXMLContainer(xMLContainer);
        }
    }

    static {
        PanelStateManager.addPanelStateListener(new RawPanelStateListener());
    }

    static class RawPanelStateListener
    implements PanelStateListener {
        RawPanelStateListener() {
        }

        public void newPath(String string, String string2) {
        }

        public void setCurrentXMLContainer(XMLContainer xMLContainer) {
            PanelManager.resetCurrentXMLContainerForPanels(xMLContainer);
        }

        public void close(XMLContainer xMLContainer) {
        }
    }
}

