/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xmlpad;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.ui.xmlpad.EditixComponentFactory;
import com.japisoft.editix.ui.xmlpad.EditixLineRenderer;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.look.XMLPadLook;
import com.japisoft.xmlpad.tree.renderer.FastTreeRenderer;
import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class EditixLook
extends XMLPadLook {
    public void install(XMLContainer xMLContainer, XMLEditor xMLEditor) {
        super.install(xMLContainer, xMLEditor);
        xMLEditor.setErrorLineRenderer(EditixLineRenderer.getSharedInstance());
        xMLEditor.setSelectionLineRenderer(EditixLineRenderer.getSharedInstance());
        xMLEditor.setXPathLineRenderer(EditixLineRenderer.getSharedInstance());
        xMLEditor.setBackground(Preferences.getPreference("editor", "background", Color.WHITE));
        xMLEditor.setColorForAttribute(Preferences.getPreference("editor", "attribute", Color.BLUE.brighter()));
        xMLEditor.setColorForLiteral(Preferences.getPreference("editor", "litteral", Color.RED.darker()));
        Color color = Color.BLUE.darker();
        xMLEditor.setColorForTag(Preferences.getPreference("editor", "tag", color));
        xMLEditor.setColorForDTDNotation(Preferences.getPreference("editor", "dtdnotation", color));
        xMLEditor.setColorForDTDElement(Preferences.getPreference("editor", "dtdelement", Color.CYAN.darker()));
        xMLEditor.setColorForDTDAttribute(Preferences.getPreference("editor", "dtdattribute", Color.GREEN.darker()));
        xMLEditor.setColorForDTDEntity(Preferences.getPreference("editor", "dtdentity", Color.ORANGE.darker()));
        xMLEditor.setColorForDocType(Preferences.getPreference("editor", "docType", Color.DARK_GRAY));
        xMLEditor.setColorForComment(Preferences.getPreference("editor", "comment", Color.DARK_GRAY));
        xMLEditor.setColorForNameSpace(Preferences.getPreference("editor", "namespace", Color.BLUE));
        xMLEditor.setColorForDeclaration(Preferences.getPreference("editor", "declaration", Color.DARK_GRAY));
        xMLEditor.setColorForTagDelimiter(Preferences.getPreference("editor", "tagDelimiter", Color.DARK_GRAY));
        xMLEditor.setColorForCurrentLine(Preferences.getPreference("editor", "currentLine", new Color(230, 250, 230)));
        xMLEditor.setEnableHighlightCurrentLine(Preferences.getPreference("editor", "currentLineDisplay", true));
        if (Preferences.getPreference("editor", "fullTextView", false)) {
            xMLEditor.setColorForTagEnd(xMLEditor.getColorForTagDelimiter());
            xMLEditor.setColorForDocTypeBackground(xMLEditor.getColorForDocType());
            xMLEditor.setColorForCDATABackground(xMLEditor.getColorForCDATA());
            xMLEditor.setColorForDeclarationBackground(xMLEditor.getColorForDeclaration());
            xMLEditor.setColorForCommentBackground(xMLEditor.getColorForComment());
        }
        xMLEditor.setSelectionColor(Preferences.getPreference("editor", "selection", new Color(190, 190, 240)));
        xMLEditor.setColorForText(Preferences.getPreference("editor", "text", Color.BLACK));
        xMLEditor.setSelectionHighlightColor(Color.BLUE);
        xMLEditor.setHighlightExpressionColor(Preferences.getPreference("editor", "exprHighlight", new Color(180, 240, 180)));
        xMLEditor.setColorForAttributeSeparator(xMLEditor.getColorForText());
        Color color2 = new Color(0, 128, 0);
        color2 = Preferences.getPreference("editor", "xslttag", color2);
        xMLEditor.setColorForPrefix("xsl", color2);
        xMLEditor.setColorForPrefix("xs", color2);
        xMLEditor.setInfoToolTip(Preferences.getPreference("editor", "nodeTooltip", true));
    }

    public void install(XMLContainer xMLContainer, JTree jTree) {
        super.install(xMLContainer, jTree);
        FastTreeRenderer fastTreeRenderer = (FastTreeRenderer)jTree.getCellRenderer();
        fastTreeRenderer.setTextFont(Preferences.getPreference("tree", "font", new Font("dialog", 0, 11)));
        fastTreeRenderer.setTextColor(Preferences.getPreference("tree", "text", Color.BLUE.darker()));
        fastTreeRenderer.setSelectionColor(Preferences.getPreference("tree", "selection", Color.BLUE.darker()));
        jTree.setBackground(Preferences.getPreference("tree", "background", Color.WHITE));
        try {
            fastTreeRenderer.setElementIcon(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("images/element.png")));
            fastTreeRenderer.setTextIcon(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("images/text.png")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Iterator iterator = xMLContainer.getProperties();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith("tree.renderer.node.")) continue;
                String string2 = string.substring("tree.renderer.node.".length());
                String string3 = (String)xMLContainer.getProperty(string);
                fastTreeRenderer.setAttribute(string2, string3);
            }
        }
    }

    static {
        Color color = new Color(200, 200, 200);
        LineBorder lineBorder = new LineBorder(color, 1, true);
        UIManager.put("xmlpad.editor.focusBorder", lineBorder);
        UIManager.put("xmlpad.helper.backgroundColor", new Color(240, 240, 255));
        if (EditixApplicationModel.MACOSX_MODE) {
            UIManager.put("xmlpad.tableElementView.highlightColor", color.brighter());
        }
        new EditixComponentFactory();
        SharedProperties.WRAPPED_LINE = Preferences.getPreference("editor", "lineWrapped", false);
        SharedProperties.FULL_TEXT_VIEW = Preferences.getPreference("editor", "fullTextView", true);
        Font font = null;
        font = Preferences.getPreference("editor", "font", new Font("dialog", 0, 12));
        UIManager.put("xmlpad.editor.font", font);
        SharedProperties.HELPER_PANEL = Preferences.getPreference("editor", "assistantWithComment", true);
        DialogManager.setDefaultDialogIcon("images/dialog.png");
    }
}

