/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.view;

import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.View;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AnnotationViewImpl
extends JTextArea
implements View {
    private Element initE;

    public AnnotationViewImpl() {
        this.setDocument(new CustomPlainDocument());
    }

    public void init(Element element) {
        if (element != null && "annotation".equals(element.getLocalName())) {
            element = (Element)element.getParentNode();
        }
        this.initE = element;
        this.setEnabled(this.initE != null);
        if (this.initE != null) {
            Element element2 = SchemaHelper.getChildAt(element, 0, new String[]{"annotation"});
            if (element2 != null) {
                Element element3 = SchemaHelper.getChildAt(element2, 0, new String[]{"documentation"});
                if (element3 != null) {
                    this.setText(SchemaHelper.getTexts(element3));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    public JComponent getView() {
        return this;
    }

    public void dispose() {
        this.initE = null;
    }

    public void stopEditing() {
    }

    class CustomPlainDocument
    extends PlainDocument {
        CustomPlainDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            this.resetTexts();
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            if (this.getLength() == 0) {
                Element element;
                Element element2 = SchemaHelper.getChildAt(AnnotationViewImpl.this.initE, 0, new String[]{"annotation"});
                if (element2 != null && (element = SchemaHelper.getChildAt(element2, 0, new String[]{"documentation"})) != null) {
                    element2.removeChild(element);
                    if (!SchemaHelper.hasDOMElementChild(element2)) {
                        AnnotationViewImpl.this.initE.removeChild(element2);
                    }
                }
            } else {
                this.resetTexts();
            }
        }

        private void resetTexts() {
            Element element = SchemaHelper.getChildAt(AnnotationViewImpl.this.initE, 0, new String[]{"annotation"});
            if (element == null) {
                element = SchemaHelper.createTag(AnnotationViewImpl.this.initE, "annotation");
                if (AnnotationViewImpl.this.initE.hasChildNodes()) {
                    AnnotationViewImpl.this.initE.insertBefore(element, AnnotationViewImpl.this.initE.getChildNodes().item(0));
                } else {
                    AnnotationViewImpl.this.initE.appendChild(element);
                }
                Element element2 = SchemaHelper.createTag(AnnotationViewImpl.this.initE, "documentation");
                Text text = AnnotationViewImpl.this.initE.getOwnerDocument().createTextNode(AnnotationViewImpl.this.getText());
                element2.appendChild(text);
                element.appendChild(element2);
            } else {
                Element element3 = SchemaHelper.getChildAt(element, 0, new String[]{"documentation"});
                if (element3 == null) {
                    element3 = SchemaHelper.createTag(AnnotationViewImpl.this.initE, "documentation");
                    Text text = AnnotationViewImpl.this.initE.getOwnerDocument().createTextNode(AnnotationViewImpl.this.getText());
                    element3.appendChild(text);
                    element.appendChild(element3);
                } else {
                    SchemaHelper.removeChildren(element3);
                    Text text = AnnotationViewImpl.this.initE.getOwnerDocument().createTextNode(AnnotationViewImpl.this.getText());
                    element3.appendChild(text);
                }
            }
        }
    }
}

