/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.view.element.simpletype;

import com.japisoft.editix.ui.xsd.Factory;
import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Element;

public class UnionViewImpl
extends JTable
implements View,
MouseListener {
    private Element initE;
    private Factory factory = null;
    private ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("element_delete.png"));

    public UnionViewImpl(Factory factory) {
        this.factory = factory;
        this.setModel(new UnionModel());
        this.getColumnModel().getColumn(0).setCellEditor(new SimpleTypeEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new CustomIconRenderer());
        this.getColumnModel().getColumn(1).setMaxWidth(20);
        this.addMouseListener(this);
    }

    public void init(Element element) {
        this.initE = element;
        ((UnionModel)this.getModel()).fireTableDataChanged();
    }

    public JComponent getView() {
        return this;
    }

    public void dispose() {
        ((SimpleTypeEditor)this.getColumnModel().getColumn(0).getCellEditor()).dispose();
        this.removeMouseListener(this);
        this.initE = null;
    }

    public void stopEditing() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n > -1 && n2 == 1) {
            String string = (String)this.getValueAt(n, 0);
            if (this.factory.confirmDialog("Delete " + string + " ?")) {
                SchemaHelper.deleteUnionType(this.initE, n);
                ((UnionModel)this.getModel()).fireTableDataChanged();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class SimpleTypeEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox cbb = new JComboBox();
        private EventListenerList listenerList = new EventListenerList();

        SimpleTypeEditor() {
            this.cbb.setEditable(false);
            this.cbb.addActionListener(this);
        }

        void dispose() {
            this.cbb.removeActionListener(this);
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return this.cbb.getSelectedItem();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String[] stringArray = SchemaHelper.getType(UnionViewImpl.this.initE.getOwnerDocument().getDocumentElement(), false, true);
            this.cbb.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.cbb.addItem(stringArray[i]);
            }
            this.cbb.setSelectedItem(object);
            return this.cbb;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped(new ChangeEvent(this));
        }

        private void fireEditingStopped(ChangeEvent changeEvent) {
            EventListener[] eventListenerArray = this.listenerList.getListeners(CellEditorListener.class);
            if (eventListenerArray != null) {
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((CellEditorListener)eventListenerArray[i]).editingStopped(changeEvent);
                }
            }
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.add(CellEditorListener.class, cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listenerList.remove(CellEditorListener.class, cellEditorListener);
        }
    }

    class CustomIconRenderer
    extends JButton
    implements TableCellRenderer {
        public CustomIconRenderer() {
            this.setIcon(UnionViewImpl.this.deleteIcon);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(n != UnionViewImpl.this.getRowCount() - 1);
            return this;
        }
    }

    class UnionModel
    extends AbstractTableModel {
        UnionModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Item Type";
            }
            return "D";
        }

        public int getRowCount() {
            if (UnionViewImpl.this.initE == null) {
                return 0;
            }
            String[] stringArray = SchemaHelper.getUnionTypes(UnionViewImpl.this.initE);
            return stringArray.length + 1;
        }

        public Object getValueAt(int n, int n2) {
            String[] stringArray = SchemaHelper.getUnionTypes(UnionViewImpl.this.initE);
            if (n < stringArray.length) {
                return stringArray[n];
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            boolean bl = n == this.getRowCount() - 1;
            SchemaHelper.updateUnion(UnionViewImpl.this.initE, n, (String)object);
            if (bl) {
                ((UnionModel)UnionViewImpl.this.getModel()).fireTableDataChanged();
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }
}

