/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.debug;

import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.dialog.actions.AbstractDialogAction;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.bookmark.BookmarkModel;
import com.japisoft.xmlpad.bookmark.BookmarkPosition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class BreakpointsDialog
extends EditixDialog
implements ActionListener {
    private BookmarkModel model;
    JList list = new JList();
    ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("images/breakpoint.png"));

    public BreakpointsDialog(BookmarkModel bookmarkModel) {
        super("Breakpoints List", "Breakpoints", "You can remove each breakpoint or select it", DialogManager.buildNewActionModel());
        this.model = bookmarkModel;
        this.initUI();
        AbstractDialogAction abstractDialogAction = new AbstractDialogAction(10, false){};
        abstractDialogAction.setActionDelegate(this);
        abstractDialogAction.putValue("Name", "Remove");
        abstractDialogAction.putValue("ActionCommandKey", "Remove");
        this.actionModel.addDialogAction(abstractDialogAction);
        abstractDialogAction = new AbstractDialogAction(11, false){};
        abstractDialogAction.setActionDelegate(this);
        abstractDialogAction.putValue("Name", "Select");
        abstractDialogAction.putValue("ActionCommandKey", "Select");
        this.actionModel.addDialogAction(abstractDialogAction);
    }

    protected Dimension getDefaultSize() {
        return new Dimension(350, 300);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Remove".equals(string)) {
            this.remove();
        } else if ("Select".equals(string)) {
            this.select();
        }
    }

    private void remove() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            EditixFactory.buildAndShowErrorDialog("No Selection");
        } else {
            ((DefaultListModel)this.list.getModel()).remove(n);
            BookmarkPosition bookmarkPosition = this.model.getBookmarkPositionAt(n);
            this.model.removeBookmarkPosition(bookmarkPosition);
            EditixFrame.ACCESSOR.getSelectedContainer().getEditor().getHighlighter().removeHighlight(bookmarkPosition.getHighlightFlag());
            EditixFrame.ACCESSOR.getSelectedContainer().getView().repaint();
        }
    }

    private void select() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            EditixFactory.buildAndShowErrorDialog("No Selection");
        } else {
            BookmarkPosition bookmarkPosition = this.model.getBookmarkPositionAt(n);
            int n2 = bookmarkPosition.getOffset();
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
            xMLContainer.getEditor().setCaretPosition(n2);
        }
    }

    private void initUI() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.list.setCellRenderer(new SimpleRenderer());
        for (int i = 0; i < this.model.getBookmarkCount(); ++i) {
            BookmarkPosition bookmarkPosition = this.model.getBookmarkPositionAt(i);
            defaultListModel.addElement("Breakpoint " + (i + 1));
        }
        this.list.setModel(defaultListModel);
        this.getContentPane().add(this.list);
    }

    class SimpleRenderer
    extends DefaultListCellRenderer {
        SimpleRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setIcon(BreakpointsDialog.this.icon);
            return jLabel;
        }
    }
}

