/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.sax;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.HandlerException;
import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.sax.AttributesSax2Impl;
import com.japisoft.fastparser.tools.TraceContentHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class Sax2Parser
extends Parser
implements XMLReader,
Locator {
    private ContentHandler handler;
    private ErrorHandler errorHandler;
    private String currentTag;
    private String currentLocalName;
    private String currentAttribute;
    private String currentAttributeLocal;
    private AttributesSax2Impl currentAttributes;
    private String closingTagPrefix = null;
    private Hashtable htURI;
    private Hashtable htPrefix;
    private String systemId = null;
    private boolean prolog = false;
    private boolean closeIt = false;
    private FastVector prefixToCheck = null;

    public Sax2Parser() {
        this.bufferingMode(false);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        return "http://xml.org/sax/features/namespace-prefixes".equals(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Unknown property " + string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("Unknown property " + string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        contentHandler.setDocumentLocator(this);
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void unknownEntityDetected(String string) {
        try {
            this.handler.skippedEntity(string);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.systemId = inputSource.getSystemId();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream == null) {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                this.setReader(reader);
            }
        } else {
            this.setInputStream(inputStream);
        }
        if (!this.hasReader() && inputSource.getSystemId() != null) {
            this.cCurrentFile = inputSource.getSystemId();
            inputStream = inputSource.getSystemId().indexOf(":") > 0 ? new URL(inputSource.getSystemId()).openStream() : new FileInputStream(inputSource.getSystemId());
            this.setInputStream(inputStream);
        }
        try {
            this.parse();
        }
        catch (ParseException parseException) {
            if (this.errorHandler != null) {
                this.errorHandler.error(new SAXParseException(parseException.getMessage(), null, null, parseException.getLine(), parseException.getCol()));
            }
            throw new SAXException(parseException.getMessage(), parseException);
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.systemId = string;
        this.parse(new InputSource(string));
    }

    public void parse() throws ParseException {
        if (this.handler == null) {
            throw new ParseException("No contentHandler");
        }
        try {
            this.handler.startDocument();
            this.setDocumentBuilder(null);
            super.parse();
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException.getMessage());
        }
    }

    protected void fireItemFound(int n, String string) throws ParseException {
        try {
            Object object;
            String string2 = null;
            String string3 = null;
            if (this.currentTag != null && n != 5 && n != 8 && n != 17 && n != 18) {
                this.prolog = false;
                if (this.currentAttributes == null) {
                    this.currentAttributes = new AttributesSax2Impl();
                } else if (this.prefixToCheck != null) {
                    for (int i = 0; i < this.prefixToCheck.size(); ++i) {
                        object = (String)this.prefixToCheck.get(i);
                        if (this.htURI.get(object) != null) continue;
                        throw new SAXException("Invalid prefix '" + (String)object + "'");
                    }
                    this.prefixToCheck = null;
                }
                if (this.currentLocalName != null) {
                    if (this.htURI == null) {
                        throw new SAXException("Invalid prefix '" + this.currentTag + "'");
                    }
                    String string4 = (String)this.htURI.get(this.currentTag);
                    if (string4 == null) {
                        throw new SAXException("Invalid prefix '" + this.currentTag + "'");
                    }
                    this.handler.startElement(string4, this.currentLocalName, this.currentTag + ":" + this.currentLocalName, this.currentAttributes);
                    string2 = this.currentLocalName;
                    string3 = this.currentTag;
                } else {
                    string2 = this.currentTag;
                    string3 = null;
                    this.handler.startElement("", this.currentTag, this.currentTag, this.currentAttributes);
                }
                if (this.closeIt) {
                    this.closeIt = false;
                    this.handler.endElement("", this.currentTag, this.currentTag);
                }
                this.currentAttributes = null;
                this.currentTag = null;
                this.currentLocalName = null;
            }
            switch (n) {
                case 2: {
                    this.handler.characters(string.toCharArray(), 0, string.length());
                    break;
                }
                case 3: {
                    if ("?xml".equals(string)) {
                        this.prolog = true;
                    }
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                        this.currentLocalName = null;
                        if (!this.realTimeCurrentNS) {
                            this.handler.endElement("", string, string);
                            if (this.htPrefix == null) break;
                            FastVector fastVector = (FastVector)this.htPrefix.get(string);
                            if (fastVector != null) {
                                for (int i = fastVector.size() - 1; i >= 0; --i) {
                                    this.handler.endPrefixMapping((String)fastVector.get(i));
                                }
                            }
                            break;
                        }
                        this.closingTagPrefix = string;
                        break;
                    }
                    if (this.prolog) break;
                    if (string.endsWith("/")) {
                        string = string.substring(0, string.length() - 1);
                        this.closeIt = true;
                    }
                    this.currentTag = string;
                    break;
                }
                case 5: {
                    this.currentAttribute = string;
                    break;
                }
                case 8: {
                    if (this.prolog) {
                        return;
                    }
                    if (this.currentAttributes == null) {
                        this.currentAttributes = new AttributesSax2Impl();
                    }
                    if (this.currentAttributeLocal != null) {
                        if (this.htURI == null) {
                            this.htURI = new Hashtable();
                            this.htURI.put("xml", "");
                            this.htPrefix = new Hashtable();
                        }
                        if ("xmlns".equals(this.currentAttribute)) {
                            this.handler.startPrefixMapping(this.currentAttributeLocal, string);
                            this.htURI.put(this.currentAttributeLocal, string);
                            String string5 = this.currentTag;
                            if (this.currentLocalName != null) {
                                string5 = this.currentLocalName;
                            }
                            if ((object = (FastVector)this.htPrefix.get(string5)) == null) {
                                object = new FastVector();
                                this.htPrefix.put(string5, object);
                            }
                            ((FastVector)object).add(this.currentAttributeLocal);
                        } else {
                            String string6 = (String)this.htURI.get(this.currentAttribute);
                            if (string6 == null) {
                                if (this.prefixToCheck == null) {
                                    this.prefixToCheck = new FastVector();
                                }
                                this.prefixToCheck.add(this.currentAttribute);
                            }
                            this.currentAttributes.addAttribute(this.currentAttribute, this.currentAttributeLocal, string6, "CDATA", string);
                        }
                    } else if (!"xmlns".equals(this.currentAttribute)) {
                        this.currentAttributes.addAttribute(null, this.currentAttribute, "", "CDATA", string);
                    }
                    this.currentAttributeLocal = null;
                    break;
                }
                case 10: {
                    if ("?".equals(string)) {
                        this.prolog = false;
                    }
                    if (!"/".equals(string)) break;
                    this.currentLocalName = null;
                    if (string3 == null) {
                        this.handler.endElement("", string2, string2);
                    } else {
                        if (this.htURI == null) {
                            throw new SAXException("Invalid prefix '" + string3 + "'");
                        }
                        String string7 = (String)this.htURI.get(string3);
                        if (string7 == null) {
                            throw new SAXException("Invalid prefix '" + string3 + "'");
                        }
                        this.handler.endElement(string7, string2, string3 + ":" + string2);
                        object = null;
                        object = (FastVector)this.htPrefix.get(string2);
                        if (object != null) {
                            for (int i = ((FastVector)object).size() - 1; i >= 0; --i) {
                                String string8 = (String)((FastVector)object).get(i);
                                this.handler.endPrefixMapping(string8);
                                this.htURI.remove(string8);
                            }
                        }
                    }
                    string3 = null;
                    string2 = null;
                    this.currentTag = null;
                    this.currentAttributes = null;
                    this.currentLocalName = null;
                    break;
                }
                case 13: {
                    break;
                }
                case 15: {
                    string = string.substring("[CDATA[".length() - 1, string.length());
                    this.handler.characters(string.toCharArray(), 0, string.length());
                    break;
                }
                case 17: {
                    boolean bl = false;
                    if (string.endsWith("/")) {
                        string = string.substring(0, string.length() - 1);
                        object = (String)this.htURI.get(this.currentTag);
                        if (object == null) {
                            object = "";
                        }
                        this.handler.startElement((String)object, string, this.currentTag + ":" + string, new AttributesSax2Impl());
                        this.closingTagPrefix = this.currentTag;
                        bl = true;
                    }
                    this.currentLocalName = string;
                    if (this.closingTagPrefix != null) {
                        object = (String)this.htURI.get(this.closingTagPrefix);
                        if (object == null) {
                            object = "";
                        }
                        this.handler.endElement((String)object, string, this.closingTagPrefix + ":" + string);
                        this.currentLocalName = null;
                        FastVector fastVector = (FastVector)this.htPrefix.get(string);
                        if (fastVector != null) {
                            for (int i = fastVector.size() - 1; i >= 0; --i) {
                                this.handler.endPrefixMapping((String)fastVector.get(i));
                            }
                        }
                        this.closingTagPrefix = null;
                    }
                    if (!bl) break;
                    this.currentLocalName = null;
                    this.currentTag = null;
                    break;
                }
                case 18: {
                    this.currentAttributeLocal = string;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException.getMessage());
        }
        catch (Throwable throwable) {
            throw new HandlerException(throwable);
        }
    }

    public int getColumnNumber() {
        return this.col;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public static void main(String[] stringArray) throws Exception {
        Sax2Parser sax2Parser = new Sax2Parser();
        sax2Parser.setContentHandler(new TraceContentHandler());
        sax2Parser.setInputStream(new FileInputStream("/home/japisoft/xml-samples/namespace.xml"));
        sax2Parser.parse();
        System.out.println("Ok");
    }
}

