/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.sax;

import com.japisoft.fastparser.HandlerException;
import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributeListImpl;

public final class SaxParser
extends Parser
implements org.xml.sax.Parser,
Locator {
    private DocumentHandler handler;
    private ErrorHandler errorHandler;
    private boolean start = false;
    private String currentTag;
    private String currentAttribute;
    private AttributeListImpl currentAttributes;
    private String systemId = null;

    public SaxParser() {
        this.setEnabledNameSpace(false);
        this.bufferingMode(false);
    }

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXException("Not supported");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.handler = documentHandler;
        documentHandler.setDocumentLocator(this);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.systemId = inputSource.getSystemId();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream == null) {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                this.setReader(reader);
            }
        } else {
            this.setInputStream(inputStream);
        }
        try {
            this.start = false;
            this.parse();
            if (this.handler != null) {
                this.handler.endDocument();
            }
        }
        catch (ParseException parseException) {
            if (this.errorHandler != null) {
                this.errorHandler.error(new SAXParseException(parseException.getMessage(), null, null, parseException.getLine(), parseException.getCol()));
            }
            throw new SAXException(parseException.getMessage(), parseException);
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.systemId = string;
        this.parse(new InputSource(this.systemId));
    }

    protected void fireItemFound(int n, String string) throws ParseException {
        if (this.handler == null) {
            super.fireItemFound(n, string);
        } else {
            try {
                if (!this.start) {
                    this.handler.startDocument();
                    this.start = true;
                }
                String string2 = null;
                if (this.currentTag != null && n != 5 && n != 8) {
                    if (this.currentAttributes == null) {
                        this.currentAttributes = new AttributeListImpl();
                    }
                    this.handler.startElement(this.currentTag, this.currentAttributes);
                    string2 = this.currentTag;
                    this.currentTag = null;
                    this.currentAttributes = null;
                }
                switch (n) {
                    case 2: {
                        this.handler.characters(string.toCharArray(), 0, string.length());
                        break;
                    }
                    case 3: {
                        if (string.startsWith("/")) {
                            this.handler.endElement(string.substring(1));
                            break;
                        }
                        if (string.startsWith("?") || "".equals(string)) break;
                        this.currentTag = string;
                        this.currentAttributes = null;
                        break;
                    }
                    case 5: {
                        this.currentAttribute = string;
                        break;
                    }
                    case 8: {
                        if (this.currentAttributes == null) {
                            this.currentAttributes = new AttributeListImpl();
                        }
                        this.currentAttributes.addAttribute(this.currentAttribute, null, string);
                        this.currentAttribute = null;
                        break;
                    }
                    case 10: {
                        if (!"/".equals(string)) break;
                        if (string2 == null) {
                            this.handler.endElement(this.currentTag);
                        } else {
                            this.handler.endElement(string2);
                        }
                        string2 = null;
                        this.currentTag = null;
                        this.currentAttributes = null;
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 15: {
                        string = string.substring("[CDATA[".length() - 1, string.length());
                        this.handler.characters(string.toCharArray(), 0, string.length());
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new ParseException(sAXException.getMessage());
            }
            catch (Throwable throwable) {
                throw new HandlerException(throwable);
            }
        }
    }

    public int getColumnNumber() {
        return this.col;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public static void main(String[] stringArray) throws Exception {
        SaxParser saxParser = new SaxParser();
        saxParser.setInputStream(new FileInputStream("/tmp/test.xml"));
        saxParser.parse();
        System.out.println("Ok");
    }
}

