/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ReportingListPanel
extends JPanel
implements ListSelectionListener {
    private String url = null;
    private DefaultTableModel model;
    private JTextArea zoomText;
    private JTable table;

    public ReportingListPanel(String string) {
        this.url = string;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.table = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerLocation(150);
        jSplitPane.setTopComponent(new JScrollPane(this.table));
        this.zoomText = new JTextArea();
        jSplitPane.setBottomComponent(new JScrollPane(this.zoomText));
        this.zoomText.setLineWrap(true);
        this.add(jSplitPane);
        this.model = new DefaultTableModel(new String[]{"T", "V", "Report", "Reply"}, 0);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TypeColumnRenderer());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)this.model.getValueAt(this.table.getSelectedRow(), 2);
        String string2 = (String)this.model.getValueAt(this.table.getSelectedRow(), 3);
        stringBuffer.append("- Report :\n").append(string).append("\n");
        stringBuffer.append("- Reply :\n").append(string2);
        this.zoomText.setText(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        try {
            try {
                URL uRL = new URL(this.url);
                InputStream inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        int n = string.indexOf("/");
                        if (n == -1) continue;
                        int n2 = string.indexOf("/", n + 1);
                        int n3 = string.lastIndexOf(":");
                        String string2 = string.substring(n + 1, n2);
                        string2 = string2.replaceAll("Beta", "b");
                        String string3 = string.substring(0, n);
                        String string4 = string.substring(n2 + 1, n3);
                        String string5 = string.substring(n3 + 1);
                        this.model.insertRow(0, new Object[]{string3, string2, string4, string5});
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.model.addRow(new String[]{"?", "Cannot access to the Product site...", "Please check your Internet Connection"});
            }
        }
        catch (IOException iOException) {
            this.model.addRow(new String[]{"?", "Cannot access to the Product site...", iOException.getMessage()});
        }
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.table.getSelectionModel().removeListSelectionListener(this);
    }

    class TypeColumnRenderer
    extends JLabel
    implements TableCellRenderer {
        Icon iconBug = null;
        Icon iconSug = null;

        public TypeColumnRenderer() {
            try {
                this.iconBug = new ImageIcon(ClassLoader.getSystemResource("images/bug_red16.png"));
                this.iconSug = new ImageIcon(ClassLoader.getSystemResource("images/help216.png"));
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }

        public void validate() {
        }

        public boolean isDoubleBuffered() {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if ("BUG".equals(object)) {
                this.setIcon(this.iconBug);
            } else {
                this.setIcon(this.iconSug);
            }
            return this;
        }
    }
}

