/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.ComponentFactory;
import com.japisoft.framework.dockable.DockableFrameTitleBar;
import com.japisoft.framework.dockable.InnerWindowProperties;
import com.japisoft.framework.dockable.JDock;
import com.japisoft.framework.dockable.MonoLayout;
import com.japisoft.framework.dockable.Windowable;
import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.dockable.action.BasicActionModel;
import com.japisoft.framework.dockable.action.CommonActionManager;
import com.japisoft.framework.dockable.action.DockableAction;
import com.japisoft.framework.dockable.action.ModelStateListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class BasicInnerWindow
extends JPanel
implements Windowable {
    private InnerWindowProperties properties;
    private boolean maximized = false;
    Rectangle frameBounds = null;
    private JComponent realPanel;
    private DockableFrameTitleBar tb = null;
    private CustomFocusAdapter adapter = null;
    private boolean toolbarUpdatedOnce = false;
    private boolean fixed = false;
    private boolean resize = true;
    private ActionModel actions = null;
    private JPopupMenu popup = null;
    private CustomModelStateListener commonActionsListener = null;
    private InteractionMouseListener interactionListener = null;

    public BasicInnerWindow(InnerWindowProperties innerWindowProperties) {
        this.properties = innerWindowProperties;
        this.realPanel = innerWindowProperties.isAutoScroll() ? new JScrollPane() : ComponentFactory.getComponentFactory().buildContentPaneForFrame();
        this.initUI(null);
        if (this.realPanel instanceof JScrollPane) {
            ((JScrollPane)this.realPanel).setViewportView(innerWindowProperties.getView());
        } else {
            this.realPanel.add(innerWindowProperties.getView());
        }
        this.dispatchProperties();
        this.setMinimumSize(new Dimension(10, 10));
    }

    public Dimension getMinimumSize() {
        Dimension dimension = null;
        try {
            dimension = super.getMinimumSize();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        return dimension;
    }

    private void dispatchProperties() {
        this.setTitle(this.properties.getTitle());
        this.setIcon(this.properties.getIcon());
        this.actions = this.properties.getActionModel();
    }

    public void requestFocus() {
        this.tb.focusMode(true);
    }

    private void initUI(String string) {
        super.setLayout(new BorderLayout(0, 0));
        this.tb = ComponentFactory.getComponentFactory().buildTitleBar(string);
        super.add((Component)this.tb.getView(), "North");
        super.add((Component)this.realPanel, "Center");
        if (!(this.realPanel instanceof JScrollPane)) {
            this.realPanel.setLayout(new MonoLayout());
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.commonActionsListener == null) {
            this.commonActionsListener = new CustomModelStateListener();
        }
        this.getActionModel().addModelStateListener(this.commonActionsListener);
        if (this.realPanel.getComponentCount() > 0) {
            Component component = this.realPanel.getComponent(0);
            this.adapter = new CustomFocusAdapter();
            component.addFocusListener(this.adapter);
            this.recursiveAddFocus(component);
        }
        this.interactionListener = new InteractionMouseListener();
        this.tb.getView().addMouseListener(this.interactionListener);
        this.tb.getView().addMouseMotionListener(this.interactionListener);
        if (!this.toolbarUpdatedOnce) {
            this.notifyCommonActionModelUpdated();
            this.toolbarUpdatedOnce = true;
        }
    }

    public String toString() {
        return "Frame:" + this.properties.getId();
    }

    private void recursiveAddFocus(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                container.getComponent(i).addFocusListener(this.adapter);
                if (!(container.getComponent(i) instanceof Container)) continue;
                this.recursiveAddFocus(container.getComponent(i));
            }
        }
    }

    private void recursiveRemoveFocus(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                container.getComponent(i).removeFocusListener(this.adapter);
                if (!(container.getComponent(i) instanceof Container)) continue;
                this.recursiveRemoveFocus(container.getComponent(i));
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.getActionModel().removeModelStateListener(this.commonActionsListener);
        if (this.realPanel.getComponentCount() > 0 && this.adapter != null) {
            Component component = this.realPanel.getComponent(0);
            component.removeFocusListener(this.adapter);
            this.recursiveRemoveFocus(component);
            this.adapter = null;
        }
        this.tb.getView().removeMouseListener(this.interactionListener);
        this.tb.getView().removeMouseMotionListener(this.interactionListener);
    }

    public String getTitle() {
        return this.tb.getTitle();
    }

    public String getId() {
        return this.properties.getId();
    }

    public JComponent getUserView() {
        return this.properties.getView();
    }

    public JComponent getView() {
        return this;
    }

    public void dispose() {
        this.properties.dispose();
    }

    public void setTitle(String string) {
        this.tb.setTitle(string);
    }

    public Icon getIcon() {
        return this.tb.getIcon();
    }

    public void setIcon(Icon icon) {
        this.tb.setIcon(icon);
    }

    public void setBackground(Color color) {
        if (this.tb != null) {
            this.tb.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this.tb != null) {
            this.tb.setForeground(color);
        }
    }

    public Rectangle getFrameBounds() {
        return this.frameBounds;
    }

    public void setFrameBounds(Rectangle rectangle) {
        this.frameBounds = rectangle;
    }

    public JComponent getContentPane() {
        return this.realPanel;
    }

    public void setContentPane(JComponent jComponent) {
        this.realPanel = jComponent;
        this.add((Component)this.realPanel, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isResizable() {
        return this.resize;
    }

    public void setResizable(boolean bl) {
        this.resize = bl;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean bl) {
        this.maximized = bl;
    }

    public ActionModel getActionModel() {
        if (this.actions == null) {
            this.actions = new BasicActionModel();
            CommonActionManager.fillModelWithCommonActions(this, this.actions);
        }
        for (int i = 0; i < this.actions.getActionCount(); ++i) {
            Action action = this.actions.getAction(i);
            if (!(action instanceof DockableAction)) continue;
            DockableAction dockableAction = (DockableAction)((Object)action);
            dockableAction.setDockableContext(this);
        }
        return this.actions;
    }

    private void notifyCommonActionModelUpdated() {
        CommonActionManager.fillWindowTitleBar(this.tb, this.getActionModel());
    }

    public JDock getJDock() {
        return ((JDock.InnerPanel)this.getParent()).getJDock();
    }

    public void fireDockEvent(String string, int n) {
        this.getJDock().fireJDockEvent(string, n);
    }

    private boolean activatePopup(int n, int n2) {
        ActionModel actionModel;
        if (!this.getJDock().isEnabledActionPopup()) {
            return false;
        }
        if (this.tb.getIcon() != null && n <= this.tb.getIcon().getIconWidth() && n2 <= this.tb.getIcon().getIconHeight() && (actionModel = this.getJDock().getInnerWindowActionsForId(this.getId())).getActionCount() > 0) {
            this.popup = new JPopupMenu();
            for (int i = actionModel.getActionCount() - 1; i >= 0; --i) {
                Action action = actionModel.getAction(i);
                if (action == null) {
                    if (this.popup.getComponentCount() <= 0 || i <= 0) continue;
                    this.popup.addSeparator();
                    continue;
                }
                if (action.getValue("Name") == null) {
                    if (action.getValue("ShortDescription") == null) continue;
                    JMenuItem jMenuItem = new JMenuItem();
                    jMenuItem.setAction(action);
                    jMenuItem.setText((String)action.getValue("ShortDescription"));
                    this.popup.add(jMenuItem);
                    continue;
                }
                this.popup.add(action);
            }
            this.popup.show(this, n, n2);
            return true;
        }
        return false;
    }

    private void desactivatePopup() {
        this.popup = null;
    }

    class InteractionMouseListener
    implements MouseListener,
    MouseMotionListener {
        InteractionMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (BasicInnerWindow.this.getJDock().getInnerLayout().hasMaximizedComponent()) {
                return;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicInnerWindow.this.getJDock().getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            if (BasicInnerWindow.this.popup == null) {
                BasicInnerWindow.this.getJDock().workingDrag(BasicInnerWindow.this, mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicInnerWindow.this.activatePopup(mouseEvent.getX(), mouseEvent.getY())) {
                if (BasicInnerWindow.this.getJDock().getInnerLayout().hasMaximizedComponent()) {
                    return;
                }
                BasicInnerWindow.this.getJDock().startDrag(mouseEvent, BasicInnerWindow.this);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicInnerWindow.this.desactivatePopup();
            if (BasicInnerWindow.this.getJDock().getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            BasicInnerWindow.this.getJDock().stopDrag();
        }
    }

    class CustomModelStateListener
    implements ModelStateListener {
        CustomModelStateListener() {
        }

        public void modelModified(ActionModel actionModel) {
            if (actionModel == BasicInnerWindow.this.actions) {
                BasicInnerWindow.this.notifyCommonActionModelUpdated();
            }
        }
    }

    class CustomFocusAdapter
    implements FocusListener {
        CustomFocusAdapter() {
        }

        public void focusGained(FocusEvent focusEvent) {
            BasicInnerWindow.this.tb.focusMode(true);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

