/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.preferences;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.toolkit.Logger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Preferences {
    public static String SYSTEM_GP = "system";
    public static String PREF_FILENAME = "prefDef.prop";
    static Properties preferences;
    static HashMap valueCache;

    static void cleanPreferences() {
        preferences = new Properties();
    }

    public static Properties getCurrentPreferences() {
        if (preferences == null) {
            Preferences.loadPreferences();
        }
        return preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePreferences() {
        if (preferences != null) {
            File file = ApplicationModel.getAppUserPath();
            File file2 = new File(file, PREF_FILENAME);
            try {
                OutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(file2);
                    preferences.store(outputStream, null);
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("Can't save user preferences");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPreferences() {
        Object object;
        Object object2;
        URL uRL = ClassLoader.getSystemClassLoader().getResource(PREF_FILENAME);
        Properties properties = null;
        if (uRL != null) {
            try {
                object2 = uRL.openStream();
                try {
                    properties = new Properties();
                    properties.load((InputStream)object2);
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (Throwable throwable) {
                Logger.addWarning("Can't load pref.prop : " + throwable.getMessage());
            }
        } else {
            Logger.addWarning("Can't find the default pref.prop ");
        }
        object2 = ApplicationModel.getAppUserPath();
        if (!((File)object2).exists()) {
            ((File)object2).mkdir();
        }
        File file = new File((File)object2, PREF_FILENAME);
        preferences = new Properties();
        if (file.exists()) {
            object = null;
            try {
                try {
                    object = new FileInputStream(file);
                    preferences.load((InputStream)object);
                }
                finally {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        Logger.addWarning("Can't load user preferences : " + throwable.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                Logger.addWarning("Can't load user preferences : " + iOException.getMessage());
            }
        }
        if (properties != null) {
            object = properties.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (!preferences.containsKey(string)) {
                    preferences.setProperty(string, properties.getProperty(string));
                }
                if (!string.startsWith("-")) continue;
                preferences.remove(string.substring(1));
            }
        }
    }

    public static void removeAllPreferencesForType(int n) {
        Iterator<Object> iterator = preferences.keySet().iterator();
        String string = ".type";
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = preferences.getProperty(string2);
            if (!string2.endsWith(string) || !string3.equals("" + n)) continue;
            iterator.remove();
            int n2 = string2.lastIndexOf(".");
            String string4 = string2.substring(0, n2) + ".value";
            arrayList.add(string4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            preferences.remove(arrayList.get(i));
        }
    }

    static void checkPreferencesLoad() {
        if (preferences == null) {
            Preferences.loadPreferences();
        }
    }

    static Object getValueByType(int n, String string) {
        try {
            switch (n) {
                case 0: {
                    return new Integer(string);
                }
                case 1: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                case 2: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    return new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                case 3: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    return new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                case 4: {
                    String[] stringArray;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    while (stringTokenizer.hasMoreTokens()) {
                        stringArray = stringTokenizer.nextToken();
                        arrayList.add(stringArray);
                    }
                    stringArray = new String[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        stringArray[i] = (String)arrayList.get(i);
                    }
                    return stringArray;
                }
                case 5: {
                    if (string.length() == 0) {
                        return new Character('\u0000');
                    }
                    return new Character(string.charAt(0));
                }
                case 7: {
                    return new Boolean("true".equals(string));
                }
            }
            return string;
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.addWarning("Bad value format for property in " + string);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.addWarning("Bad value for property, can't retreive number in " + string);
        }
        return null;
    }

    static int getTypeFromObject(Object object) {
        if (object instanceof Integer) {
            return 0;
        }
        if (object instanceof Color) {
            return 1;
        }
        if (object instanceof Font) {
            return 2;
        }
        if (object instanceof Rectangle) {
            return 3;
        }
        if (object instanceof String[]) {
            return 4;
        }
        if (object instanceof Character) {
            return 5;
        }
        if (object instanceof String) {
            return 6;
        }
        if (object instanceof Boolean) {
            return 7;
        }
        return -1;
    }

    static String getStringValueFromObject(Object object) {
        if (object instanceof Integer) {
            return "" + (Integer)object;
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (object instanceof Font) {
            Font font = (Font)object;
            return font.getName() + "," + font.getStyle() + "," + font.getSize();
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
        }
        if (object instanceof String[]) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[i]);
            }
            return stringBuffer.toString();
        }
        if (object instanceof Character) {
            return object.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        return null;
    }

    public static void setRawPreference(String string, String string2, Object object) {
        int n = Preferences.getTypeFromObject(object);
        String string3 = Preferences.getStringValueFromObject(object);
        String string4 = string + "." + string2 + ".type";
        String string5 = string + "." + string2 + ".value";
        if (preferences == null) {
            throw new RuntimeException("No preferences found");
        }
        preferences.put(string4, "" + n);
        preferences.put(string5, string3);
        valueCache.put(string + "." + string2 + ".value", object);
    }

    public static void removePreference(String string, String string2) {
        if (preferences == null) {
            throw new RuntimeException("No preferences found");
        }
        preferences.remove(string + "." + string2 + ".type");
        preferences.remove(string + "." + string2 + ".value");
    }

    public static void setPreference(String string, String string2, boolean bl) {
        Preferences.setRawPreference(string, string2, new Boolean(bl));
    }

    public static void setPreference(String string, String string2, String string3) {
        Preferences.setRawPreference(string, string2, string3);
    }

    public static void setPreference(String string, String string2, int n) {
        Preferences.setRawPreference(string, string2, new Integer(n));
    }

    public static int getPreference(String string, String string2, int n) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return (Integer)valueCache.get(string3);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            try {
                Integer n2 = (Integer)Preferences.getValueByType(0, preferences.getProperty(string3));
                valueCache.put(string3, n2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String string4 = string + "." + string2 + ".type";
            preferences.setProperty(string3, "" + n);
            preferences.setProperty(string4, "0");
        }
        return n;
    }

    public static boolean getPreference(String string, String string2, boolean bl) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return (Boolean)valueCache.get(string3);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            Boolean bl2 = (Boolean)Preferences.getValueByType(7, preferences.getProperty(string3));
            valueCache.put(string3, bl2);
            return bl2;
        }
        String string4 = string + "." + string2 + ".type";
        preferences.setProperty(string3, "" + bl);
        preferences.setProperty(string4, "7");
        return bl;
    }

    public static Color getPreference(String string, String string2, Color color) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return (Color)valueCache.get(string3);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            try {
                String string4 = preferences.getProperty(string3);
                Color color2 = (Color)Preferences.getValueByType(1, string4);
                valueCache.put(string3, color2);
                return color2;
            }
            catch (Throwable throwable) {}
        } else if (color != null) {
            String string5 = string + "." + string2 + ".type";
            preferences.setProperty(string3, Preferences.getStringValueFromObject(color));
            preferences.setProperty(string5, "1");
        }
        return color;
    }

    public static Font getPreference(String string, String string2, Font font) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return (Font)valueCache.get(string3);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            try {
                String string4 = preferences.getProperty(string3);
                Font font2 = (Font)Preferences.getValueByType(2, string4);
                valueCache.put(string3, font2);
                return font2;
            }
            catch (Throwable throwable) {}
        } else {
            String string5 = string + "." + string2 + ".type";
            if (font != null) {
                preferences.setProperty(string3, Preferences.getStringValueFromObject(font));
                preferences.setProperty(string5, "2");
            }
        }
        return font;
    }

    public static Rectangle getPreference(String string, String string2, Rectangle rectangle) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return (Rectangle)valueCache.get(string3);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            try {
                String string4 = preferences.getProperty(string3);
                Rectangle rectangle2 = (Rectangle)Preferences.getValueByType(3, string4);
                valueCache.put(string3, rectangle2);
                return rectangle2;
            }
            catch (Throwable throwable) {}
        } else {
            String string5 = string + "." + string2 + ".type";
            if (rectangle != null) {
                preferences.setProperty(string3, Preferences.getStringValueFromObject(rectangle));
                preferences.setProperty(string5, "3");
            }
        }
        return rectangle;
    }

    public static String[] getPreference(String string, String string2, String[] stringArray) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return (String[])valueCache.get(string3);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            try {
                String string4 = preferences.getProperty(string3);
                String[] stringArray2 = (String[])Preferences.getValueByType(4, string4);
                valueCache.put(string3, stringArray2);
                return stringArray2;
            }
            catch (Throwable throwable) {}
        } else {
            String string5 = string + "." + string2 + ".type";
            if (stringArray != null) {
                preferences.setProperty(string3, Preferences.getStringValueFromObject(stringArray));
                preferences.setProperty(string5, "4");
            }
        }
        return stringArray;
    }

    public static char getPreference(String string, String string2, char c) {
        String string3 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string3)) {
            return ((Character)valueCache.get(string3)).charValue();
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string3)) {
            try {
                String string4 = preferences.getProperty(string3);
                Character c2 = (Character)Preferences.getValueByType(5, string4);
                valueCache.put(string3, c2);
                return c2.charValue();
            }
            catch (Throwable throwable) {}
        } else {
            String string5 = string + "." + string2 + ".type";
            preferences.setProperty(string3, Preferences.getStringValueFromObject(new Character(c)));
            preferences.setProperty(string5, "5");
        }
        return c;
    }

    public static String getPreference(String string, String string2, String string3) {
        String string4 = string + "." + string2 + ".value";
        if (valueCache.containsKey(string4)) {
            return (String)valueCache.get(string4);
        }
        Preferences.checkPreferencesLoad();
        if (preferences.containsKey(string4)) {
            try {
                String string5 = preferences.getProperty(string4);
                valueCache.put(string4, string5);
                return string5;
            }
            catch (Throwable throwable) {}
        } else if (string3 != null) {
            String string6 = string + "." + string2 + ".type";
            preferences.setProperty(string4, string3);
            preferences.setProperty(string6, "6");
        }
        return string3;
    }

    static {
        valueCache = new HashMap();
    }
}

